/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.util;

import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import buildcraft.api.tools.IToolWrench;
import buildcraft.api.transport.IPipeTile;
import cofh.api.transport.IItemConduit;
import cofh.util.BlockHelper;
import cofh.util.InventoryHelper;
import cofh.util.ItemHelper;
import java.util.logging.Level;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.core.TEProps;
import thermalexpansion.item.TEItems;

public class Utils {
    public static int entityId = 0;
    public static int statId = 20000;

    public static int getEntityId() {
        return ++entityId;
    }

    public static int getStatId() {
        return ++statId;
    }

    public static final String getSoundName(String soundpath) {
        return Utils.getSoundName(soundpath, false);
    }

    public static final String getSoundName(String soundpath, boolean registering) {
        soundpath = registering ? soundpath + ".ogg" : soundpath.replaceAll("/", ".");
        return String.format("%s:%s", "thermalexpansion", soundpath);
    }

    public static int addToAdjacentInventory(TileEntity tile, int from, ItemStack stack) {
        return Utils.addToAdjacentInventory(tile.field_70329_l, tile.field_70330_m, tile.field_70327_n, tile.field_70331_k, from, stack);
    }

    public static int addToAdjacentInventory(int x, int y, int z, World worldObj, int from, ItemStack stack) {
        TileEntity theTile = BlockHelper.getAdjacentTileEntity((World)worldObj, (int)x, (int)y, (int)z, (int)from);
        if (!InventoryHelper.isInsertion((Object)theTile)) {
            return stack.field_77994_a;
        }
        return (stack = InventoryHelper.addToInsertion((Object)theTile, (int)from, (ItemStack)stack)) == null ? 0 : stack.field_77994_a;
    }

    public static int addToInventory(TileEntity theTile, int from, ItemStack stack) {
        if (!InventoryHelper.isInsertion((Object)theTile)) {
            return stack.field_77994_a;
        }
        return (stack = InventoryHelper.addToInsertion((Object)theTile, (int)from, (ItemStack)stack)) == null ? 0 : stack.field_77994_a;
    }

    public static int addToInventory(int xCoord, int yCoord, int zCoord, World worldObj, int from, ItemStack stack) {
        TileEntity theTile = worldObj.func_72796_p(xCoord, yCoord, zCoord);
        if (!InventoryHelper.isInsertion((Object)theTile)) {
            return stack.field_77994_a;
        }
        return (stack = InventoryHelper.addToInsertion((Object)theTile, (int)from, (ItemStack)stack)) == null ? 0 : stack.field_77994_a;
    }

    public static int addToInventory(IInventory theTile, int from, ItemStack stack) {
        if (!InventoryHelper.isInsertion((Object)theTile)) {
            return stack.field_77994_a;
        }
        return (stack = InventoryHelper.addToInsertion((Object)theTile, (int)from, (ItemStack)stack)) == null ? 0 : stack.field_77994_a;
    }

    public static int canAddToInventory(int xCoord, int yCoord, int zCoord, World worldObj, int from, ItemStack stack) {
        TileEntity theTile = worldObj.func_72796_p(xCoord, yCoord, zCoord);
        if (!InventoryHelper.isInventory((TileEntity)theTile)) {
            return stack.field_77994_a;
        }
        return (stack = InventoryHelper.simulateInsertItemStackIntoInventory((IInventory)((IInventory)theTile), (ItemStack)stack, (int)(from ^ 1))) == null ? 0 : stack.field_77994_a;
    }

    public static int addToAdjacentPipeTile(TileEntity tile, int side, ItemStack stack) {
        TileEntity theTile = BlockHelper.getAdjacentTileEntity((TileEntity)tile, (int)side);
        return Utils.addToPipeTile(theTile, side, stack);
    }

    public static int addToPipeTile(TileEntity theTile, int side, ItemStack stack) {
        if (theTile instanceof IPipeTile) {
            int used = ((IPipeTile)theTile).injectItem(stack, true, ForgeDirection.VALID_DIRECTIONS[side ^ 1]);
            return used;
        }
        return 0;
    }

    public static boolean isAdjacentInventory(TileEntity tile, int side) {
        return Utils.isAdjacentInventory(tile.field_70329_l, tile.field_70330_m, tile.field_70327_n, tile.field_70331_k, side);
    }

    public static boolean isAdjacentInventory(int x, int y, int z, World worldObj, int side) {
        TileEntity theTile = BlockHelper.getAdjacentTileEntity((World)worldObj, (int)x, (int)y, (int)z, (int)side);
        return Utils.isInventory(theTile, side);
    }

    public static boolean isInventory(TileEntity theTile, int side) {
        if (theTile instanceof ISidedInventory && ((ISidedInventory)theTile).func_94128_d((int)BlockHelper.SIDE_OPPOSITE[side]).length <= 0) {
            return false;
        }
        if (theTile instanceof IInventory && ((IInventory)theTile).func_70302_i_() > 0) {
            return true;
        }
        return theTile instanceof IItemConduit;
    }

    public static boolean isAdjacentPoweredTile(TileEntity tile, int side) {
        return Utils.isPoweredTile(BlockHelper.getAdjacentTileEntity((TileEntity)tile, (int)side), side);
    }

    public static boolean isHoldingNothing(EntityPlayer player) {
        return player.func_71045_bC() == null;
    }

    public static boolean isHoldingBlock(EntityPlayer player) {
        Item equipped = player.func_71045_bC() != null ? player.func_71045_bC().func_77973_b() : null;
        return equipped instanceof ItemBlock;
    }

    public static boolean isHoldingUsableWrench(EntityPlayer player, int x, int y, int z) {
        Item equipped = player.func_71045_bC() != null ? player.func_71045_bC().func_77973_b() : null;
        return equipped instanceof IToolWrench && ((IToolWrench)equipped).canWrench(player, x, y, z);
    }

    public static boolean isHoldingUsableWrench(EntityPlayer player) {
        Item equipped = player.func_71045_bC() != null ? player.func_71045_bC().func_77973_b() : null;
        return equipped instanceof IToolWrench;
    }

    public static boolean isHoldingMultimeter(EntityPlayer player, int x, int y, int z) {
        return ItemHelper.isPlayerHoldingItemStack((ItemStack)TEItems.toolMultimeter, (EntityPlayer)player);
    }

    public static boolean isHoldingServo(EntityPlayer player) {
        return ItemHelper.isPlayerHoldingItemStack((ItemStack)TEItems.pneumaticServo, (EntityPlayer)player);
    }

    public static boolean isPoweredTile(TileEntity tile, int from) {
        if (tile instanceof IPowerReceptor) {
            PowerHandler.PowerReceiver tilePP = ((IPowerReceptor)tile).getPowerReceiver(ForgeDirection.VALID_DIRECTIONS[from ^ 1]);
            return tilePP != null;
        }
        return false;
    }

    public static boolean isPowerReceptorFromSide(TileEntity theTile, ForgeDirection orientation) {
        if (theTile instanceof IPowerReceptor) {
            return ((IPowerReceptor)theTile).getPowerReceiver(orientation) != null;
        }
        return false;
    }

    public static boolean isAdjacentPipeTile(TileEntity tile, int from) {
        return BlockHelper.getAdjacentTileEntity((TileEntity)tile, (int)from) instanceof IPipeTile;
    }

    public static boolean isPipeTile(TileEntity tile) {
        return tile instanceof IPipeTile;
    }

    public static MovingObjectPosition getMovingObjectPositionFromPlayer(World world, EntityPlayer player, boolean collisionFlag) {
        float var4 = 1.0f;
        float var5 = player.field_70127_C + (player.field_70125_A - player.field_70127_C) * var4;
        float var6 = player.field_70126_B + (player.field_70177_z - player.field_70126_B) * var4;
        double var7 = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)var4;
        double var9 = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)var4 + 1.62 - (double)player.field_70129_M;
        double var11 = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)var4;
        Vec3 var13 = world.func_82732_R().func_72345_a(var7, var9, var11);
        float var14 = MathHelper.func_76134_b((float)(-var6 * ((float)Math.PI / 180) - (float)Math.PI));
        float var15 = MathHelper.func_76126_a((float)(-var6 * ((float)Math.PI / 180) - (float)Math.PI));
        float var16 = -MathHelper.func_76134_b((float)(-var5 * ((float)Math.PI / 180)));
        float var17 = MathHelper.func_76126_a((float)(-var5 * ((float)Math.PI / 180)));
        float var18 = var15 * var16;
        float var20 = var14 * var16;
        double var21 = 5.0;
        if (player instanceof EntityPlayerMP) {
            var21 = ((EntityPlayerMP)player).field_71134_c.getBlockReachDistance();
        }
        Vec3 var23 = var13.func_72441_c((double)var18 * var21, (double)var17 * var21, (double)var20 * var21);
        return world.func_72831_a(var13, var23, collisionFlag, !collisionFlag);
    }

    public static void dismantleLog(String playerName, int bId, int bMeta, double x, double y, double z) {
        if (TEProps.enableDismantleLogging) {
            ThermalExpansion.log.log(Level.INFO, "Player " + playerName + " dismantled " + " (" + bId + ":" + bMeta + ") at (" + x + "," + y + "," + z + ")");
        }
    }
}

