/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.util.crafting;

import cofh.util.ItemHelper;
import cofh.util.inventory.ComparableItemStackSafe;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraftforge.oredict.OreDictionary;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.item.TEItems;

public class FurnaceManager {
    private static Map<ComparableItemStackSafe, RecipeFurnace> recipeMap = new HashMap<ComparableItemStackSafe, RecipeFurnace>();
    private static ComparableItemStackSafe query = new ComparableItemStackSafe(new ItemStack(Block.field_71981_t));
    private static boolean allowOverwrite = false;
    public static final int DEFAULT_ENERGY = 1600;

    public static RecipeFurnace getRecipe(ItemStack input) {
        if (input == null) {
            return null;
        }
        RecipeFurnace recipe = recipeMap.get(query.set(input));
        if (recipe == null) {
            FurnaceManager.query.metadata = Short.MAX_VALUE;
            recipe = recipeMap.get(query);
        }
        return recipe;
    }

    public static boolean recipeExists(ItemStack input) {
        return FurnaceManager.getRecipe(input) != null;
    }

    public static RecipeFurnace[] getRecipeList() {
        return recipeMap.values().toArray(new RecipeFurnace[0]);
    }

    public static void addDefaultRecipes() {
        FurnaceManager.addTERecipe(800, new ItemStack(Block.field_72038_aV), new ItemStack(Item.field_77756_aW, 1, 2));
        FurnaceManager.addTERecipe(400, new ItemStack(Item.field_77784_aq), new ItemStack(Item.field_77782_ar));
        FurnaceManager.addTERecipe(400, new ItemStack(Item.field_77754_aU), new ItemStack(Item.field_77753_aV));
        FurnaceManager.addTERecipe(400, new ItemStack(Item.field_77741_bi), new ItemStack(Item.field_77734_bj));
        FurnaceManager.addTERecipe(400, new ItemStack(Item.field_77735_bk), new ItemStack(Item.field_77736_bl));
        FurnaceManager.addTERecipe(400, new ItemStack(Item.field_82794_bL), new ItemStack(Item.field_82795_bM));
    }

    public static void loadRecipes() {
        ItemStack output;
        ItemStack input;
        FurnaceManager.addDefaultRecipes();
        int energy = 1600;
        FurnaceManager.addOreDictRecipe(energy, "oreCopper", TEItems.ingotCopper);
        FurnaceManager.addOreDictRecipe(energy, "oreTin", TEItems.ingotTin);
        FurnaceManager.addOreDictRecipe(energy, "oreSilver", TEItems.ingotSilver);
        FurnaceManager.addOreDictRecipe(energy, "oreLead", TEItems.ingotLead);
        FurnaceManager.addOreDictRecipe(energy, "oreNickel", TEItems.ingotNickel);
        FurnaceManager.addOreDictRecipe(energy, "orePlatinum", TEItems.ingotPlatinum);
        energy = 1000;
        FurnaceManager.addOreDictRecipe(energy, "dustCopper", TEItems.ingotCopper);
        FurnaceManager.addOreDictRecipe(energy, "dustTin", TEItems.ingotTin);
        FurnaceManager.addOreDictRecipe(energy, "dustSilver", TEItems.ingotSilver);
        FurnaceManager.addOreDictRecipe(energy, "dustLead", TEItems.ingotLead);
        FurnaceManager.addOreDictRecipe(energy, "dustNickel", TEItems.ingotNickel);
        FurnaceManager.addOreDictRecipe(energy, "dustPlatinum", TEItems.ingotPlatinum);
        FurnaceManager.addOreDictRecipe(energy, "dustElectrum", TEItems.ingotElectrum);
        FurnaceManager.addOreDictRecipe(energy, "dustInvar", TEItems.ingotInvar);
        FurnaceManager.addOreDictRecipe(energy, "dustBronze", TEItems.ingotBronze);
        Map metaSmeltingList = FurnaceRecipes.func_77602_a().getMetaSmeltingList();
        Map smeltingList = FurnaceRecipes.func_77602_a().func_77599_b();
        for (Object key : metaSmeltingList.keySet()) {
            energy = 1600;
            input = new ItemStack(((Integer)key.get(0)).intValue(), 1, ((Integer)key.get(1)).intValue());
            output = (ItemStack)metaSmeltingList.get(key);
            if (ItemHelper.isDust((ItemStack)input) && ItemHelper.isIngot((ItemStack)output)) {
                FurnaceManager.addRecipe(energy * 10 / 16, input, output, false);
                continue;
            }
            FurnaceManager.addRecipe(energy, input, output, false);
        }
        for (Object key : smeltingList.keySet()) {
            energy = 1600;
            input = new ItemStack(((Integer)key).intValue(), 1, 0);
            if (FurnaceManager.recipeExists(input)) continue;
            if (!ItemHelper.hasOreName((ItemStack)input) || ComparableItemStackSafe.getOreID((ItemStack)input) == -1) {
                input = new ItemStack(((Integer)key).intValue(), 1, Short.MAX_VALUE);
            }
            output = (ItemStack)smeltingList.get(key);
            if (ItemHelper.isDust((ItemStack)input) && ItemHelper.isIngot((ItemStack)output)) {
                FurnaceManager.addRecipe(energy * 10 / 16, input, output, false);
                continue;
            }
            FurnaceManager.addRecipe(energy, input, output, false);
        }
    }

    public static boolean addTERecipe(int energy, ItemStack input, ItemStack output) {
        if (input == null || output == null || energy <= 0) {
            return false;
        }
        RecipeFurnace recipe = new RecipeFurnace(input, output, energy);
        recipeMap.put(new ComparableItemStackSafe(input), recipe);
        return true;
    }

    public static boolean addRecipe(int energy, ItemStack input, ItemStack output, boolean overwrite) {
        if (input == null || output == null || energy <= 0 || !(allowOverwrite & overwrite) && recipeMap.get(query.set(input)) != null) {
            return false;
        }
        RecipeFurnace recipe = new RecipeFurnace(input, output, energy);
        recipeMap.put(new ComparableItemStackSafe(input), recipe);
        return true;
    }

    public static void addOreDictRecipe(String oreName, ItemStack output) {
        FurnaceManager.addOreDictRecipe(1600, oreName, output);
    }

    public static void addOreDictRecipe(int energy, String oreName, ItemStack output) {
        if (ItemHelper.oreNameExists((String)oreName)) {
            FurnaceManager.addRecipe(energy, ItemHelper.cloneStack((ItemStack)((ItemStack)OreDictionary.getOres((String)oreName).get(0)), (int)1), output, false);
        }
    }

    static {
        allowOverwrite = ThermalExpansion.config.get("tweak.crafting", "Furnace.AllowRecipeOverwrite", false);
    }

    public static class RecipeFurnace {
        final ItemStack input;
        final ItemStack output;
        final int energy;

        RecipeFurnace(ItemStack input, ItemStack output, int energy) {
            this.input = input;
            this.output = output;
            this.energy = energy;
        }

        public ItemStack getInput() {
            return this.input.func_77946_l();
        }

        public ItemStack getOutput() {
            return this.output.func_77946_l();
        }

        public int getEnergy() {
            return this.energy;
        }
    }
}

