/*
 * Decompiled with CFR 0.152.
 */
package thermalexpansion.util.crafting;

import cofh.util.ItemHelper;
import cofh.util.inventory.ComparableItemStack;
import cofh.util.inventory.ComparableItemStackSafe;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import thermalexpansion.ThermalExpansion;
import thermalexpansion.fluid.TEFluids;
import thermalexpansion.item.TEItems;

public class TransposerManager {
    private static Map<List, RecipeTransposer> recipeMapFill = new HashMap<List, RecipeTransposer>();
    private static Map<ComparableItemStackSafe, RecipeTransposer> recipeMapExtraction = new HashMap<ComparableItemStackSafe, RecipeTransposer>();
    private static Set<ComparableItemStackSafe> validationSet = new HashSet<ComparableItemStackSafe>();
    private static ComparableItemStack query = new ComparableItemStackSafe(new ItemStack(Block.field_71981_t));
    private static boolean allowOverwrite = false;

    public static RecipeTransposer getFillRecipe(ItemStack input, FluidStack fluid) {
        if (input == null || fluid == null) {
            return null;
        }
        return recipeMapFill.get(Arrays.asList(query.set(input).hashCode(), fluid.fluidID));
    }

    public static RecipeTransposer getExtractionRecipe(ItemStack input) {
        if (input == null) {
            return null;
        }
        return recipeMapExtraction.get(query.set(input));
    }

    public static boolean fillRecipeExists(ItemStack input, FluidStack fluid) {
        return TransposerManager.getFillRecipe(input, fluid) != null;
    }

    public static boolean extractionRecipeExists(ItemStack input, FluidStack fluid) {
        return TransposerManager.getExtractionRecipe(input) != null;
    }

    public static RecipeTransposer[] getFillRecipeList() {
        return recipeMapFill.values().toArray(new RecipeTransposer[0]);
    }

    public static RecipeTransposer[] getExtractionRecipeList() {
        return recipeMapExtraction.values().toArray(new RecipeTransposer[0]);
    }

    public static boolean isItemValid(ItemStack input) {
        if (input == null) {
            return false;
        }
        return validationSet.contains(query.set(input));
    }

    public static void addDefaultRecipes() {
        TransposerManager.addFillRecipe(8000, new ItemStack(Block.field_71978_w), new ItemStack(Block.field_72087_ao), new FluidStack(FluidRegistry.WATER, 250), false);
        TransposerManager.addFillRecipe(8000, new ItemStack(Block.field_72007_bm), new ItemStack(Block.field_72007_bm, 1, 1), new FluidStack(FluidRegistry.WATER, 250), false);
        TransposerManager.addFillRecipe(8000, new ItemStack(Block.field_71957_Q), new ItemStack(Block.field_72082_bJ), new FluidStack(TEFluids.fluidEnder, 250), false);
        TransposerManager.addTEFillRecipe(4000, new ItemStack(Item.field_77751_aT), new ItemStack(Item.field_77722_bw), new FluidStack(TEFluids.fluidRedstone, 200), false);
        TransposerManager.addTEFillRecipe(4000, new ItemStack(Item.field_77768_aD), ItemHelper.cloneStack((ItemStack)TEItems.dustBlizz, (int)1), new FluidStack(TEFluids.fluidRedstone, 200), false);
        TransposerManager.addTEFillRecipe(800, new ItemStack(Item.field_77788_aw), ItemHelper.cloneStack((ItemStack)TEFluids.bucketRedstone, (int)1), new FluidStack(TEFluids.fluidRedstone, 1000), true);
        TransposerManager.addTEFillRecipe(800, new ItemStack(Item.field_77788_aw), ItemHelper.cloneStack((ItemStack)TEFluids.bucketGlowstone, (int)1), new FluidStack(TEFluids.fluidGlowstone, 1000), true);
        TransposerManager.addTEFillRecipe(800, new ItemStack(Item.field_77788_aw), ItemHelper.cloneStack((ItemStack)TEFluids.bucketEnder, (int)1), new FluidStack(TEFluids.fluidEnder, 1000), true);
        TransposerManager.addTEFillRecipe(800, new ItemStack(Item.field_77788_aw), ItemHelper.cloneStack((ItemStack)TEFluids.bucketPyrotheum, (int)1), new FluidStack(TEFluids.fluidPyrotheum, 1000), true);
        TransposerManager.addTEFillRecipe(800, new ItemStack(Item.field_77788_aw), ItemHelper.cloneStack((ItemStack)TEFluids.bucketCryotheum, (int)1), new FluidStack(TEFluids.fluidCryotheum, 1000), true);
        TransposerManager.addTEFillRecipe(800, new ItemStack(Item.field_77788_aw), ItemHelper.cloneStack((ItemStack)TEFluids.bucketCoal, (int)1), new FluidStack(TEFluids.fluidCoal, 1000), true);
    }

    public static void loadRecipes() {
        TransposerManager.addDefaultRecipes();
        TransposerManager.addFillRecipe(1600, ItemHelper.getOre((String)"oreCinnabar"), ItemHelper.cloneStack((ItemStack)TEItems.crystalCinnabar, (int)1), new FluidStack(TEFluids.fluidCryotheum, 200), false);
        for (FluidContainerRegistry.FluidContainerData data : FluidContainerRegistry.getRegisteredFluidContainerData()) {
            if (FluidContainerRegistry.isBucket((ItemStack)data.emptyContainer)) {
                TransposerManager.addFillRecipe(800, data, true);
                continue;
            }
            TransposerManager.addFillRecipe(1600, data, true);
        }
    }

    public static boolean addTEFillRecipe(int energy, ItemStack input, ItemStack output, FluidStack fluid, boolean reversible) {
        if (input == null || output == null || fluid == null || fluid.amount <= 0 || energy <= 0) {
            return false;
        }
        RecipeTransposer recipeFill = new RecipeTransposer(input, output, fluid, energy, 100);
        recipeMapFill.put(Arrays.asList(new ComparableItemStackSafe(input).hashCode(), fluid.fluidID), recipeFill);
        validationSet.add(new ComparableItemStackSafe(input));
        if (reversible) {
            TransposerManager.addTEExtractionRecipe(energy, output, input, fluid, 100, false);
        }
        return true;
    }

    public static boolean addTEExtractionRecipe(int energy, ItemStack input, ItemStack output, FluidStack fluid, int chance, boolean reversible) {
        if (input == null || fluid == null || fluid.amount <= 0 || energy <= 0) {
            return false;
        }
        if (output == null && reversible) {
            return false;
        }
        if (output == null && chance != 0) {
            return false;
        }
        RecipeTransposer recipeExtraction = new RecipeTransposer(input, output, fluid, energy, chance);
        recipeMapExtraction.put(new ComparableItemStackSafe(input), recipeExtraction);
        validationSet.add(new ComparableItemStackSafe(input));
        if (reversible) {
            TransposerManager.addTEFillRecipe(energy, output, input, fluid, false);
        }
        return true;
    }

    public static boolean addFillRecipe(int energy, ItemStack input, ItemStack output, FluidStack fluid, boolean reversible, boolean overwrite) {
        if (input == null || output == null || fluid == null || fluid.amount <= 0 || energy <= 0 || !(allowOverwrite & overwrite) && TransposerManager.fillRecipeExists(input, fluid)) {
            return false;
        }
        RecipeTransposer recipeFill = new RecipeTransposer(input, output, fluid, energy, 100);
        recipeMapFill.put(Arrays.asList(new ComparableItemStackSafe(input).hashCode(), fluid.fluidID), recipeFill);
        validationSet.add(new ComparableItemStackSafe(input));
        if (reversible) {
            TransposerManager.addExtractionRecipe(energy, output, input, fluid, 100, false, overwrite);
        }
        return true;
    }

    public static boolean addExtractionRecipe(int energy, ItemStack input, ItemStack output, FluidStack fluid, int chance, boolean reversible, boolean overwrite) {
        if (input == null || fluid == null || fluid.amount <= 0 || energy <= 0 || !overwrite && TransposerManager.extractionRecipeExists(input, fluid)) {
            return false;
        }
        if (output == null && reversible || output == null && chance != 0) {
            return false;
        }
        RecipeTransposer recipeExtraction = new RecipeTransposer(input, output, fluid, energy, chance);
        recipeMapExtraction.put(new ComparableItemStackSafe(input), recipeExtraction);
        validationSet.add(new ComparableItemStackSafe(input));
        if (reversible) {
            TransposerManager.addFillRecipe(energy, output, input, fluid, false, overwrite);
        }
        return true;
    }

    public static boolean addFillRecipe(int energy, FluidContainerRegistry.FluidContainerData data, boolean reversible) {
        return TransposerManager.addFillRecipe(energy, data.emptyContainer, data.filledContainer, data.fluid, reversible, false);
    }

    public static boolean addFillRecipe(int energy, ItemStack input, ItemStack output, FluidStack fluid, boolean reversible) {
        return TransposerManager.addFillRecipe(energy, input, output, fluid, reversible, false);
    }

    public static boolean addExtractionRecipe(int energy, ItemStack input, ItemStack output, FluidStack fluid, int chance, boolean reversible) {
        return TransposerManager.addExtractionRecipe(energy, input, output, fluid, chance, reversible, false);
    }

    static {
        allowOverwrite = ThermalExpansion.config.get("tweak.crafting", "Transposer.AllowRecipeOverwrite", false);
    }

    public static class RecipeTransposer {
        final ItemStack input;
        final ItemStack output;
        final FluidStack fluid;
        final int energy;
        final int chance;

        RecipeTransposer(ItemStack input, ItemStack output, FluidStack fluid, int energy, int chance) {
            this.input = input;
            this.output = output;
            this.fluid = fluid;
            this.energy = energy;
            this.chance = chance;
        }

        public ItemStack getInput() {
            return this.input.func_77946_l();
        }

        public ItemStack getOutput() {
            if (this.output != null) {
                return this.output.func_77946_l();
            }
            return null;
        }

        public FluidStack getFluid() {
            return this.fluid.copy();
        }

        public int getEnergy() {
            return this.energy;
        }

        public int getChance() {
            return this.chance;
        }
    }
}

