/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Arrays;
import mods.railcraft.common.blocks.machine.BlockMachine;
import mods.railcraft.common.blocks.machine.ItemMachine;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.blocks.machine.alpha.MachineProxyAlpha;
import mods.railcraft.common.blocks.machine.beta.EnumMachineBeta;
import mods.railcraft.common.blocks.machine.beta.MachineProxyBeta;
import mods.railcraft.common.blocks.machine.delta.EnumMachineDelta;
import mods.railcraft.common.blocks.machine.delta.MachineProxyDelta;
import mods.railcraft.common.blocks.machine.gamma.EnumMachineGamma;
import mods.railcraft.common.blocks.machine.gamma.MachineProxyGamma;
import mods.railcraft.common.blocks.signals.BlockSignal;
import mods.railcraft.common.blocks.signals.ItemSignal;
import mods.railcraft.common.blocks.tracks.BlockTrack;
import mods.railcraft.common.blocks.tracks.BlockTrackElevator;
import mods.railcraft.common.blocks.tracks.ItemTrack;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.items.RailcraftPartItems;
import mods.railcraft.common.plugins.forge.CraftingPlugin;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import mods.railcraft.common.plugins.forge.ItemRegistry;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;

public class RailcraftBlocks {
    private static Block blockMachineAlpha;
    private static Block blockMachineBeta;
    private static Block blockMachineGamma;
    private static Block blockMachineDelta;
    private static Block blockTrack;
    private static Block blockRailElevator;
    private static Block blockSignal;

    public static void registerBlockTrack() {
        int id;
        if (blockTrack == null && (id = RailcraftConfig.getBlockId("block.track")) > 0) {
            int renderId = Railcraft.getProxy().getRenderId();
            blockTrack = new BlockTrack(id, renderId).func_71864_b("railcraft.track");
            GameRegistry.registerBlock((Block)blockTrack, ItemTrack.class, (String)blockTrack.func_71917_a());
            MinecraftForge.setBlockHarvestLevel((Block)blockTrack, (String)"crowbar", (int)0);
            MinecraftForge.setBlockHarvestLevel((Block)blockTrack, (String)"pickaxe", (int)0);
        }
    }

    public static Block getBlockTrack() {
        return blockTrack;
    }

    public static void registerBlockRailElevator() {
        int id;
        if (blockRailElevator == null && (id = RailcraftConfig.getBlockId("block.elevator")) > 0) {
            int renderId = Railcraft.getProxy().getRenderId();
            blockRailElevator = new BlockTrackElevator(id, renderId).func_71864_b("railcraft.track.elevator");
            GameRegistry.registerBlock((Block)blockRailElevator, (String)blockRailElevator.func_71917_a());
            MinecraftForge.setBlockHarvestLevel((Block)blockRailElevator, (String)"crowbar", (int)0);
            MinecraftForge.setBlockHarvestLevel((Block)blockRailElevator, (String)"pickaxe", (int)0);
            ItemStack stackElevator = new ItemStack(blockRailElevator, 8);
            CraftingPlugin.addShapedRecipe(stackElevator, "IRI", "ISI", "IRI", Character.valueOf('I'), RailcraftConfig.useOldRecipes() ? Item.field_77717_p : RailcraftPartItems.getRailAdvanced(), Character.valueOf('S'), RailcraftConfig.useOldRecipes() ? Item.field_77703_o : RailcraftPartItems.getRailStandard(), Character.valueOf('R'), Item.field_77767_aC);
            RailcraftLanguage.instance().registerItemName(stackElevator, "track.elevator");
            ItemRegistry.registerItemStack("track.elevator", stackElevator);
        }
    }

    public static Block getBlockElevator() {
        return blockRailElevator;
    }

    public static void registerBlockMachineAlpha() {
        int id;
        if (blockMachineAlpha == null && (id = RailcraftConfig.getBlockId("block.machine.alpha")) > 0) {
            int[] lightOpacity = new int[16];
            Arrays.fill(lightOpacity, 255);
            blockMachineAlpha = new BlockMachine(id, 0, new MachineProxyAlpha(), true, lightOpacity).func_71864_b("railcraft.machine.alpha");
            GameRegistry.registerBlock((Block)blockMachineAlpha, ItemMachine.class, (String)blockMachineAlpha.func_71917_a());
            block4: for (EnumMachineAlpha type : EnumMachineAlpha.values()) {
                switch (type) {
                    case FEED_STATION: 
                    case TANK_WATER: {
                        MinecraftForge.setBlockHarvestLevel((Block)blockMachineAlpha, (int)type.ordinal(), (String)"axe", (int)1);
                        MinecraftForge.setBlockHarvestLevel((Block)blockMachineAlpha, (int)type.ordinal(), (String)"crowbar", (int)0);
                        continue block4;
                    }
                    case WORLD_ANCHOR: 
                    case PERSONAL_ANCHOR: {
                        MinecraftForge.setBlockHarvestLevel((Block)blockMachineAlpha, (int)type.ordinal(), (String)"pickaxe", (int)3);
                        MinecraftForge.setBlockHarvestLevel((Block)blockMachineAlpha, (int)type.ordinal(), (String)"crowbar", (int)0);
                        continue block4;
                    }
                    default: {
                        MinecraftForge.setBlockHarvestLevel((Block)blockMachineAlpha, (int)type.ordinal(), (String)"pickaxe", (int)2);
                        MinecraftForge.setBlockHarvestLevel((Block)blockMachineAlpha, (int)type.ordinal(), (String)"crowbar", (int)0);
                    }
                }
            }
        }
    }

    public static Block getBlockMachineAlpha() {
        return blockMachineAlpha;
    }

    public static void registerBlockMachineBeta() {
        int id;
        if (blockMachineBeta == null && (id = RailcraftConfig.getBlockId("block.machine.beta")) > 0) {
            int renderId = Railcraft.getProxy().getRenderId();
            int[] lightOpacity = new int[16];
            Arrays.fill(lightOpacity, 255);
            lightOpacity[EnumMachineBeta.ENGINE_STEAM_HOBBY.ordinal()] = 0;
            lightOpacity[EnumMachineBeta.ENGINE_STEAM_LOW.ordinal()] = 0;
            lightOpacity[EnumMachineBeta.ENGINE_STEAM_HIGH.ordinal()] = 0;
            lightOpacity[EnumMachineBeta.TANK_IRON_WALL.ordinal()] = 0;
            lightOpacity[EnumMachineBeta.TANK_IRON_VALVE.ordinal()] = 0;
            lightOpacity[EnumMachineBeta.TANK_IRON_GAUGE.ordinal()] = 0;
            lightOpacity[EnumMachineBeta.TANK_STEEL_WALL.ordinal()] = 0;
            lightOpacity[EnumMachineBeta.TANK_STEEL_VALVE.ordinal()] = 0;
            lightOpacity[EnumMachineBeta.TANK_STEEL_GAUGE.ordinal()] = 0;
            lightOpacity[EnumMachineBeta.BOILER_TANK_LOW_PRESSURE.ordinal()] = 0;
            lightOpacity[EnumMachineBeta.BOILER_TANK_HIGH_PRESSURE.ordinal()] = 0;
            lightOpacity[EnumMachineBeta.SENTINEL.ordinal()] = 0;
            lightOpacity[EnumMachineBeta.VOID_CHEST.ordinal()] = 0;
            blockMachineBeta = new BlockMachine(id, renderId, new MachineProxyBeta(), false, lightOpacity).func_71864_b("railcraft.machine.beta");
            GameRegistry.registerBlock((Block)blockMachineBeta, ItemMachine.class, (String)blockMachineBeta.func_71917_a());
            block3: for (EnumMachineBeta type : EnumMachineBeta.values()) {
                switch (type) {
                    case SENTINEL: {
                        MinecraftForge.setBlockHarvestLevel((Block)blockMachineAlpha, (int)type.ordinal(), (String)"pickaxe", (int)3);
                        MinecraftForge.setBlockHarvestLevel((Block)blockMachineAlpha, (int)type.ordinal(), (String)"crowbar", (int)0);
                        continue block3;
                    }
                    default: {
                        MinecraftForge.setBlockHarvestLevel((Block)blockMachineBeta, (int)type.ordinal(), (String)"pickaxe", (int)2);
                        MinecraftForge.setBlockHarvestLevel((Block)blockMachineBeta, (int)type.ordinal(), (String)"crowbar", (int)0);
                    }
                }
            }
        }
    }

    public static Block getBlockMachineBeta() {
        return blockMachineBeta;
    }

    public static void registerBlockMachineGamma() {
        int id;
        if (blockMachineGamma == null && (id = RailcraftConfig.getBlockId("block.machine.gamma")) > 0) {
            int[] lightOpacity = new int[16];
            Arrays.fill(lightOpacity, 255);
            lightOpacity[EnumMachineGamma.LIQUID_LOADER.ordinal()] = 0;
            lightOpacity[EnumMachineGamma.LIQUID_UNLOADER.ordinal()] = 0;
            blockMachineGamma = new BlockMachine(id, 0, new MachineProxyGamma(), false, lightOpacity).func_71864_b("railcraft.machine.gamma");
            blockMachineGamma.func_71849_a(CreativeTabs.field_78029_e);
            GameRegistry.registerBlock((Block)blockMachineGamma, ItemMachine.class, (String)blockMachineGamma.func_71917_a());
            for (EnumMachineGamma type : EnumMachineGamma.values()) {
                switch (type) {
                    default: 
                }
                MinecraftForge.setBlockHarvestLevel((Block)blockMachineGamma, (int)type.ordinal(), (String)"pickaxe", (int)2);
                MinecraftForge.setBlockHarvestLevel((Block)blockMachineGamma, (int)type.ordinal(), (String)"crowbar", (int)0);
            }
        }
    }

    public static Block getBlockMachineGamma() {
        return blockMachineGamma;
    }

    public static void registerBlockMachineDelta() {
        int id;
        if (blockMachineDelta == null && (id = RailcraftConfig.getBlockId("block.machine.delta")) > 0) {
            int renderId = Railcraft.getProxy().getRenderId();
            int[] lightOpacity = new int[16];
            Arrays.fill(lightOpacity, 255);
            lightOpacity[EnumMachineDelta.CAGE.ordinal()] = 0;
            blockMachineDelta = new BlockMachine(id, renderId, new MachineProxyDelta(), false, lightOpacity).func_71864_b("railcraft.machine.delta");
            blockMachineDelta.func_71849_a(CreativePlugin.TAB);
            GameRegistry.registerBlock((Block)blockMachineDelta, ItemMachine.class, (String)blockMachineDelta.func_71917_a());
            for (EnumMachineDelta type : EnumMachineDelta.values()) {
                switch (type) {
                    default: 
                }
                MinecraftForge.setBlockHarvestLevel((Block)blockMachineDelta, (int)type.ordinal(), (String)"pickaxe", (int)2);
                MinecraftForge.setBlockHarvestLevel((Block)blockMachineDelta, (int)type.ordinal(), (String)"crowbar", (int)0);
            }
        }
    }

    public static Block getBlockMachineDelta() {
        return blockMachineDelta;
    }

    public static void registerBlockSignal() {
        int id;
        if (blockSignal == null && (id = RailcraftConfig.getBlockId("block.signal")) > 0) {
            int renderId = Railcraft.getProxy().getRenderId();
            blockSignal = new BlockSignal(id, renderId);
            GameRegistry.registerBlock((Block)blockSignal, ItemSignal.class, (String)blockSignal.func_71917_a());
            MinecraftForge.setBlockHarvestLevel((Block)blockSignal, (String)"pickaxe", (int)2);
            MinecraftForge.setBlockHarvestLevel((Block)blockSignal, (String)"crowbar", (int)0);
        }
    }

    public static Block getBlockSignal() {
        return blockSignal;
    }
}

