/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.aesthetics.glass;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import mods.railcraft.client.util.textures.TextureAtlasSheet;
import mods.railcraft.common.blocks.aesthetics.glass.ItemStrengthGlass;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.plugins.forestry.ForestryPlugin;
import mods.railcraft.common.plugins.forge.CreativePlugin;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.plugins.misc.MicroBlockPlugin;
import mods.railcraft.common.util.misc.EnumColor;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGlass;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class BlockStrengthGlass
extends BlockGlass {
    private static BlockStrengthGlass instance;
    public static boolean renderingHighlight;
    private final int renderId;
    private Icon[] icons;
    private Map patterns = new HashMap();

    public static BlockStrengthGlass getBlock() {
        return instance;
    }

    public static void registerBlock() {
        int id;
        if (instance == null && (id = RailcraftConfig.getBlockId("block.glass")) > 0) {
            instance = new BlockStrengthGlass(id, Railcraft.proxy.getRenderId());
            GameRegistry.registerBlock((Block)instance, ItemStrengthGlass.class, (String)instance.func_71917_a());
            ForestryPlugin.addBackpackItem("builder", BlockStrengthGlass.instance.field_71990_ca);
            for (int meta = 0; meta < 16; ++meta) {
                MicroBlockPlugin.addMicroBlockCandidate((Block)instance, meta);
            }
        }
    }

    public static ItemStack getItem(int meta) {
        return BlockStrengthGlass.getItem(1, meta);
    }

    public static ItemStack getItem(int qty, int meta) {
        if (instance == null) {
            return null;
        }
        return new ItemStack((Block)instance, qty, meta);
    }

    public BlockStrengthGlass(int id, int renderId) {
        super(id, Material.field_76264_q, false);
        this.renderId = renderId;
        this.func_71894_b(5.0f);
        this.func_71848_c(1.0f);
        this.func_71884_a(Block.field_71974_j);
        this.func_71849_a(CreativePlugin.TAB);
        this.func_71864_b("railcraft.glass");
    }

    public int func_71857_b() {
        return this.renderId;
    }

    public int func_71885_a(int par1, Random par2Random, int par3) {
        return this.field_71990_ca;
    }

    public int func_71899_b(int meta) {
        return meta;
    }

    protected boolean func_71906_q_() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        this.icons = TextureAtlasSheet.unstitchIcons(iconRegister, "railcraft:glass", 1, 5);
        this.patterns.put(EnumSet.noneOf(Neighbors.class), this.icons[0]);
        this.patterns.put(EnumSet.of(Neighbors.BOTTOM), this.icons[1]);
        this.patterns.put(EnumSet.of(Neighbors.TOP, Neighbors.BOTTOM), this.icons[2]);
        this.patterns.put(EnumSet.of(Neighbors.TOP), this.icons[3]);
    }

    public Icon func_71895_b(IBlockAccess world, int x, int y, int z, int side) {
        if (renderingHighlight) {
            return this.icons[4];
        }
        if (side <= 1) {
            return this.icons[0];
        }
        int meta = world.func_72805_g(x, y, z);
        EnumSet<Neighbors> neighbors = EnumSet.noneOf(Neighbors.class);
        if (WorldPlugin.getBlock(world, x, y + 1, z) == this && world.func_72805_g(x, y + 1, z) == meta) {
            neighbors.add(Neighbors.TOP);
        }
        if (WorldPlugin.getBlock(world, x, y - 1, z) == this && world.func_72805_g(x, y - 1, z) == meta) {
            neighbors.add(Neighbors.BOTTOM);
        }
        return (Icon)this.patterns.get(neighbors);
    }

    public Icon func_71858_a(int side, int meta) {
        if (renderingHighlight) {
            return this.icons[4];
        }
        return this.icons[0];
    }

    public void func_71879_a(int id, CreativeTabs tab, List list) {
        for (int meta = 0; meta < 16; ++meta) {
            list.add(new ItemStack((Block)this, 1, meta));
        }
    }

    public boolean canBeReplacedByLeaves(World world, int x, int y, int z) {
        return false;
    }

    public boolean recolourBlock(World world, int x, int y, int z, ForgeDirection side, int colour) {
        int meta = world.func_72805_g(x, y, z);
        if (meta != colour) {
            world.func_72921_c(x, y, z, colour, 3);
            return true;
        }
        return false;
    }

    public int func_71920_b(IBlockAccess world, int x, int y, int z) {
        if (renderingHighlight) {
            return super.func_71920_b(world, x, y, z);
        }
        int meta = world.func_72805_g(x, y, z);
        return EnumColor.fromId(15 - meta).getHexColor();
    }

    private static enum Neighbors {
        TOP,
        BOTTOM;

    }
}

