/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.alpha;

import buildcraft.api.gates.IAction;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mods.railcraft.api.crafting.IRockCrusherRecipe;
import mods.railcraft.api.crafting.RailcraftCraftingManager;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.MultiBlockPattern;
import mods.railcraft.common.blocks.machine.TileMultiBlock;
import mods.railcraft.common.blocks.machine.TileMultiBlockInventory;
import mods.railcraft.common.blocks.machine.alpha.DamageSourceCrusher;
import mods.railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.plugins.buildcraft.actions.Actions;
import mods.railcraft.common.plugins.buildcraft.triggers.IHasWork;
import mods.railcraft.common.plugins.forge.WorldPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.manipulators.InventoryManipulator;
import mods.railcraft.common.util.inventory.wrappers.InventoryCopy;
import mods.railcraft.common.util.inventory.wrappers.InventoryMapper;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.sounds.SoundHelper;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class TileRockCrusher
extends TileMultiBlockInventory
implements IPowerReceptor,
IHasWork,
ISidedInventory {
    private static final int PROCESS_TIME = 100;
    private static final int CRUSHING_POWER_COST_PER_TICK = 16;
    private static final int SUCKING_POWER_COST = 512;
    private static final int KILLING_POWER_COST = 1024;
    private static final int MAX_RECEIVE = 500;
    public static final int MAX_ENERGY = 1600;
    public static final int SLOT_INPUT = 0;
    public static final int SLOT_OUTPUT = 9;
    private static final int[] SLOTS_INPUT = InvTools.buildSlotArray(0, 9);
    private static final int[] SLOTS_OUTPUT = InvTools.buildSlotArray(9, 9);
    private static final List patterns = new ArrayList();
    private int processTime;
    private IInventory invInput = new InventoryMapper(this, 0, 9);
    private IInventory invOutput = new InventoryMapper(this, 9, 9, false);
    private PowerHandler powerHandler;
    private boolean isWorking = false;
    private boolean paused = false;
    private final Set actions = new HashSet();

    public static void placeRockCrusher(World world, int x, int y, int z, int patternIndex, List input, List output) {
        MultiBlockPattern pattern = (MultiBlockPattern)patterns.get(patternIndex);
        HashMap<Character, Integer> blockMapping = new HashMap<Character, Integer>();
        blockMapping.put(Character.valueOf('B'), EnumMachineAlpha.ROCK_CRUSHER.ordinal());
        blockMapping.put(Character.valueOf('D'), EnumMachineAlpha.ROCK_CRUSHER.ordinal());
        blockMapping.put(Character.valueOf('a'), EnumMachineAlpha.ROCK_CRUSHER.ordinal());
        blockMapping.put(Character.valueOf('b'), EnumMachineAlpha.ROCK_CRUSHER.ordinal());
        blockMapping.put(Character.valueOf('c'), EnumMachineAlpha.ROCK_CRUSHER.ordinal());
        blockMapping.put(Character.valueOf('d'), EnumMachineAlpha.ROCK_CRUSHER.ordinal());
        blockMapping.put(Character.valueOf('e'), EnumMachineAlpha.ROCK_CRUSHER.ordinal());
        blockMapping.put(Character.valueOf('f'), EnumMachineAlpha.ROCK_CRUSHER.ordinal());
        blockMapping.put(Character.valueOf('h'), EnumMachineAlpha.ROCK_CRUSHER.ordinal());
        TileEntity tile = pattern.placeStructure(world, x, y, z, RailcraftBlocks.getBlockMachineAlpha(), blockMapping);
        if (tile instanceof TileRockCrusher) {
            TileRockCrusher master = (TileRockCrusher)tile;
            for (int slot = 0; slot < 9; ++slot) {
                if (input != null && slot < input.size()) {
                    master.inv.func_70299_a(0 + slot, (ItemStack)input.get(slot));
                }
                if (output == null || slot >= output.size()) continue;
                master.inv.func_70299_a(9 + slot, (ItemStack)output.get(slot));
            }
        }
    }

    public TileRockCrusher() {
        super(EnumMachineAlpha.ROCK_CRUSHER.getTag(), 18, patterns);
        if (RailcraftConfig.machinesRequirePower()) {
            this.powerHandler = new PowerHandler(this, PowerHandler.Type.MACHINE);
        }
        this.initPowerProvider();
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineAlpha.ROCK_CRUSHER;
    }

    @Override
    protected boolean isMapPositionValid(int x, int y, int z, char mapPos) {
        Block block = WorldPlugin.getBlock((IBlockAccess)this.field_70331_k, x, y, z);
        switch (mapPos) {
            case 'O': {
                if (block != this.func_70311_o() || this.field_70331_k.func_72805_g(x, y, z) != this.func_70322_n()) break;
                return false;
            }
            case 'B': 
            case 'D': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': 
            case 'g': 
            case 'h': {
                if (block == this.func_70311_o() && this.field_70331_k.func_72805_g(x, y, z) == this.func_70322_n()) break;
                return false;
            }
            case 'A': {
                if (this.field_70331_k.func_72799_c(x, y, z)) break;
                return false;
            }
        }
        return true;
    }

    private void initPowerProvider() {
        if (this.powerHandler != null) {
            this.powerHandler.configure(1.0f, 500.0f, 16.0f, 1600.0f);
            this.powerHandler.configurePowerPerdition(1, 1);
        }
    }

    private boolean useMasterEnergy(float amount, boolean doRemove) {
        TileRockCrusher mBlock = (TileRockCrusher)this.getMasterBlock();
        if (mBlock != null) {
            if (mBlock.powerHandler == null) {
                return true;
            }
            return mBlock.powerHandler.useEnergy(amount, amount, doRemove) == amount;
        }
        return false;
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (Game.isHost(this.getWorld())) {
            if (this.powerHandler != null) {
                this.powerHandler.update();
            }
            if (this.isStructureValid()) {
                EntityLivingBase entity;
                EntityItem item = TileEntityHopper.func_96119_a((World)this.field_70331_k, (double)this.field_70329_l, (double)(this.field_70330_m + 1), (double)this.field_70327_n);
                if (item != null && this.useMasterEnergy(512.0f, false)) {
                    ItemStack stack = item.func_92059_d().func_77946_l();
                    InventoryManipulator.get(this.invInput).addStack(stack);
                    item.func_70106_y();
                    this.useMasterEnergy(512.0f, true);
                }
                if ((entity = (EntityLivingBase)MiscTools.getEntityAt(this.field_70331_k, EntityLivingBase.class, this.field_70329_l, this.field_70330_m + 1, this.field_70327_n)) != null && this.useMasterEnergy(1024.0f, false) && entity.func_70097_a((DamageSource)DamageSourceCrusher.INSTANCE, 10.0f)) {
                    this.useMasterEnergy(512.0f, true);
                }
            }
            if (this.isMaster()) {
                if (this.clock % 16 == 0) {
                    this.processActions();
                }
                if (this.paused) {
                    return;
                }
                ItemStack input = null;
                IRockCrusherRecipe recipe = null;
                for (int i = 0; i < 9 && ((input = this.invInput.func_70301_a(i)) == null || (recipe = RailcraftCraftingManager.rockCrusher.getRecipe(input)) == null); ++i) {
                }
                if (recipe != null) {
                    if (this.processTime >= 100) {
                        this.isWorking = false;
                        InventoryCopy tempInv = new InventoryCopy(this.invOutput);
                        boolean hasRoom = true;
                        List outputs = recipe.getRandomizedOuputs();
                        for (ItemStack output : outputs) {
                            if ((output = InvTools.moveItemStack(output, tempInv)) == null) continue;
                            hasRoom = false;
                            break;
                        }
                        if (hasRoom) {
                            for (ItemStack output : outputs) {
                                InvTools.moveItemStack(output, this.invOutput);
                            }
                            InvTools.removeOneItem(this.invInput, input);
                            SoundHelper.playSound(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, "mob.irongolem.death", 1.5f, this.field_70331_k.field_73012_v.nextFloat() * 0.25f + 0.7f);
                            this.processTime = 0;
                        }
                    } else {
                        this.isWorking = true;
                        if (this.powerHandler != null) {
                            float energy = this.powerHandler.useEnergy(16.0f, 16.0f, true);
                            if (energy >= 16.0f) {
                                ++this.processTime;
                            }
                        } else {
                            ++this.processTime;
                        }
                    }
                } else {
                    this.processTime = 0;
                    this.isWorking = false;
                }
            }
        }
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        TileMultiBlock mBlock = this.getMasterBlock();
        if (mBlock != null) {
            GuiHandler.openGui(EnumGui.ROCK_CRUSHER, player, this.field_70331_k, mBlock.field_70329_l, mBlock.field_70330_m, mBlock.field_70327_n);
            return true;
        }
        return false;
    }

    @Override
    public Icon getIcon(int side) {
        if (this.isStructureValid()) {
            if (side > 1 && this.getPatternMarker() == 'D') {
                return this.getMachineType().getTexture(6);
            }
            if (side == 1) {
                char m = this.getPatternMarker();
                return this.getMachineType().getTexture(m - 97 + 7);
            }
        }
        if (side > 1) {
            return this.getMachineType().getTexture(0);
        }
        return this.getMachineType().getTexture(side);
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74768_a("processTime", this.processTime);
        if (this.powerHandler != null) {
            this.powerHandler.writeToNBT(data);
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.processTime = data.func_74762_e("processTime");
        if (this.powerHandler != null) {
            this.powerHandler.readFromNBT(data);
            this.initPowerProvider();
        }
    }

    public int getProcessTime() {
        TileRockCrusher mBlock = (TileRockCrusher)this.getMasterBlock();
        if (mBlock != null) {
            return mBlock.processTime;
        }
        return -1;
    }

    public void setProcessTime(int processTime) {
        TileRockCrusher mBlock = (TileRockCrusher)this.getMasterBlock();
        if (mBlock != null) {
            mBlock.processTime = processTime;
        }
    }

    public int getProgressScaled(int i) {
        return this.getProcessTime() * i / 100;
    }

    @Override
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        TileRockCrusher mBlock = (TileRockCrusher)this.getMasterBlock();
        if (mBlock != null && mBlock.powerHandler != null) {
            return mBlock.powerHandler.getPowerReceiver();
        }
        return this.powerHandler != null ? this.powerHandler.getPowerReceiver() : null;
    }

    @Override
    public void doWork(PowerHandler workProvider) {
    }

    @Override
    public boolean hasWork() {
        TileRockCrusher mBlock = (TileRockCrusher)this.getMasterBlock();
        if (mBlock != null) {
            return mBlock.isWorking;
        }
        return false;
    }

    private void processActions() {
        this.paused = false;
        for (IAction action : this.actions) {
            if (action != Actions.PAUSE) continue;
            this.paused = true;
        }
        this.actions.clear();
    }

    @Override
    public void actionActivated(IAction action) {
        TileRockCrusher mBlock = (TileRockCrusher)this.getMasterBlock();
        if (mBlock != null) {
            mBlock.actions.add(action);
        }
    }

    public int[] func_94128_d(int side) {
        if (side == ForgeDirection.UP.ordinal()) {
            return SLOTS_INPUT;
        }
        return SLOTS_OUTPUT;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot >= 9;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot < 9) {
            return RailcraftCraftingManager.rockCrusher.getRecipe(stack) != null;
        }
        return false;
    }

    static {
        char[][][] map1 = new char[][][]{new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'B', 'D', 'B', 'O'}, {'O', 'B', 'D', 'B', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'a', 'd', 'f', 'O'}, {'O', 'c', 'e', 'h', 'O'}, {'O', 'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O', 'O'}}};
        patterns.add(new MultiBlockPattern(map1));
        char[][][] map2 = new char[][][]{new char[][]{{'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O'}, {'O', 'B', 'B', 'O'}, {'O', 'D', 'D', 'O'}, {'O', 'B', 'B', 'O'}, {'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O'}, {'O', 'a', 'f', 'O'}, {'O', 'b', 'g', 'O'}, {'O', 'c', 'h', 'O'}, {'O', 'O', 'O', 'O'}}, new char[][]{{'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}, {'O', 'O', 'O', 'O'}}};
        patterns.add(new MultiBlockPattern(map2));
    }
}

