/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.beta;

import java.util.HashMap;
import java.util.List;
import mods.railcraft.api.core.items.IStackFilter;
import mods.railcraft.common.blocks.RailcraftBlocks;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.MultiBlockPattern;
import mods.railcraft.common.blocks.machine.TileMultiBlock;
import mods.railcraft.common.blocks.machine.alpha.TileCokeOven;
import mods.railcraft.common.blocks.machine.alpha.TileSteamOven;
import mods.railcraft.common.blocks.machine.beta.EnumMachineBeta;
import mods.railcraft.common.blocks.machine.beta.TileBoiler;
import mods.railcraft.common.blocks.machine.beta.TileBoilerFirebox;
import mods.railcraft.common.fluids.Fluids;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.plugins.buildcraft.triggers.INeedsFuel;
import mods.railcraft.common.plugins.forge.FuelPlugin;
import mods.railcraft.common.util.inventory.AdjacentInventoryCache;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.InventorySorter;
import mods.railcraft.common.util.inventory.filters.StackFilter;
import mods.railcraft.common.util.inventory.wrappers.InventoryMapper;
import mods.railcraft.common.util.misc.ITileFilter;
import mods.railcraft.common.util.steam.SolidFuelProvider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TileBoilerFireboxSolid
extends TileBoilerFirebox
implements INeedsFuel {
    private static final int SLOT_BURN = 2;
    private static final int SLOT_FUEL_A = 3;
    private static final int SLOT_FUEL_B = 4;
    private static final int SLOT_FUEL_C = 5;
    private static final int[] SLOTS = InvTools.buildSlotArray(0, 6);
    private IInventory invBurn = new InventoryMapper(this, 2, 1);
    private IInventory invStock = new InventoryMapper(this, 3, 3);
    private IInventory invFuel = new InventoryMapper(this, 2, 4);
    private boolean needsFuel = false;
    private ItemStack bucket = new ItemStack(Item.field_77788_aw);
    private AdjacentInventoryCache invCache = new AdjacentInventoryCache(this, this.tileCache, new ITileFilter(){

        @Override
        public boolean matches(TileEntity tile) {
            if (tile instanceof TileSteamOven) {
                return true;
            }
            if (tile instanceof TileCokeOven) {
                return true;
            }
            if (tile instanceof TileBoiler) {
                return false;
            }
            if (tile instanceof IInventory) {
                return ((IInventory)tile).func_70302_i_() >= 27;
            }
            return false;
        }
    }, InventorySorter.SIZE_DECENDING);

    public static void placeSolidBoiler(World world, int x, int y, int z, int width, int height, boolean highPressure, int water, List fuel) {
        for (MultiBlockPattern pattern : TileBoiler.patterns) {
            if (pattern.getPatternHeight() - 3 != height || pattern.getPatternWidthX() - 2 != width) continue;
            HashMap<Character, Integer> blockMapping = new HashMap<Character, Integer>();
            blockMapping.put(Character.valueOf('F'), EnumMachineBeta.BOILER_FIREBOX_SOLID.ordinal());
            blockMapping.put(Character.valueOf('H'), highPressure ? EnumMachineBeta.BOILER_TANK_HIGH_PRESSURE.ordinal() : EnumMachineBeta.BOILER_TANK_LOW_PRESSURE.ordinal());
            TileEntity tile = pattern.placeStructure(world, x, y, z, RailcraftBlocks.getBlockMachineBeta(), blockMapping);
            if (tile instanceof TileBoilerFireboxSolid) {
                TileBoilerFireboxSolid master = (TileBoilerFireboxSolid)tile;
                master.tankWater.setFluid(Fluids.WATER.get(water));
                InventoryMapper invFuel = new InventoryMapper(master.inventory, 2, 4);
                for (ItemStack stack : fuel) {
                    InvTools.moveItemStack(stack, invFuel);
                }
            }
            return;
        }
    }

    public TileBoilerFireboxSolid() {
        super(6);
        this.boiler.setFuelProvider(new SolidFuelProvider(this, 2));
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineBeta.BOILER_FIREBOX_SOLID;
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        TileMultiBlock mBlock = this.getMasterBlock();
        if (mBlock != null) {
            GuiHandler.openGui(EnumGui.BOILER_SOLID, player, this.field_70331_k, mBlock.field_70329_l, mBlock.field_70330_m, mBlock.field_70327_n);
            return true;
        }
        return false;
    }

    @Override
    protected void process() {
        if (this.clock % 4 == 0) {
            InvTools.moveOneItem(this.invStock, this.invBurn);
            InvTools.moveOneItem(this.invBurn, this.invWaterOutput, this.bucket);
        }
    }

    @Override
    public void func_70316_g() {
        TileBoilerFireboxSolid mBlock;
        super.func_70316_g();
        if (this.field_70331_k.field_72995_K) {
            return;
        }
        if (this.isMaster && this.clock % 4 == 0) {
            boolean bl = this.needsFuel = !InvTools.numItemsMoreThan(this.invFuel, 64);
        }
        if (this.needsFuel() && (mBlock = (TileBoilerFireboxSolid)this.getMasterBlock()) != null) {
            InvTools.moveOneItem(this.invCache.getAdjecentInventories(), mBlock.invFuel, (IStackFilter)StackFilter.FUEL);
        }
    }

    public int[] func_94128_d(int var1) {
        return SLOTS;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 1;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot >= 2) {
            return FuelPlugin.getBurnTime(stack) > 0;
        }
        if (slot == 0) {
            return Fluids.WATER.isContained(stack);
        }
        return false;
    }

    @Override
    public boolean needsFuel() {
        TileBoilerFireboxSolid mBlock = (TileBoilerFireboxSolid)this.getMasterBlock();
        if (mBlock != null) {
            return mBlock.needsFuel;
        }
        return false;
    }

    public boolean func_94042_c() {
        return false;
    }
}

