/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.beta;

import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.beta.EnumMachineBeta;
import mods.railcraft.common.blocks.machine.beta.TileEngine;
import mods.railcraft.common.blocks.machine.beta.TileEngineSteam;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.fluids.FluidHelper;
import mods.railcraft.common.fluids.Fluids;
import mods.railcraft.common.fluids.tanks.FilteredTank;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.plugins.buildcraft.triggers.INeedsFuel;
import mods.railcraft.common.plugins.buildcraft.triggers.ITemperature;
import mods.railcraft.common.plugins.forge.FuelPlugin;
import mods.railcraft.common.util.inventory.InvTools;
import mods.railcraft.common.util.inventory.StandaloneInventory;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.steam.SolidFuelProvider;
import mods.railcraft.common.util.steam.SteamBoiler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class TileEngineSteamHobby
extends TileEngineSteam
implements IInventory,
ISidedInventory,
INeedsFuel,
ITemperature {
    private static final int OUTPUT_MJ = 2;
    private static final int STEAM_USED = 10;
    private static final float FUEL_PER_CONVERSION_MULTIPLIER = 1.25f;
    private static final byte TICKS_PER_BOILER_CYCLE = 20;
    private static final byte TANK_WATER = 1;
    private static final byte SLOT_FUEL = 0;
    private static final byte SLOT_LIQUID_INPUT = 1;
    private static final byte SLOT_LIQUID_OUTPUT = 2;
    private static final int[] SLOTS = InvTools.buildSlotArray(0, 3);
    public final SteamBoiler boiler;
    private StandaloneInventory inv = new StandaloneInventory(3, this);

    public TileEngineSteamHobby() {
        FilteredTank tankWater = new FilteredTank(4000, Fluids.WATER.get(), this);
        this.getTankManager().add(tankWater);
        this.getTankManager().get(0).setCapacity(4000);
        this.boiler = new SteamBoiler(tankWater, this.getTankManager().get(0));
        this.boiler.setTicksPerCycle(20);
        this.boiler.setInefficencyModifier(1.25f);
        this.boiler.setFuelProvider(new SolidFuelProvider(this.inv, 0){

            @Override
            public float getMoreFuel() {
                if (TileEngineSteamHobby.this.getEnergyStage() == TileEngine.EnergyStage.OVERHEAT) {
                    return 0.0f;
                }
                return super.getMoreFuel();
            }
        });
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineBeta.ENGINE_STEAM_HOBBY;
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        GuiHandler.openGui(EnumGui.ENGINE_HOBBY, player, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        return true;
    }

    @Override
    public boolean blockActivated(EntityPlayer player, int side) {
        ItemStack current = player.func_71045_bC();
        if (current != null && current.field_77993_c != Item.field_77788_aw.field_77779_bT && (Game.isHost(this.field_70331_k) ? FluidHelper.handleRightClick(this, ForgeDirection.getOrientation((int)side), player, true, false) : FluidHelper.isContainer(current))) {
            return true;
        }
        return super.blockActivated(player, side);
    }

    public boolean isBurning() {
        return this.boiler.isBurning();
    }

    @Override
    public float getMaxOutputMJ() {
        return 2.0f;
    }

    @Override
    public int steamUsedPerTick() {
        return 10;
    }

    @Override
    public void burn() {
        super.burn();
        if (this.clock % 8 == 0) {
            FluidHelper.drainContainers(this, this.inv, 1, 2);
        }
        this.boiler.tick(1);
    }

    public int func_70302_i_() {
        return this.inv.func_70302_i_();
    }

    public ItemStack func_70301_a(int slot) {
        return this.inv.func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return this.inv.func_70298_a(slot, amount);
    }

    public ItemStack func_70304_b(int var1) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inv.func_70299_a(slot, stack);
    }

    @Override
    public String func_70303_b() {
        return RailcraftLanguage.translate(EnumMachineBeta.ENGINE_STEAM_HOBBY.getTag());
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public int maxEnergy() {
        return 10000;
    }

    @Override
    public int maxEnergyReceived() {
        return 300;
    }

    @Override
    public int maxEnergyExtracted() {
        return 40;
    }

    @Override
    public boolean needsFuel() {
        ItemStack fuel = this.inv.func_70301_a(0);
        return fuel == null || fuel.field_77994_a < 8;
    }

    @Override
    public float getTemperature() {
        return this.boiler.getHeat();
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        this.inv.writeToNBT("Items", data);
        this.boiler.writeToNBT(data);
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.inv.readFromNBT("Items", data);
        this.boiler.readFromNBT(data);
    }

    public int[] func_94128_d(int var1) {
        return SLOTS;
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 2;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        switch (slot) {
            case 0: {
                return FuelPlugin.getBurnTime(stack) > 0;
            }
            case 1: {
                return Fluids.WATER.is(FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack));
            }
        }
        return false;
    }

    public boolean func_94042_c() {
        return false;
    }

    @Override
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (this.isPowered() && Fluids.STEAM.is(resource)) {
            return this.fill(0, resource, doFill);
        }
        if (Fluids.WATER.is(resource)) {
            return this.fill(1, resource, doFill);
        }
        return 0;
    }

    private int fill(int tankIndex, FluidStack resource, boolean doFill) {
        FluidStack water;
        if (tankIndex == 1 && this.boiler.isSuperHeated() && ((water = this.getTankManager().get(1).getFluid()) == null || water.amount <= 0)) {
            this.explode();
        }
        return this.getTankManager().fill(tankIndex, resource, doFill);
    }

    public void explode() {
        if (Game.isHost(this.field_70331_k)) {
            this.field_70331_k.func_72876_a(null, (double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, 2.0f, true);
        }
    }
}

