/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.machine.gamma;

import buildcraft.api.transport.PipeManager;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.carts.ILiquidTransfer;
import mods.railcraft.api.tracks.ITrackInstance;
import mods.railcraft.api.tracks.ITrackLockdown;
import mods.railcraft.common.blocks.machine.IEnumMachine;
import mods.railcraft.common.blocks.machine.gamma.EnumMachineGamma;
import mods.railcraft.common.blocks.machine.gamma.TileLoaderLiquidBase;
import mods.railcraft.common.blocks.tracks.TileTrack;
import mods.railcraft.common.carts.CartUtils;
import mods.railcraft.common.carts.EntityCartTank;
import mods.railcraft.common.carts.EntityLocomotiveSteam;
import mods.railcraft.common.core.RailcraftConfig;
import mods.railcraft.common.core.RailcraftLanguage;
import mods.railcraft.common.fluids.FluidHelper;
import mods.railcraft.common.fluids.TankToolkit;
import mods.railcraft.common.fluids.tanks.StandardTank;
import mods.railcraft.common.gui.EnumGui;
import mods.railcraft.common.gui.GuiHandler;
import mods.railcraft.common.gui.buttons.IButtonTextureSet;
import mods.railcraft.common.gui.buttons.IMultiButtonState;
import mods.railcraft.common.gui.buttons.MultiButtonController;
import mods.railcraft.common.gui.buttons.StandardButtonTextureSets;
import mods.railcraft.common.gui.tooltips.ToolTip;
import mods.railcraft.common.util.inventory.wrappers.InventoryMapper;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import mods.railcraft.common.util.misc.SafeNBTWrapper;
import mods.railcraft.common.util.network.IGuiReturnHandler;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class TileLiquidLoader
extends TileLoaderLiquidBase
implements IGuiReturnHandler {
    private static final int RESET_WAIT = 200;
    private static final int TRANSFER_RATE = 20;
    private static final int CAPACITY = 32000;
    private static final float MAX_PIPE_LENGTH = 1.0f;
    private static final float PIPE_INCREMENT = 0.01f;
    private int waitForReset = 0;
    private float pipeLenght = 0.0f;
    private final IInventory invInput = new InventoryMapper(this, 0, 1);
    private StandardTank tank = new StandardTank(32000, this);
    private MultiButtonController stateController = new MultiButtonController(ButtonState.FORCE_FULL.ordinal(), ButtonState.values());

    public TileLiquidLoader() {
        this.tankManager.add(this.tank);
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineGamma.LIQUID_LOADER;
    }

    public MultiButtonController getStateController() {
        return this.stateController;
    }

    public IInventory getInputInventory() {
        return this.invInput;
    }

    private void resetPipe() {
        this.pipeLenght = 0.0f;
    }

    public float getPipeLenght() {
        return this.pipeLenght;
    }

    private void setPipeLength(float y) {
        this.pipeLenght = y;
        this.sendUpdateToClient();
    }

    private void extendPipe() {
        float y = this.pipeLenght + 0.01f;
        if (this.pipeIsExtended()) {
            y = 1.0f;
        }
        this.setPipeLength(y);
    }

    private void retractPipe() {
        float y = this.pipeLenght - 0.01f;
        if (this.pipeIsRetracted()) {
            y = 0.0f;
        }
        this.setPipeLength(y);
    }

    private boolean pipeIsExtended() {
        return this.pipeLenght >= 1.0f;
    }

    private boolean pipeIsRetracted() {
        return this.pipeLenght <= 0.0f;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72332_a().func_72299_a((double)this.field_70329_l, (double)(this.field_70330_m - 1), (double)this.field_70327_n, (double)(this.field_70329_l + 1), (double)(this.field_70330_m + 1), (double)(this.field_70327_n + 1));
    }

    @Override
    public Icon getIcon(int side) {
        if (side > 1) {
            return this.getMachineType().getTexture(6);
        }
        return this.getMachineType().getTexture(side);
    }

    @Override
    public void func_70316_g() {
        EntityLocomotiveSteam loco;
        FluidStack drained;
        ItemStack bottomSlot;
        super.func_70316_g();
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        ItemStack topSlot = this.func_70301_a(0);
        if (topSlot != null && !FluidHelper.isContainer(topSlot)) {
            this.func_70299_a(0, null);
            this.dropItem(topSlot);
        }
        if ((bottomSlot = this.func_70301_a(1)) != null && !FluidHelper.isContainer(bottomSlot)) {
            this.func_70299_a(1, null);
            this.dropItem(bottomSlot);
        }
        if (this.clock % 8 == 0) {
            FluidHelper.drainContainers(this, this, 0, 1);
        }
        for (ForgeDirection side : ForgeDirection.values()) {
            TileEntity tile;
            if (side == ForgeDirection.UNKNOWN || !((tile = this.tileCache.getTileOnSide(side)) instanceof IFluidHandler)) continue;
            IFluidHandler nearbyTank = (IFluidHandler)tile;
            if (!PipeManager.canExtractFluids(this, this.field_70331_k, MiscTools.getXOnSide(this.field_70329_l, side), MiscTools.getYOnSide(this.field_70330_m, side), MiscTools.getZOnSide(this.field_70327_n, side))) continue;
            side = side.getOpposite();
            drained = nearbyTank.drain(side, 20, false);
            int used = this.tank.fill(drained, true);
            nearbyTank.drain(side, used, true);
        }
        boolean needsPipe = false;
        EntityMinecart cart = CartTools.getMinecartOnSide(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, 0.2f, ForgeDirection.DOWN);
        if (cart == null) {
            cart = CartTools.getMinecartOnSide(this.field_70331_k, this.field_70329_l, this.field_70330_m - 1, this.field_70327_n, 0.2f, ForgeDirection.DOWN);
            needsPipe = true;
        }
        if (cart != this.currentCart) {
            if (this.currentCart instanceof ILiquidTransfer) {
                ((EntityCartTank)this.currentCart).setFilling(false);
            }
            this.setPowered(false);
            this.currentCart = cart;
            this.cartWasSent();
            this.waitForReset = 0;
        }
        if (this.waitForReset > 0) {
            --this.waitForReset;
        }
        if (this.waitForReset > 0) {
            if (this.pipeIsRetracted()) {
                this.sendCart(cart);
            } else {
                this.retractPipe();
            }
            return;
        }
        if (cart == null) {
            if (!this.pipeIsRetracted()) {
                this.retractPipe();
            }
            return;
        }
        if (this.isSendCartGateAction()) {
            this.sendCart(cart);
            return;
        }
        if (!(cart instanceof IFluidHandler)) {
            this.sendCart(cart);
            return;
        }
        ItemStack minecartSlot1 = this.getCartFilters().func_70301_a(0);
        ItemStack minecartSlot2 = this.getCartFilters().func_70301_a(1);
        if (!(minecartSlot1 == null && minecartSlot2 == null || CartUtils.doesCartMatchFilter(minecartSlot1, cart) || CartUtils.doesCartMatchFilter(minecartSlot2, cart))) {
            this.sendCart(cart);
            return;
        }
        if (cart instanceof EntityLocomotiveSteam && !(loco = (EntityLocomotiveSteam)cart).isSafeToFill()) {
            this.retractPipe();
            return;
        }
        if (this.isPaused()) {
            return;
        }
        TankToolkit tankCart = new TankToolkit((IFluidHandler)cart);
        boolean cartNeedsFilling = this.cartNeedsFilling(tankCart);
        if (cartNeedsFilling && needsPipe) {
            this.extendPipe();
        } else {
            this.retractPipe();
        }
        this.flow = 0;
        if (cartNeedsFilling && (!needsPipe || this.pipeIsExtended()) && (drained = this.tankManager.drain(0, RailcraftConfig.getTankCartFillRate(), false)) != null) {
            this.flow = tankCart.fill(ForgeDirection.UP, drained, true);
            this.tankManager.drain(0, this.flow, true);
        }
        if (this.flow > 0) {
            if (cart instanceof ILiquidTransfer) {
                ((ILiquidTransfer)cart).setFilling(true);
            }
            this.setPowered(false);
        } else if (cart instanceof ILiquidTransfer) {
            ((ILiquidTransfer)cart).setFilling(false);
        }
        if (tankCart.isTankFull(this.tank.getFluidType())) {
            this.waitForReset = 200;
        }
        if (this.stateController.getButtonState() != ButtonState.MANUAL && this.pipeIsRetracted() && this.flow <= 0 && this.shouldCartLeave(cart, tankCart)) {
            this.sendCart(cart);
        }
    }

    private void sendCart(EntityMinecart cart) {
        if (cart == null) {
            return;
        }
        if (this.stateController.getButtonState() == ButtonState.MANUAL) {
            return;
        }
        if (CartTools.cartVelocityIsLessThan(cart, 0.02f)) {
            this.setPowered(true);
        }
    }

    private boolean cartNeedsFilling(TankToolkit tankCart) {
        FluidStack loaderLiquid = this.tank.getFluid();
        return loaderLiquid != null && loaderLiquid.amount > 0 && tankCart.canPutFluid(ForgeDirection.UP, loaderLiquid);
    }

    private boolean shouldCartLeave(EntityMinecart cart, TankToolkit tankCart) {
        boolean leave = false;
        if (CartTools.cartVelocityIsLessThan(cart, 0.02f)) {
            if (this.tank.getFluid() != null && this.tank.getFluid().amount > 0 && !tankCart.canPutFluid(ForgeDirection.UP, this.tank.getFluid())) {
                leave = true;
            } else if (this.stateController.getButtonState() != ButtonState.FORCE_FULL && !tankCart.isTankEmpty(this.tank.getFluidType())) {
                leave = true;
            } else if (this.stateController.getButtonState() == ButtonState.IMMEDIATE && tankCart.isTankEmpty(this.tank.getFluidType())) {
                leave = true;
            } else if (tankCart.isTankFull(this.tank.getFluidType())) {
                leave = true;
            }
        }
        return leave;
    }

    @Override
    protected void setPowered(boolean p) {
        if (this.stateController.getButtonState() == ButtonState.MANUAL) {
            p = false;
        }
        if (p) {
            TileTrack trackTile;
            ITrackInstance track;
            TileEntity tile;
            this.resetPipe();
            if (this.field_70331_k != null && (tile = this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m - 2, this.field_70327_n)) instanceof TileTrack && (track = (trackTile = (TileTrack)tile).getTrackInstance()) instanceof ITrackLockdown) {
                ((ITrackLockdown)track).releaseCart();
            }
        }
        super.setPowered(p);
    }

    @Override
    public void func_70313_j() {
        super.func_70313_j();
        this.resetPipe();
    }

    @Override
    public void func_70312_q() {
        super.func_70312_q();
        this.resetPipe();
    }

    @Override
    public void onBlockRemoval() {
        super.onBlockRemoval();
        this.resetPipe();
    }

    @Override
    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    @Override
    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        this.stateController.writeToNBT(data, "state");
        data.func_74776_a("pipeLenght", this.pipeLenght);
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.stateController.readFromNBT(data, "state");
        SafeNBTWrapper safe = new SafeNBTWrapper(data);
        this.pipeLenght = safe.getFloat("pipeLenght");
        boolean waitIfEmpty = data.func_74767_n("WaitIfEmpty");
        boolean waitTillFull = data.func_74767_n("WaitTillFull");
        if (waitTillFull) {
            this.stateController.setCurrentState(ButtonState.FORCE_FULL);
        } else if (waitIfEmpty) {
            this.stateController.setCurrentState(ButtonState.HOLD_EMPTY);
        }
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.stateController.getCurrentState());
        data.writeFloat(this.pipeLenght);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.stateController.setCurrentState(data.readByte());
        this.setPipeLength(data.readFloat());
    }

    @Override
    public boolean openGui(EntityPlayer player) {
        GuiHandler.openGui(EnumGui.LOADER_LIQUID, player, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        return true;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack stack) {
        switch (slot) {
            case 0: {
                return FluidHelper.isFilledContainer(stack);
            }
        }
        return false;
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeByte(this.stateController.getCurrentState());
    }

    @Override
    public void readGuiData(DataInputStream data, EntityPlayer sender) throws IOException {
        this.stateController.setCurrentState(data.readByte());
    }

    public static enum ButtonState implements IMultiButtonState
    {
        HOLD_EMPTY("gui.liquid.loader.empty"),
        FORCE_FULL("gui.liquid.loader.fill"),
        IMMEDIATE("gui.liquid.loader.immediate"),
        MANUAL("gui.liquid.loader.manual");

        private String label;
        private final ToolTip tip;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private ButtonState() {
            void label;
            this.label = label;
            this.tip = ToolTip.buildToolTip((String)label + ".tip", new String[0]);
        }

        @Override
        public String getLabel() {
            return RailcraftLanguage.translate(this.label);
        }

        @Override
        public IButtonTextureSet getTextureSet() {
            return StandardButtonTextureSets.SMALL_BUTTON;
        }

        @Override
        public ToolTip getToolTip() {
            return this.tip;
        }
    }
}

