/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.blocks.signals;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.common.blocks.signals.ISignalTile;
import mods.railcraft.common.blocks.signals.TileSignalFoundation;
import mods.railcraft.common.plugins.buildcraft.triggers.IAspectProvider;
import mods.railcraft.common.util.misc.Game;
import mods.railcraft.common.util.misc.MiscTools;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public abstract class TileSignalBase
extends TileSignalFoundation
implements ISignalTile,
IAspectProvider {
    private static final ForgeDirection[] UP_DOWN_AXES = new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN};
    protected static final float BOUNDS = 0.15f;
    private ForgeDirection facing = ForgeDirection.NORTH;
    private boolean prevLightState;
    private boolean prevBlinkState;

    @Override
    public boolean rotateBlock(ForgeDirection axis) {
        if (axis == ForgeDirection.UP || axis == ForgeDirection.DOWN) {
            return false;
        }
        this.facing = this.facing == axis ? axis.getOpposite() : axis;
        this.markBlockForUpdate();
        return true;
    }

    @Override
    public ForgeDirection[] getValidRotations() {
        return UP_DOWN_AXES;
    }

    @Override
    public void setBlockBoundsBasedOnState(IBlockAccess world, int i, int j, int k) {
        this.func_70311_o().func_71905_a(0.15f, 0.35f, 0.15f, 0.85f, 1.0f, 0.85f);
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool(World world, int i, int j, int k) {
        return AxisAlignedBB.func_72332_a().func_72299_a((double)((float)i + 0.15f), (double)((float)j + 0.35f), (double)((float)k + 0.15f), (double)((float)(i + 1) - 0.15f), (double)(j + 1), (double)((float)(k + 1) - 0.15f));
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool(World world, int i, int j, int k) {
        return AxisAlignedBB.func_72332_a().func_72299_a((double)((float)i + 0.15f), (double)((float)j + 0.35f), (double)((float)k + 0.15f), (double)((float)(i + 1) - 0.15f), (double)(j + 1), (double)((float)(k + 1) - 0.15f));
    }

    public boolean canUpdate() {
        return true;
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (Game.isNotHost(this.field_70331_k)) {
            this.updateLighting();
        }
    }

    private void updateLighting() {
        if (this.clock % 4 == 0) {
            boolean lightState;
            boolean needsUpdate = false;
            boolean blinkState = SignalAspect.isBlinkOn();
            if (this.prevBlinkState != blinkState && this.isBlinking()) {
                this.prevBlinkState = blinkState;
                needsUpdate = true;
            }
            if (this.prevLightState != (lightState = this.isLit())) {
                this.prevLightState = lightState;
                this.field_70331_k.func_72936_c(EnumSkyBlock.Block, this.field_70329_l, this.field_70330_m, this.field_70327_n);
                needsUpdate = true;
            }
            if (needsUpdate) {
                this.markBlockForUpdate();
            }
        }
    }

    protected boolean isLit() {
        return this.getSignalAspect().isLit();
    }

    protected boolean isBlinking() {
        return this.getSignalAspect().isBlinkAspect();
    }

    @Override
    public int getLightValue() {
        if (this.isLit()) {
            return 5;
        }
        return 0;
    }

    public void setFacing(ForgeDirection facing) {
        this.facing = facing;
    }

    public ForgeDirection getFacing() {
        return this.facing;
    }

    @Override
    public void onBlockPlacedBy(EntityLivingBase entityliving) {
        super.onBlockPlacedBy(entityliving);
        this.facing = MiscTools.getHorizontalSideClosestToPlayer(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, entityliving);
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74774_a("Facing", (byte)this.facing.ordinal());
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.facing = ForgeDirection.getOrientation((int)data.func_74771_c("Facing"));
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte((byte)this.facing.ordinal());
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.facing = ForgeDirection.getOrientation((int)data.readByte());
        this.markBlockForUpdate();
    }

    public abstract SignalAspect getSignalAspect();

    @Override
    public SignalAspect getTriggerAspect() {
        return this.getSignalAspect();
    }
}

