/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.emblems;

import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.EnumSet;
import java.util.logging.Level;
import mods.railcraft.common.emblems.EmblemManager;
import mods.railcraft.common.util.misc.Game;
import net.minecraft.entity.player.EntityPlayer;

public abstract class EmblemUnlocker
implements ITickHandler {
    protected boolean isComplete = false;
    protected boolean emblemExists = false;
    protected boolean terminate = false;
    protected final String unlockCode;
    protected final String identifier;
    protected final EntityPlayer player;

    private EmblemUnlocker(String unlockCode, EntityPlayer player) {
        this.unlockCode = unlockCode;
        this.player = player;
        this.identifier = EmblemManager.getIdentifierFromCode(unlockCode);
    }

    public static void spawnUnlocker(String unlockCode, int windowId, EntityPlayer player) {
        EmblemUnlockerGUI unlocker = new EmblemUnlockerGUI(unlockCode, player, windowId);
        super.initiateCheck();
        TickRegistry.registerTickHandler((ITickHandler)unlocker, (Side)Side.SERVER);
    }

    private void initiateCheck() {
        Game.log(Level.INFO, "Attempting to unlock Emblem - \"emblem-{0}\"", this.identifier);
        EmblemChecker checker = new EmblemChecker();
        checker.setDaemon(true);
        checker.setName("Emblem downloader: " + this.identifier);
        checker.start();
    }

    protected void onComplete() {
    }

    public void tickStart(EnumSet type, Object ... tickData) {
        if (this.isComplete) {
            this.onComplete();
            this.terminate = true;
        }
    }

    public void tickEnd(EnumSet type, Object ... tickData) {
    }

    public EnumSet ticks() {
        if (this.terminate) {
            return EnumSet.noneOf(TickType.class);
        }
        return this.getTickType();
    }

    public abstract EnumSet getTickType();

    public String getLabel() {
        return "Emblem Unlocker - " + EmblemManager.getIdentifierFromCode(this.unlockCode);
    }

    private class EmblemChecker
    extends Thread {
        private EmblemChecker() {
        }

        @Override
        public void run() {
            EmblemUnlocker.this.emblemExists = this.emblemExists();
            EmblemUnlocker.this.isComplete = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean emblemExists() {
            HttpURLConnection con = null;
            try {
                HttpURLConnection.setFollowRedirects(false);
                URL url = new URL("https://dl.dropboxusercontent.com/u/38558957/Minecraft/Railcraft/Emblems/emblem-" + EmblemUnlocker.this.identifier + ".jar");
                con = (HttpURLConnection)url.openConnection();
                con.setRequestMethod("HEAD");
                boolean bl = con.getResponseCode() == 200;
                return bl;
            }
            catch (Exception ex) {
                Game.log(Level.WARNING, "Failed to find Emblem: \"emblem-{0}\". Reason: {1}", EmblemUnlocker.this.identifier, ex);
                boolean bl = false;
                return bl;
            }
            finally {
                if (con != null) {
                    con.disconnect();
                }
            }
        }
    }

    private static class EmblemUnlockerGUI
    extends EmblemUnlocker {
        private static final EnumSet TICK_TYPE = EnumSet.of(TickType.SERVER);
        private final int windowId;

        private EmblemUnlockerGUI(String unlockCode, EntityPlayer player, int windowId) {
            super(unlockCode, player);
            this.windowId = windowId;
        }

        @Override
        protected void onComplete() {
            String result = "";
            String msg = "gui.engrave.unlock.fail";
            if (this.emblemExists) {
                EmblemManager.unlockEmblem(this.player, this.unlockCode);
                result = this.identifier;
                msg = "gui.engrave.unlock.success";
            }
            EmblemManager.updateUnlockGUI(this.player, result, this.windowId, msg);
        }

        @Override
        public EnumSet getTickType() {
            return TICK_TYPE;
        }
    }
}

