/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.modules;

import java.io.File;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import mods.railcraft.common.core.Railcraft;
import mods.railcraft.common.modules.AbstractModule;
import mods.railcraft.common.modules.IModule;
import mods.railcraft.common.modules.ModuleAutomation;
import mods.railcraft.common.modules.ModuleChunkLoading;
import mods.railcraft.common.modules.ModuleCore;
import mods.railcraft.common.modules.ModuleEmblem;
import mods.railcraft.common.modules.ModuleExtras;
import mods.railcraft.common.modules.ModuleFactory;
import mods.railcraft.common.modules.ModuleForestry;
import mods.railcraft.common.modules.ModuleIC2;
import mods.railcraft.common.modules.ModuleLocomotives;
import mods.railcraft.common.modules.ModuleMagic;
import mods.railcraft.common.modules.ModuleRouting;
import mods.railcraft.common.modules.ModuleSeasonal;
import mods.railcraft.common.modules.ModuleSignals;
import mods.railcraft.common.modules.ModuleSteam;
import mods.railcraft.common.modules.ModuleStructures;
import mods.railcraft.common.modules.ModuleThaumcraft;
import mods.railcraft.common.modules.ModuleTrack;
import mods.railcraft.common.modules.ModuleTracksHighSpeed;
import mods.railcraft.common.modules.ModuleTracksReinforced;
import mods.railcraft.common.modules.ModuleTracksWood;
import mods.railcraft.common.modules.ModuleTrain;
import mods.railcraft.common.modules.ModuleTransport;
import mods.railcraft.common.modules.ModuleWorld;
import mods.railcraft.common.util.misc.Game;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;

public abstract class ModuleManager {
    public static final String MODULE_CONFIG_FILE_NAME = "modules.cfg";
    public static final String CATEGORY_MODULES = "modules";
    private static Set loadedModules = EnumSet.noneOf(Module.class);
    private static Set unloadedModules = EnumSet.allOf(Module.class);

    public static void preInit() {
        boolean changed;
        Locale locale = Locale.getDefault();
        Locale.setDefault(Locale.ENGLISH);
        Configuration config = new Configuration(new File(Railcraft.getMod().getConfigFolder(), MODULE_CONFIG_FILE_NAME));
        config.load();
        config.addCustomCategoryComment(CATEGORY_MODULES, "Disabling these modules can greatly change how the mod functions.\nFor example, disabling the Train Module will prevent you from linking carts.\nDisabling the World Module will disable all world gen.\nDisabling the Energy Module will remove the energy requirement from machines, but will only do so if Forestry or Buildcraft are not installed.");
        EnumSet<Module> toLoad = EnumSet.allOf(Module.class);
        Iterator it = toLoad.iterator();
        while (it.hasNext()) {
            Module m = (Module)((Object)it.next());
            if (m == Module.CORE) continue;
            if (!ModuleManager.isEnabled(config, m)) {
                it.remove();
                Game.log(Level.FINER, "Module disabled: {0}", new Object[]{m});
                continue;
            }
            IModule inst = m.instance;
            if (inst.canModuleLoad()) continue;
            it.remove();
            inst.printLoadError();
        }
        do {
            changed = false;
            it = toLoad.iterator();
            while (it.hasNext()) {
                Module m = (Module)((Object)it.next());
                Set deps = m.instance().getDependancies();
                if (toLoad.containsAll(deps)) continue;
                it.remove();
                changed = true;
                Game.log(Level.FINER, "Module {0} is missing dependancies: {1}", new Object[]{m, deps});
            }
        } while (changed);
        unloadedModules.removeAll(toLoad);
        loadedModules.addAll(toLoad);
        if (config.hasChanged()) {
            config.save();
        }
        Locale.setDefault(locale);
        for (Module m : loadedModules) {
            ModuleManager.preInit(m);
        }
        for (Module m : loadedModules) {
            ModuleManager.initFirst(m);
        }
    }

    public static void init() {
        for (Module m : loadedModules) {
            ModuleManager.initSecond(m);
        }
    }

    public static void postInit() {
        for (Module m : loadedModules) {
            ModuleManager.postInit(m);
        }
        for (Module m : unloadedModules) {
            ModuleManager.postInitNotLoaded(m);
        }
    }

    private static boolean isEnabled(Configuration config, Module m) {
        boolean defaultValue = true;
        Property prop = config.get(CATEGORY_MODULES, m.toString().toLowerCase(Locale.ENGLISH).replace('_', '.'), defaultValue);
        return prop.getBoolean(true);
    }

    public static boolean isModuleLoaded(Module module) {
        return loadedModules.contains((Object)module);
    }

    private static void preInit(Module module) {
        IModule instance = module.instance;
        if (instance != null) {
            boolean override = false;
            try {
                override = instance.getClass().getMethod("preInit", new Class[0]).getDeclaringClass() != AbstractModule.class;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (override) {
                Game.log(Level.FINER, "Pre-Init Start: {0}", instance);
                instance.preInit();
                Game.log(Level.FINER, "Pre-Init Complete: {0}", instance);
            }
        }
    }

    private static void initFirst(Module module) {
        IModule instance = module.instance;
        if (instance != null) {
            boolean override = false;
            try {
                override = instance.getClass().getMethod("initFirst", new Class[0]).getDeclaringClass() != AbstractModule.class;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (override) {
                Game.log(Level.FINER, "Init-First Start: {0}", instance);
                instance.initFirst();
                Game.log(Level.FINER, "Init-First Complete: {0}", instance);
            }
        }
    }

    private static void initSecond(Module module) {
        IModule instance = module.instance;
        if (instance != null) {
            boolean override = false;
            try {
                override = instance.getClass().getMethod("initSecond", new Class[0]).getDeclaringClass() != AbstractModule.class;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (override) {
                Game.log(Level.FINER, "Init-Second Start: {0}", instance);
                instance.initSecond();
                Game.log(Level.FINER, "Init-Second Complete: {0}", instance);
            }
        }
    }

    private static void postInit(Module module) {
        IModule instance = module.instance;
        if (instance != null) {
            boolean override = false;
            try {
                override = instance.getClass().getMethod("postInit", new Class[0]).getDeclaringClass() != AbstractModule.class;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (override) {
                Game.log(Level.FINER, "Post-Init Start: {0}", instance);
                instance.postInit();
                Game.log(Level.FINER, "Post-Init Complete: {0}", instance);
            }
        }
    }

    private static void postInitNotLoaded(Module module) {
        IModule instance = module.instance;
        if (instance != null) {
            boolean override = false;
            try {
                override = instance.getClass().getMethod("postInitNotLoaded", new Class[0]).getDeclaringClass() != AbstractModule.class;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (override) {
                Game.log(Level.FINER, "Disabled-Init Start: {0}", instance);
                instance.postInitNotLoaded();
                Game.log(Level.FINER, "Disabled-Init Complete: {0}", instance);
            }
        }
    }

    public static enum Module {
        CORE((IModule)new ModuleCore()),
        FACTORY((IModule)new ModuleFactory()),
        EXTRAS((IModule)new ModuleExtras()),
        TRACKS((IModule)new ModuleTrack()),
        TRACKS_HIGHSPEED((IModule)new ModuleTracksHighSpeed()),
        TRACKS_WOOD((IModule)new ModuleTracksWood()),
        TRACKS_REINFORCED((IModule)new ModuleTracksReinforced()),
        SIGNALS((IModule)new ModuleSignals()),
        STRUCTURES((IModule)new ModuleStructures()),
        AUTOMATION((IModule)new ModuleAutomation()),
        TRANSPORT((IModule)new ModuleTransport()),
        IC2((IModule)new ModuleIC2()),
        FORESTRY((IModule)new ModuleForestry()),
        THAUMCRAFT((IModule)new ModuleThaumcraft()),
        STEAM((IModule)new ModuleSteam()),
        WORLD((IModule)new ModuleWorld()),
        CHUNK_LOADING((IModule)new ModuleChunkLoading()),
        SEASONAL((IModule)new ModuleSeasonal()),
        TRAIN((IModule)new ModuleTrain()),
        LOCOMOTIVES((IModule)new ModuleLocomotives()),
        ROUTING((IModule)new ModuleRouting()),
        EMBLEM((IModule)new ModuleEmblem()),
        MAGIC((IModule)new ModuleMagic());

        private final IModule instance;

        /*
         * WARNING - Possible parameter corruption
         * WARNING - void declaration
         */
        private Module() {
            void instance;
            this.instance = instance;
        }

        public IModule instance() {
            return this.instance;
        }

        public boolean isEnabled() {
            return ModuleManager.isModuleLoaded(this);
        }
    }
}

