/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.plugins.forge;

import mods.railcraft.common.core.RailcraftConfig;
import net.minecraft.item.ItemStack;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraftforge.common.ChestGenHooks;

public class LootPlugin {
    public static void increaseLootGen(int min, int max, String ... locations) {
        for (String location : locations) {
            ChestGenHooks lootInfo = ChestGenHooks.getInfo((String)location);
            lootInfo.setMin(lootInfo.getMin() + min);
            lootInfo.setMax(lootInfo.getMax() + max);
        }
    }

    public static void addLoot(ItemStack loot, int minStack, int maxStack, String tag, String ... locations) {
        WeightedRandomChestContent contents = new WeightedRandomChestContent(loot, minStack, maxStack, RailcraftConfig.getLootChance(tag));
        LootPlugin.addLoot(contents, locations);
    }

    public static void addLoot(WeightedRandomChestContent loot, String ... locations) {
        for (String location : locations) {
            ChestGenHooks.addItem((String)location, (WeightedRandomChestContent)loot);
        }
    }

    public static void addLootWarrior(ItemStack loot, int minStack, int maxStack, String tag) {
        LootPlugin.addLoot(loot, minStack, maxStack, tag, "villageBlacksmith", "dungeonChest", "pyramidDesertyChest", "pyramidJungleChest", "strongholdCorridor", "strongholdCrossing");
    }

    public static void addLootMineshaft(ItemStack loot, int minStack, int maxStack, String tag) {
        LootPlugin.addLoot(loot, minStack, maxStack, tag, "mineshaftCorridor");
    }

    public static void addLootTool(ItemStack loot, int minStack, int maxStack, String tag) {
        LootPlugin.addLoot(loot, minStack, maxStack, tag, "mineshaftCorridor", "villageBlacksmith");
    }
}

