/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.util.inventory.wrappers;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.ForgeDirection;

public class InventoryMapper
implements IInventory {
    private final IInventory inv;
    private final int start;
    private final int size;
    private int stackSizeLimit = -1;
    private boolean checkItems = true;

    public InventoryMapper(IInventory inv, ForgeDirection side) {
        this(inv, InventoryMapper.getInventoryStart(inv, side), InventoryMapper.getInventorySize(inv, side));
    }

    public InventoryMapper(IInventory inv) {
        this(inv, 0, inv.func_70302_i_(), true);
    }

    public InventoryMapper(IInventory inv, boolean checkItems) {
        this(inv, 0, inv.func_70302_i_(), checkItems);
    }

    public InventoryMapper(IInventory inv, int start, int size) {
        this(inv, start, size, true);
    }

    public InventoryMapper(IInventory inv, int start, int size, boolean checkItems) {
        this.inv = inv;
        this.start = start;
        this.size = size;
        this.checkItems = checkItems;
    }

    protected static int getInventorySize(IInventory inv, ForgeDirection side) {
        return inv.func_70302_i_();
    }

    protected static int getInventoryStart(IInventory inv, ForgeDirection side) {
        return 0;
    }

    public IInventory getBaseInventory() {
        return this.inv;
    }

    public int func_70302_i_() {
        return this.size;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inv.func_70301_a(this.start + slot);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return this.inv.func_70298_a(this.start + slot, amount);
    }

    public void func_70299_a(int slot, ItemStack itemstack) {
        this.inv.func_70299_a(this.start + slot, itemstack);
    }

    public String func_70303_b() {
        return this.inv.func_70303_b();
    }

    public void setStackSizeLimit(int limit) {
        this.stackSizeLimit = limit;
    }

    public int func_70297_j_() {
        return this.stackSizeLimit > 0 ? this.stackSizeLimit : this.inv.func_70297_j_();
    }

    public void func_70296_d() {
        this.inv.func_70296_d();
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.inv.func_70300_a(entityplayer);
    }

    public void func_70295_k_() {
        this.inv.func_70295_k_();
    }

    public void func_70305_f() {
        this.inv.func_70305_f();
    }

    public ItemStack func_70304_b(int slot) {
        return this.inv.func_70304_b(this.start + slot);
    }

    public boolean func_94042_c() {
        return this.inv.func_94042_c();
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (this.checkItems) {
            return this.inv.func_94041_b(this.start + slot, stack);
        }
        return true;
    }
}

