/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.common.worldgen;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import mods.railcraft.common.plugins.forge.OreDictPlugin;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFluid;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenQuarry
extends WorldGenerator {
    private static final int DISTANCE_OUTER_SQ = 64;
    private final Block blockStone;
    private final int meta;
    public final Set replaceable = new HashSet();

    public WorldGenQuarry(Block block, int meta) {
        this.blockStone = block;
        this.meta = meta;
        this.replaceable.add(Block.field_71950_I);
        this.replaceable.add(Block.field_71949_H);
        this.replaceable.add(Block.field_71941_G);
        this.replaceable.add(Block.field_72073_aw);
        this.replaceable.add(Block.field_72068_bR);
        this.replaceable.add(Block.field_71947_N);
        this.replaceable.add(Block.field_94342_cr);
        this.replaceable.add(Block.field_72047_aN);
        this.replaceable.add(Block.field_72048_aO);
        this.replaceable.add(Block.field_71979_v);
        this.replaceable.add(Block.field_71940_F);
        this.replaceable.add(Block.field_71980_u);
        this.replaceable.add(Block.field_72041_aW);
        this.replaceable.addAll(OreDictPlugin.getOreBlocks());
    }

    public boolean func_76484_a(World world, Random rand, int x, int y, int z) {
        int distSq;
        int j;
        int k;
        int i;
        boolean clearTop = true;
        for (i = -8; i < 8; ++i) {
            block1: for (k = -8; k < 8; ++k) {
                for (j = 1; j < 4 && j + y < world.func_72940_L() - 1; ++j) {
                    distSq = i * i + k * k;
                    if (distSq > 64 || !this.isLiquid(world, x + i, y + j, z + k)) continue;
                    clearTop = false;
                    continue block1;
                }
            }
        }
        if (clearTop) {
            for (i = -8; i < 8; ++i) {
                for (k = -8; k < 8; ++k) {
                    for (j = 1; j < 4 && j + y < world.func_72940_L() - 1 && ((distSq = i * i + k * k) > 64 || this.placeAir(world, rand, x + i, y + j, z + k)); ++j) {
                    }
                }
            }
        }
        for (i = -8; i < 8; ++i) {
            for (k = -8; k < 8; ++k) {
                for (j = -8; j < 1 && j + y < world.func_72940_L() - 1; ++j) {
                    distSq = i * i + k * k + j * j;
                    if (distSq > 64) continue;
                    this.placeStone(world, rand, x + i, y + j, z + k);
                }
            }
        }
        return true;
    }

    private boolean isLiquid(World world, int x, int y, int z) {
        int blockId = world.func_72798_a(x, y, z);
        return Block.field_71973_m[blockId] instanceof BlockFluid;
    }

    private boolean placeAir(World world, Random rand, int x, int y, int z) {
        if (world.func_72798_a(x, y + 1, z) != 0) {
            return false;
        }
        if (this.isLiquid(world, x, y, z)) {
            return false;
        }
        world.func_72832_d(x, y, z, 0, 0, 2);
        return true;
    }

    private void placeStone(World world, Random rand, int x, int y, int z) {
        if (this.isReplaceable(world, x, y, z)) {
            world.func_72832_d(x, y, z, this.blockStone.field_71990_ca, this.meta, 2);
        }
    }

    private boolean isReplaceable(World world, int x, int y, int z) {
        Block existing = Block.field_71973_m[world.func_72798_a(x, y, z)];
        if (existing == null) {
            return false;
        }
        if (existing.isGenMineableReplaceable(world, x, y, z, Block.field_71981_t.field_71990_ca)) {
            return true;
        }
        return this.replaceable.contains(existing);
    }
}

