/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumArmorMaterial;
import net.minecraft.item.EnumToolMaterial;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraftforge.common.EnumHelper;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.CrucibleRecipe;
import thaumcraft.api.crafting.InfusionEnchantmentRecipe;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.crafting.ShapedArcaneRecipe;
import thaumcraft.api.crafting.ShapelessArcaneRecipe;
import thaumcraft.api.research.IScanEventHandler;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchCategoryList;
import thaumcraft.api.research.ResearchItem;
import thaumcraft.api.research.ResearchPage;

public class ThaumcraftApi {
    public static EnumToolMaterial toolMatThaumium = EnumHelper.addToolMaterial((String)"THAUMIUM", (int)3, (int)400, (float)7.0f, (float)2.0f, (int)22);
    public static EnumToolMaterial toolMatElemental = EnumHelper.addToolMaterial((String)"THAUMIUM_ELEMENTAL", (int)3, (int)1500, (float)10.0f, (float)3.0f, (int)18);
    public static EnumArmorMaterial armorMatThaumium = EnumHelper.addArmorMaterial((String)"THAUMIUM", (int)25, (int[])new int[]{2, 6, 5, 2}, (int)25);
    public static EnumArmorMaterial armorMatSpecial = EnumHelper.addArmorMaterial((String)"SPECIAL", (int)25, (int[])new int[]{1, 3, 2, 1}, (int)25);
    public static int enchantFrugal;
    public static int enchantPotency;
    public static int enchantWandFortune;
    public static int enchantHaste;
    public static int enchantRepair;
    public static ArrayList portableHoleBlackList;
    public static ArrayList scanEventhandlers;
    public static ArrayList scanEntities;
    private static ArrayList craftingRecipes;
    private static HashMap smeltingBonus;
    @Deprecated
    private static ArrayList smeltingBonusExlusion;
    private static HashMap keyCache;
    public static ConcurrentHashMap objectTags;

    public static void registerScanEventhandler(IScanEventHandler scanEventHandler) {
        scanEventhandlers.add(scanEventHandler);
    }

    public static void registerEntityTag(String entityName, AspectList aspects, NBTBase ... nbt) {
        scanEntities.add(new EntityTags(entityName, nbt, aspects));
    }

    public static void addSmeltingBonus(ItemStack in, ItemStack out) {
        smeltingBonus.put(Arrays.asList(in.field_77993_c, in.func_77960_j()), new ItemStack(out.field_77993_c, 0, out.func_77960_j()));
    }

    public static void addSmeltingBonus(String in, ItemStack out) {
        smeltingBonus.put(in, new ItemStack(out.field_77993_c, 0, out.func_77960_j()));
    }

    public static ItemStack getSmeltingBonus(ItemStack in) {
        ItemStack out = (ItemStack)smeltingBonus.get(Arrays.asList(in.field_77993_c, in.func_77960_j()));
        if (out == null) {
            String od = OreDictionary.getOreName((int)OreDictionary.getOreID((ItemStack)in));
            out = (ItemStack)smeltingBonus.get(od);
        }
        return out;
    }

    @Deprecated
    public static void addSmeltingBonusExclusion(ItemStack in) {
    }

    @Deprecated
    public static boolean isSmeltingBonusExluded(ItemStack in) {
        return false;
    }

    public static List getCraftingRecipes() {
        return craftingRecipes;
    }

    public static ShapedArcaneRecipe addArcaneCraftingRecipe(String research, ItemStack result, AspectList aspects, Object ... recipe) {
        ShapedArcaneRecipe r = new ShapedArcaneRecipe(research, result, aspects, recipe);
        craftingRecipes.add(r);
        return r;
    }

    public static ShapelessArcaneRecipe addShapelessArcaneCraftingRecipe(String research, ItemStack result, AspectList aspects, Object ... recipe) {
        ShapelessArcaneRecipe r = new ShapelessArcaneRecipe(research, result, aspects, recipe);
        craftingRecipes.add(r);
        return r;
    }

    public static InfusionRecipe addInfusionCraftingRecipe(String research, Object result, int instability, AspectList aspects, ItemStack input, ItemStack[] recipe) {
        if (!(result instanceof ItemStack) && !(result instanceof NBTBase)) {
            return null;
        }
        InfusionRecipe r = new InfusionRecipe(research, result, instability, aspects, input, recipe);
        craftingRecipes.add(r);
        return r;
    }

    public static InfusionEnchantmentRecipe addInfusionEnchantmentRecipe(String research, Enchantment enchantment, int instability, AspectList aspects, ItemStack[] recipe) {
        InfusionEnchantmentRecipe r = new InfusionEnchantmentRecipe(research, enchantment, instability, aspects, recipe);
        craftingRecipes.add(r);
        return r;
    }

    public static InfusionRecipe getInfusionRecipe(ItemStack res) {
        for (Object r : ThaumcraftApi.getCraftingRecipes()) {
            if (!(r instanceof InfusionRecipe) || !(((InfusionRecipe)r).recipeOutput instanceof ItemStack) || !((ItemStack)((InfusionRecipe)r).recipeOutput).func_77969_a(res)) continue;
            return (InfusionRecipe)r;
        }
        return null;
    }

    public static CrucibleRecipe addCrucibleRecipe(String key, ItemStack result, Object catalyst, AspectList tags) {
        CrucibleRecipe rc = new CrucibleRecipe(key, result, catalyst, tags);
        ThaumcraftApi.getCraftingRecipes().add(rc);
        return rc;
    }

    public static CrucibleRecipe getCrucibleRecipe(ItemStack stack) {
        for (Object r : ThaumcraftApi.getCraftingRecipes()) {
            if (!(r instanceof CrucibleRecipe) || !((CrucibleRecipe)r).recipeOutput.func_77969_a(stack)) continue;
            return (CrucibleRecipe)r;
        }
        return null;
    }

    public static Object[] getCraftingRecipeKey(EntityPlayer player, ItemStack stack) {
        int[] key = new int[]{stack.field_77993_c, stack.func_77960_j()};
        if (keyCache.containsKey(key)) {
            if (keyCache.get(key) == null) {
                return null;
            }
            if (ThaumcraftApiHelper.isResearchComplete(player.field_71092_bJ, (String)((Object[])keyCache.get(key))[0])) {
                return (Object[])keyCache.get(key);
            }
            return null;
        }
        for (ResearchCategoryList rcl : ResearchCategories.researchCategories.values()) {
            for (ResearchItem ri : rcl.research.values()) {
                if (ri.getPages() == null) continue;
                for (int a = 0; a < ri.getPages().length; ++a) {
                    ResearchPage page = ri.getPages()[a];
                    if (page.recipeOutput == null || stack == null || !page.recipeOutput.func_77969_a(stack)) continue;
                    keyCache.put(key, new Object[]{ri.key, a});
                    if (ThaumcraftApiHelper.isResearchComplete(player.field_71092_bJ, ri.key)) {
                        return new Object[]{ri.key, a};
                    }
                    return null;
                }
            }
        }
        keyCache.put(key, null);
        return null;
    }

    public static boolean exists(int id, int meta) {
        AspectList tmp = (AspectList)objectTags.get(Arrays.asList(id, meta));
        if (tmp == null) {
            tmp = (AspectList)objectTags.get(Arrays.asList(id, -1));
            if (meta == -1 && tmp == null) {
                int index = 0;
                do {
                    tmp = (AspectList)objectTags.get(Arrays.asList(id, index));
                } while (++index < 16 && tmp == null);
            }
            if (tmp == null) {
                return false;
            }
        }
        return true;
    }

    public static void registerObjectTag(int id, int meta, AspectList aspects) {
        if (aspects == null) {
            aspects = new AspectList();
        }
        objectTags.put(Arrays.asList(id, meta), aspects);
    }

    public static void registerObjectTag(int id, int[] meta, AspectList aspects) {
        if (aspects == null) {
            aspects = new AspectList();
        }
        objectTags.put(Arrays.asList(id, meta), aspects);
    }

    public static void registerObjectTag(String oreDict, AspectList aspects) {
        ArrayList ores;
        if (aspects == null) {
            aspects = new AspectList();
        }
        if ((ores = OreDictionary.getOres((String)oreDict)) != null && ores.size() > 0) {
            for (ItemStack ore : ores) {
                int d = ore.func_77960_j();
                if (d == Short.MAX_VALUE) {
                    d = -1;
                }
                objectTags.put(Arrays.asList(ore.field_77993_c, d), aspects);
            }
        }
    }

    public static void registerComplexObjectTag(int id, int meta, AspectList aspects) {
        if (!ThaumcraftApi.exists(id, meta)) {
            AspectList tmp = ThaumcraftApiHelper.generateTags(id, meta);
            if (tmp != null && tmp.size() > 0) {
                for (Aspect tag : tmp.getAspects()) {
                    aspects.add(tag, tmp.getAmount(tag));
                }
            }
            ThaumcraftApi.registerObjectTag(id, meta, aspects);
        } else {
            AspectList tmp = ThaumcraftApiHelper.getObjectAspects(new ItemStack(id, 1, meta));
            for (Aspect tag : aspects.getAspects()) {
                tmp.merge(tag, tmp.getAmount(tag));
            }
            ThaumcraftApi.registerObjectTag(id, meta, tmp);
        }
    }

    static {
        portableHoleBlackList = new ArrayList();
        scanEventhandlers = new ArrayList();
        scanEntities = new ArrayList();
        craftingRecipes = new ArrayList();
        smeltingBonus = new HashMap();
        smeltingBonusExlusion = new ArrayList();
        keyCache = new HashMap();
        objectTags = new ConcurrentHashMap();
    }

    public static class EntityTags {
        public String entityName;
        public NBTBase[] nbts;
        public AspectList aspects;

        public EntityTags(String entityName, NBTBase[] nbts, AspectList aspects) {
            this.entityName = entityName;
            this.nbts = nbts;
            this.aspects = aspects;
        }
    }
}

