/*
 * Decompiled with CFR 0.152.
 */
package icbm.core.blocks;

import com.google.common.io.ByteArrayDataInput;
import icbm.core.ICBMCore;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import resonant.lib.network.IPacketReceiver;
import resonant.lib.network.PacketHandler;

public class TileCamouflage
extends TileEntity
implements IPacketReceiver {
    private int blockID = 0;
    private int blockMeta = 0;
    private boolean isSolid = true;
    private byte renderSides = 0;

    public boolean canUpdate() {
        return false;
    }

    public void onReceivePacket(ByteArrayDataInput data, EntityPlayer player, Object ... extra) {
        try {
            this.setMimicBlock(data.readInt(), data.readInt());
            this.renderSides = data.readByte();
            this.isSolid = data.readBoolean();
            this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Packet func_70319_e() {
        return ICBMCore.PACKET_TILE.getPacket((TileEntity)this, new Object[]{this.blockID, this.blockMeta, this.renderSides, this.isSolid});
    }

    public boolean getCanCollide() {
        return this.isSolid;
    }

    public void setCanCollide(boolean isSolid) {
        this.isSolid = isSolid;
        if (!this.field_70331_k.field_72995_K) {
            PacketHandler.sendPacketToClients((Packet)this.func_70319_e());
        }
    }

    public void toggleCollision() {
        this.setCanCollide(!this.isSolid);
    }

    public int getMimicBlockID() {
        return this.blockID;
    }

    public int getMimicBlockMeta() {
        return this.blockMeta;
    }

    public void setMimicBlock(int blockID, int metadata) {
        if (this.blockID != blockID || this.blockMeta != metadata) {
            this.blockID = Math.max(blockID, 0);
            this.blockMeta = Math.max(metadata, 0);
            if (!this.field_70331_k.field_72995_K) {
                PacketHandler.sendPacketToClients((Packet)this.func_70319_e());
            }
        }
    }

    public boolean canRenderSide(ForgeDirection direction) {
        return (this.renderSides & 1 << direction.ordinal()) != 0;
    }

    public void setRenderSide(ForgeDirection direction, boolean isClear) {
        this.renderSides = isClear ? (byte)(this.renderSides | 1 << direction.ordinal()) : (byte)(this.renderSides & ~(1 << direction.ordinal()));
        if (!this.field_70331_k.field_72995_K) {
            PacketHandler.sendPacketToClients((Packet)this.func_70319_e());
        }
    }

    public void toggleRenderSide(ForgeDirection direction) {
        this.setRenderSide(direction, !this.canRenderSide(direction));
    }

    public void setRenderSide(boolean isClear) {
        this.renderSides = isClear ? (byte)63 : (byte)0;
    }

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.blockID = nbt.func_74762_e("jiaHaoMa");
        this.blockMeta = nbt.func_74762_e("jiaMetadata");
        this.renderSides = nbt.func_74771_c("renderSides");
        this.isSolid = nbt.func_74767_n("isYing");
    }

    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74768_a("jiaHaoMa", this.blockID);
        nbt.func_74768_a("jiaMetadata", this.blockMeta);
        nbt.func_74774_a("renderSides", this.renderSides);
        nbt.func_74757_a("isYing", this.isSolid);
    }
}

