/*
 * Decompiled with CFR 0.152.
 */
package icbm.core.blocks;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import icbm.core.ICBMCore;
import icbm.core.items.ItemSignalDisrupter;
import icbm.core.prefab.TileFrequency;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.ForgeDirection;
import resonant.api.IRedstoneProvider;
import resonant.lib.network.IPacketReceiver;
import universalelectricity.api.electricity.IVoltageInput;
import universalelectricity.api.energy.EnergyStorageHandler;
import universalelectricity.api.vector.Vector3;

public class TileProximityDetector
extends TileFrequency
implements IRedstoneProvider,
IPacketReceiver,
IVoltageInput {
    private static final int MAX_DISTANCE = 30;
    private static final float DIAN = 5.0f;
    public boolean isDetect = false;
    public Vector3 minCoord = new Vector3(9.0, 9.0, 9.0);
    public Vector3 maxCoord = new Vector3(9.0, 9.0, 9.0);
    public byte mode = 0;
    private final Set<EntityPlayer> yongZhe = new HashSet<EntityPlayer>();
    public boolean isInverted = false;

    public TileProximityDetector() {
        this.setEnergyHandler(new EnergyStorageHandler(200L, 100L));
    }

    public void initiate() {
        super.initiate();
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.func_70311_o().field_71990_ca);
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K && this.ticks % 20L == 0L) {
            for (EntityPlayer wanJia : this.yongZhe) {
                PacketDispatcher.sendPacketToPlayer((Packet)this.func_70319_e(), (Player)((Player)wanJia));
            }
            boolean isDetectThisCheck = false;
            if (this.getEnergyHandler().checkExtract()) {
                AxisAlignedBB bounds = AxisAlignedBB.func_72330_a((double)((double)this.field_70329_l - this.minCoord.x), (double)((double)this.field_70330_m - this.minCoord.y), (double)((double)this.field_70327_n - this.minCoord.z), (double)((double)this.field_70329_l + this.maxCoord.x + 1.0), (double)((double)this.field_70330_m + this.maxCoord.y + 1.0), (double)((double)this.field_70327_n + this.maxCoord.z + 1.0));
                List entitiesNearby = this.field_70331_k.func_72872_a(EntityLivingBase.class, bounds);
                for (EntityLivingBase entity : entitiesNearby) {
                    if (entity instanceof EntityPlayer && (this.mode == 0 || this.mode == 1)) {
                        boolean gotDisrupter = false;
                        for (ItemStack inventory : ((EntityPlayer)entity).field_71071_by.field_70462_a) {
                            if (inventory == null || !(inventory.func_77973_b() instanceof ItemSignalDisrupter) || ((ItemSignalDisrupter)inventory.func_77973_b()).getFrequency(inventory) != this.getFrequency()) continue;
                            gotDisrupter = true;
                            break;
                        }
                        if (gotDisrupter) {
                            if (!this.isInverted) continue;
                            isDetectThisCheck = true;
                            break;
                        }
                        if (this.isInverted) continue;
                        isDetectThisCheck = true;
                        continue;
                    }
                    if (this.isInverted || entity instanceof EntityPlayer || this.mode != 0 && this.mode != 2) continue;
                    isDetectThisCheck = true;
                    break;
                }
                this.getEnergyHandler().extractEnergy();
            }
            if (isDetectThisCheck != this.isDetect) {
                this.isDetect = isDetectThisCheck;
                this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.func_70311_o().field_71990_ca);
            }
        }
    }

    public Packet func_70319_e() {
        return ICBMCore.PACKET_TILE.getPacket((TileEntity)this, new Object[]{0, this.getEnergyHandler().getEnergy(), this.getFrequency(), this.mode, this.isInverted, this.minCoord.intX(), this.minCoord.intY(), this.minCoord.intZ(), this.maxCoord.intX(), this.maxCoord.intY(), this.maxCoord.intZ()});
    }

    @Override
    public void onReceivePacket(ByteArrayDataInput data, EntityPlayer player, Object ... extra) {
        try {
            switch (data.readInt()) {
                case 0: {
                    this.setEnergy(ForgeDirection.UNKNOWN, data.readLong());
                    this.setFrequency(data.readInt());
                    this.mode = data.readByte();
                    this.isInverted = data.readBoolean();
                    this.minCoord = new Vector3((double)Math.max(0, Math.min(30, data.readInt())), (double)Math.max(0, Math.min(30, data.readInt())), (double)Math.max(0, Math.min(30, data.readInt())));
                    this.maxCoord = new Vector3((double)Math.max(0, Math.min(30, data.readInt())), (double)Math.max(0, Math.min(30, data.readInt())), (double)Math.max(0, Math.min(30, data.readInt())));
                    break;
                }
                case 1: {
                    this.mode = data.readByte();
                    break;
                }
                case 2: {
                    this.setFrequency(data.readInt());
                    break;
                }
                case 3: {
                    this.minCoord = new Vector3((double)Math.max(0, Math.min(30, data.readInt())), (double)Math.max(0, Math.min(30, data.readInt())), (double)Math.max(0, Math.min(30, data.readInt())));
                    break;
                }
                case 4: {
                    this.maxCoord = new Vector3((double)Math.max(0, Math.min(30, data.readInt())), (double)Math.max(0, Math.min(30, data.readInt())), (double)Math.max(0, Math.min(30, data.readInt())));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.mode = nbt.func_74771_c("mode");
        this.isInverted = nbt.func_74767_n("isInverted");
        this.minCoord = new Vector3(nbt.func_74775_l("minCoord"));
        this.maxCoord = new Vector3(nbt.func_74775_l("maxCoord"));
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74774_a("mode", this.mode);
        nbt.func_74757_a("isInverted", this.isInverted);
        nbt.func_74766_a("minCoord", this.minCoord.writeToNBT(new NBTTagCompound()));
        nbt.func_74766_a("maxCoord", this.maxCoord.writeToNBT(new NBTTagCompound()));
    }

    public boolean isPoweringTo(ForgeDirection side) {
        return this.isDetect;
    }

    public boolean isIndirectlyPoweringTo(ForgeDirection side) {
        return this.isDetect;
    }

    @Override
    public long getVoltageInput(ForgeDirection direction) {
        return 240L;
    }

    @Override
    public void onWrongVoltage(ForgeDirection direction, long voltage) {
    }
}

