/*
 * Decompiled with CFR 0.152.
 */
package icbm.core.entity;

import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class EntityFragments
extends Entity
implements IEntityAdditionalSpawnData {
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    private int inTile = 0;
    private int inData = 0;
    private boolean inGround = false;
    public boolean doesArrowBelongToPlayer = false;
    public boolean isExplosive;
    public boolean isAnvil;
    private boolean isExploding = false;
    public int arrowShake = 0;
    private int ticksInGround;
    private int ticksInAir = 0;
    private final int damage = 11;
    private int knowBackStrength;
    public boolean arrowCritical = false;
    public float explosionSize = 1.5f;

    public EntityFragments(World par1World) {
        super(par1World);
        this.func_70105_a(0.5f, 0.5f);
    }

    public EntityFragments(World par1World, double x, double y, double z, boolean isExplosive, boolean isAnvil) {
        super(par1World);
        this.func_70107_b(x, y, z);
        this.field_70129_M = 0.0f;
        this.isExplosive = isExplosive;
        this.isAnvil = isAnvil;
        if (this.isAnvil) {
            this.func_70105_a(1.0f, 1.0f);
        } else {
            this.func_70105_a(0.5f, 0.5f);
        }
    }

    public void writeSpawnData(ByteArrayDataOutput data) {
        data.writeBoolean(this.isExplosive);
        data.writeBoolean(this.isAnvil);
    }

    public void readSpawnData(ByteArrayDataInput data) {
        this.isExplosive = data.readBoolean();
        this.isAnvil = data.readBoolean();
    }

    protected void func_70088_a() {
    }

    public String func_70023_ak() {
        return "Fragments";
    }

    public void setArrowHeading(double par1, double par3, double par5, float par7, float par8) {
        float var9 = MathHelper.func_76133_a((double)(par1 * par1 + par3 * par3 + par5 * par5));
        par1 /= (double)var9;
        par3 /= (double)var9;
        par5 /= (double)var9;
        par1 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)par8;
        par3 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)par8;
        par5 += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)par8;
        this.field_70159_w = par1 *= (double)par7;
        this.field_70181_x = par3 *= (double)par7;
        this.field_70179_y = par5 *= (double)par7;
        float var10 = MathHelper.func_76133_a((double)(par1 * par1 + par5 * par5));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(par1, par5) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(par3, var10) * 180.0 / Math.PI);
        this.ticksInGround = 0;
    }

    public void func_70016_h(double par1, double par3, double par5) {
        this.field_70159_w = par1;
        this.field_70181_x = par3;
        this.field_70179_y = par5;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float var7 = MathHelper.func_76133_a((double)(par1 * par1 + par5 * par5));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(par1, par5) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(par3, var7) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A;
            this.field_70126_B = this.field_70177_z;
            this.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, this.field_70125_A);
            this.ticksInGround = 0;
        }
    }

    private void explode() {
        if (!this.isExploding && !this.field_70170_p.field_72995_K) {
            this.isExploding = true;
            this.field_70170_p.func_72876_a((Entity)this, (double)this.xTile, (double)this.yTile, (double)this.zTile, this.explosionSize, true);
            this.func_70106_y();
        }
    }

    public void func_70071_h_() {
        int var15;
        super.func_70071_h_();
        if (this.isAnvil) {
            ArrayList entities = new ArrayList(this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D));
            for (Entity entity : entities) {
                entity.func_70097_a(DamageSource.field_82728_o, 15.0f);
            }
        }
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float var1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70126_B = this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
            this.field_70127_C = this.field_70125_A = (float)(Math.atan2(this.field_70181_x, var1) * 180.0 / Math.PI);
        }
        if ((var15 = this.field_70170_p.func_72798_a(this.xTile, this.yTile, this.zTile)) > 0) {
            Block.field_71973_m[var15].func_71902_a((IBlockAccess)this.field_70170_p, this.xTile, this.yTile, this.zTile);
            AxisAlignedBB var2 = Block.field_71973_m[var15].func_71872_e(this.field_70170_p, this.xTile, this.yTile, this.zTile);
            if (var2 != null && var2.func_72318_a(Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v))) {
                this.inGround = true;
            }
        }
        if (this.arrowShake > 0) {
            --this.arrowShake;
        }
        if (this.inGround) {
            var15 = this.field_70170_p.func_72798_a(this.xTile, this.yTile, this.zTile);
            int var18 = this.field_70170_p.func_72805_g(this.xTile, this.yTile, this.zTile);
            if (var15 == this.inTile && var18 == this.inData) {
                if (this.isExplosive) {
                    this.explode();
                } else {
                    if (this.isAnvil && this.field_70170_p.field_73012_v.nextFloat() > 0.5f) {
                        this.field_70170_p.func_72926_e(1022, (int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v, 0);
                    }
                    this.func_70106_y();
                }
            } else {
                this.inGround = false;
                this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.ticksInGround = 0;
                this.ticksInAir = 0;
            }
        } else {
            float var10;
            int var8;
            ++this.ticksInAir;
            Vec3 var16 = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
            Vec3 var17 = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
            MovingObjectPosition movingObjPos = this.field_70170_p.func_72831_a(var16, var17, false, true);
            var16 = Vec3.func_72443_a((double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v);
            var17 = Vec3.func_72443_a((double)(this.field_70165_t + this.field_70159_w), (double)(this.field_70163_u + this.field_70181_x), (double)(this.field_70161_v + this.field_70179_y));
            if (movingObjPos != null) {
                var17 = Vec3.func_72443_a((double)movingObjPos.field_72307_f.field_72450_a, (double)movingObjPos.field_72307_f.field_72448_b, (double)movingObjPos.field_72307_f.field_72449_c);
            }
            Entity var4 = null;
            List var5 = this.field_70170_p.func_72839_b((Entity)this, this.field_70121_D.func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_72314_b(1.0, 1.0, 1.0));
            double var6 = 0.0;
            for (var8 = 0; var8 < var5.size(); ++var8) {
                double var13;
                AxisAlignedBB var11;
                MovingObjectPosition var12;
                Entity var9 = (Entity)var5.get(var8);
                if (!var9.func_70067_L() || this.ticksInAir < 5 || (var12 = (var11 = var9.field_70121_D.func_72314_b((double)(var10 = 0.3f), (double)var10, (double)var10)).func_72327_a(var16, var17)) == null || !((var13 = var16.func_72438_d(var12.field_72307_f)) < var6) && var6 != 0.0) continue;
                var4 = var9;
                var6 = var13;
            }
            if (var4 != null) {
                movingObjPos = new MovingObjectPosition(var4);
            }
            if (movingObjPos != null) {
                if (movingObjPos.field_72308_g != null) {
                    float speed = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
                    ((Object)((Object)this)).getClass();
                    int damage = (int)Math.ceil(speed * 11.0f);
                    if (this.arrowCritical) {
                        damage += this.field_70146_Z.nextInt(damage / 2 + 2);
                    }
                    DamageSource damageSource = new EntityDamageSourceIndirect("arrow", (Entity)this, (Entity)this).func_76349_b();
                    if (this.func_70027_ad()) {
                        movingObjPos.field_72308_g.func_70015_d(5);
                    }
                    if (movingObjPos.field_72308_g.func_70097_a(damageSource, (float)damage)) {
                        if (movingObjPos.field_72308_g instanceof EntityLiving) {
                            float var21;
                            EntityLiving var24 = (EntityLiving)movingObjPos.field_72308_g;
                            if (!this.field_70170_p.field_72995_K) {
                                var24.func_85034_r(var24.func_85035_bI() + 1);
                            }
                            if (this.knowBackStrength > 0 && (var21 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y))) > 0.0f) {
                                movingObjPos.field_72308_g.func_70024_g(this.field_70159_w * (double)this.knowBackStrength * (double)0.6f / (double)var21, 0.1, this.field_70179_y * (double)this.knowBackStrength * (double)0.6f / (double)var21);
                            }
                        }
                        this.field_70170_p.func_72956_a((Entity)this, "random.bowhit", 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                        this.func_70106_y();
                    } else {
                        this.field_70159_w *= (double)-0.1f;
                        this.field_70181_x *= (double)-0.1f;
                        this.field_70179_y *= (double)-0.1f;
                        this.field_70177_z += 180.0f;
                        this.field_70126_B += 180.0f;
                        this.ticksInAir = 0;
                    }
                } else {
                    this.xTile = movingObjPos.field_72311_b;
                    this.yTile = movingObjPos.field_72312_c;
                    this.zTile = movingObjPos.field_72309_d;
                    this.inTile = this.field_70170_p.func_72798_a(this.xTile, this.yTile, this.zTile);
                    this.inData = this.field_70170_p.func_72805_g(this.xTile, this.yTile, this.zTile);
                    this.field_70159_w = (float)(movingObjPos.field_72307_f.field_72450_a - this.field_70165_t);
                    this.field_70181_x = (float)(movingObjPos.field_72307_f.field_72448_b - this.field_70163_u);
                    this.field_70179_y = (float)(movingObjPos.field_72307_f.field_72449_c - this.field_70161_v);
                    float speed = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
                    this.field_70165_t -= this.field_70159_w / (double)speed * (double)0.05f;
                    this.field_70163_u -= this.field_70181_x / (double)speed * (double)0.05f;
                    this.field_70161_v -= this.field_70179_y / (double)speed * (double)0.05f;
                    this.field_70170_p.func_72956_a((Entity)this, "random.bowhit", 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                    this.inGround = true;
                    this.arrowShake = 7;
                    this.arrowCritical = false;
                }
            }
            if (this.arrowCritical) {
                for (var8 = 0; var8 < 4; ++var8) {
                    this.field_70170_p.func_72869_a("crit", this.field_70165_t + this.field_70159_w * (double)var8 / 4.0, this.field_70163_u + this.field_70181_x * (double)var8 / 4.0, this.field_70161_v + this.field_70179_y * (double)var8 / 4.0, -this.field_70159_w, -this.field_70181_x + 0.2, -this.field_70179_y);
                }
            }
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            float speed = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
            this.field_70125_A = (float)(Math.atan2(this.field_70181_x, speed) * 180.0 / Math.PI);
            while (this.field_70125_A - this.field_70127_C < -180.0f) {
                this.field_70127_C -= 360.0f;
            }
            while (this.field_70125_A - this.field_70127_C >= 180.0f) {
                this.field_70127_C += 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
            this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
            float var23 = 0.99f;
            var10 = 0.05f;
            if (this.func_70090_H()) {
                for (int var25 = 0; var25 < 4; ++var25) {
                    float var24 = 0.25f;
                    this.field_70170_p.func_72869_a("bubble", this.field_70165_t - this.field_70159_w * (double)var24, this.field_70163_u - this.field_70181_x * (double)var24, this.field_70161_v - this.field_70179_y * (double)var24, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                }
                var23 = 0.8f;
            }
            this.field_70159_w *= (double)var23;
            this.field_70181_x *= (double)var23;
            this.field_70179_y *= (double)var23;
            this.field_70181_x -= (double)var10;
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        }
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        par1NBTTagCompound.func_74777_a("xTile", (short)this.xTile);
        par1NBTTagCompound.func_74777_a("yTile", (short)this.yTile);
        par1NBTTagCompound.func_74777_a("zTile", (short)this.zTile);
        par1NBTTagCompound.func_74774_a("inTile", (byte)this.inTile);
        par1NBTTagCompound.func_74774_a("inData", (byte)this.inData);
        par1NBTTagCompound.func_74774_a("shake", (byte)this.arrowShake);
        par1NBTTagCompound.func_74774_a("inGround", (byte)(this.inGround ? 1 : 0));
        par1NBTTagCompound.func_74757_a("isExplosive", this.isExplosive);
    }

    public void func_70037_a(NBTTagCompound par1NBTTagCompound) {
        this.xTile = par1NBTTagCompound.func_74765_d("xTile");
        this.yTile = par1NBTTagCompound.func_74765_d("yTile");
        this.zTile = par1NBTTagCompound.func_74765_d("zTile");
        this.inTile = par1NBTTagCompound.func_74771_c("inTile") & 0xFF;
        this.inData = par1NBTTagCompound.func_74771_c("inData") & 0xFF;
        this.arrowShake = par1NBTTagCompound.func_74771_c("shake") & 0xFF;
        this.inGround = par1NBTTagCompound.func_74771_c("inGround") == 1;
        this.isExplosive = par1NBTTagCompound.func_74767_n("isExplosive");
    }

    public void func_70108_f(Entity par1Entity) {
        super.func_70108_f(par1Entity);
        if (this.isExplosive && this.field_70173_aa < 40) {
            this.explode();
        }
    }

    public float func_70053_R() {
        return 0.0f;
    }

    public boolean func_70075_an() {
        return false;
    }
}

