/*
 * Decompiled with CFR 0.152.
 */
package icbm.explosion;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.ReflectionHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import icbm.core.ICBMCore;
import icbm.core.SoundHandler;
import icbm.explosion.CommonProxy;
import icbm.explosion.ICBMExplosion;
import icbm.explosion.TickHandler;
import icbm.explosion.entities.EntityBombCart;
import icbm.explosion.entities.EntityExplosion;
import icbm.explosion.entities.EntityExplosive;
import icbm.explosion.entities.EntityGrenade;
import icbm.explosion.entities.EntityLightBeam;
import icbm.explosion.entities.EntityMissile;
import icbm.explosion.ex.missiles.MissilePlayerHandler;
import icbm.explosion.explosive.TileExplosive;
import icbm.explosion.fx.FXAntimatterPartical;
import icbm.explosion.gui.GuiCruiseLauncher;
import icbm.explosion.gui.GuiEMPTower;
import icbm.explosion.gui.GuiLauncherScreen;
import icbm.explosion.gui.GuiMissileCoordinator;
import icbm.explosion.gui.GuiMissileTable;
import icbm.explosion.gui.GuiRadarStation;
import icbm.explosion.machines.TileCruiseLauncher;
import icbm.explosion.machines.TileEMPTower;
import icbm.explosion.machines.TileMissileAssembler;
import icbm.explosion.machines.TileMissileCoordinator;
import icbm.explosion.machines.TileRadarStation;
import icbm.explosion.machines.launcher.TileLauncherBase;
import icbm.explosion.machines.launcher.TileLauncherFrame;
import icbm.explosion.machines.launcher.TileLauncherScreen;
import icbm.explosion.potion.PoisonFrostBite;
import icbm.explosion.render.entity.RenderEntityExplosive;
import icbm.explosion.render.entity.RenderExplosion;
import icbm.explosion.render.entity.RenderGrenade;
import icbm.explosion.render.entity.RenderLightBeam;
import icbm.explosion.render.entity.RenderMissile;
import icbm.explosion.render.item.RenderItemMissile;
import icbm.explosion.render.item.RenderRocketLauncher;
import icbm.explosion.render.tile.BlockRenderHandler;
import icbm.explosion.render.tile.RenderBombBlock;
import icbm.explosion.render.tile.RenderCruiseLauncher;
import icbm.explosion.render.tile.RenderEmpTower;
import icbm.explosion.render.tile.RenderLauncherBase;
import icbm.explosion.render.tile.RenderLauncherFrame;
import icbm.explosion.render.tile.RenderLauncherScreen;
import icbm.explosion.render.tile.RenderMissileAssembler;
import icbm.explosion.render.tile.RenderMissileCoordinator;
import icbm.explosion.render.tile.RenderRadarStation;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderMinecart;
import net.minecraft.client.renderer.entity.RendererLivingEntity;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.server.gui.IUpdatePlayerListBox;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.opengl.GL11;
import resonant.lib.render.RenderUtility;
import resonant.lib.render.fx.FXElectricBolt;
import resonant.lib.render.fx.FXElectricBoltSpawner;
import resonant.lib.render.fx.FXEnderPortalPartical;
import resonant.lib.render.fx.FXShockWave;
import resonant.lib.render.fx.FXSmoke;
import universalelectricity.api.vector.Vector3;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    private boolean disableReflectionFX = false;

    @Override
    public void preInit() {
        TickRegistry.registerTickHandler((ITickHandler)new TickHandler(), (Side)Side.CLIENT);
        MinecraftForge.EVENT_BUS.register((Object)SoundHandler.INSTANCE);
    }

    @Override
    public void init() {
        super.init();
        MinecraftForgeClient.registerItemRenderer((int)ICBMExplosion.itemRocketLauncher.field_77779_bT, (IItemRenderer)new RenderRocketLauncher());
        MinecraftForgeClient.registerItemRenderer((int)ICBMExplosion.itemMissile.field_77779_bT, (IItemRenderer)new RenderItemMissile());
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new RenderBombBlock());
        RenderingRegistry.registerBlockHandler((ISimpleBlockRenderingHandler)new BlockRenderHandler());
        RenderingRegistry.registerEntityRenderingHandler(EntityExplosive.class, (Render)new RenderEntityExplosive());
        RenderingRegistry.registerEntityRenderingHandler(EntityMissile.class, (Render)new RenderMissile(0.5f));
        RenderingRegistry.registerEntityRenderingHandler(EntityExplosion.class, (Render)new RenderExplosion());
        RenderingRegistry.registerEntityRenderingHandler(EntityLightBeam.class, (Render)new RenderLightBeam());
        RenderingRegistry.registerEntityRenderingHandler(EntityGrenade.class, (Render)new RenderGrenade());
        RenderingRegistry.registerEntityRenderingHandler(EntityBombCart.class, (Render)new RenderMinecart());
        ClientRegistry.bindTileEntitySpecialRenderer(TileCruiseLauncher.class, (TileEntitySpecialRenderer)new RenderCruiseLauncher());
        ClientRegistry.bindTileEntitySpecialRenderer(TileLauncherBase.class, (TileEntitySpecialRenderer)new RenderLauncherBase());
        ClientRegistry.bindTileEntitySpecialRenderer(TileLauncherScreen.class, (TileEntitySpecialRenderer)new RenderLauncherScreen());
        ClientRegistry.bindTileEntitySpecialRenderer(TileLauncherFrame.class, (TileEntitySpecialRenderer)new RenderLauncherFrame());
        ClientRegistry.bindTileEntitySpecialRenderer(TileRadarStation.class, (TileEntitySpecialRenderer)new RenderRadarStation());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEMPTower.class, (TileEntitySpecialRenderer)new RenderEmpTower());
        ClientRegistry.bindTileEntitySpecialRenderer(TileMissileCoordinator.class, (TileEntitySpecialRenderer)new RenderMissileCoordinator());
        ClientRegistry.bindTileEntitySpecialRenderer(TileExplosive.class, (TileEntitySpecialRenderer)new RenderBombBlock());
        ClientRegistry.bindTileEntitySpecialRenderer(TileMissileAssembler.class, (TileEntitySpecialRenderer)new RenderMissileAssembler());
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer entityPlayer, World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_72796_p(x, y, z);
        if (tileEntity instanceof TileCruiseLauncher) {
            return new GuiCruiseLauncher(entityPlayer.field_71071_by, (TileCruiseLauncher)tileEntity);
        }
        if (tileEntity instanceof TileLauncherScreen) {
            return new GuiLauncherScreen((TileLauncherScreen)tileEntity);
        }
        if (tileEntity instanceof TileRadarStation) {
            return new GuiRadarStation((TileRadarStation)tileEntity);
        }
        if (tileEntity instanceof TileEMPTower) {
            return new GuiEMPTower((TileEMPTower)tileEntity);
        }
        if (tileEntity instanceof TileMissileCoordinator) {
            return new GuiMissileCoordinator(entityPlayer.field_71071_by, (TileMissileCoordinator)tileEntity);
        }
        if (tileEntity instanceof TileMissileAssembler) {
            return new GuiMissileTable(entityPlayer.field_71071_by, (TileMissileAssembler)tileEntity);
        }
        return null;
    }

    @Override
    public boolean isGaoQing() {
        return Minecraft.func_71410_x().field_71474_y.field_74347_j;
    }

    @Override
    public int getParticleSetting() {
        return Minecraft.func_71410_x().field_71474_y.field_74362_aa;
    }

    @Override
    public void spawnParticle(String name, World world, Vector3 position, double motionX, double motionY, double motionZ, float red, float green, float blue, float scale, double distance) {
        Object fx = null;
        if (name.equals("smoke")) {
            fx = new FXSmoke(world, position, red, green, blue, scale, distance);
        } else if (name.equals("missile_smoke")) {
            fx = new FXSmoke(world, position, red, green, blue, scale, distance).setAge(100);
        } else if (name.equals("portal")) {
            fx = new FXEnderPortalPartical(world, position, red, green, blue, scale, distance);
        } else if (name.equals("antimatter")) {
            fx = new FXAntimatterPartical(world, position, red, green, blue, scale, distance);
        } else if (name.equals("digging")) {
            fx = new EntityDiggingFX(world, position.x, position.y, position.z, motionX, motionY, motionZ, Block.field_71973_m[(int)red], 0, (int)green);
            fx.func_70541_f(blue);
        } else if (name.equals("shockwave")) {
            fx = new FXShockWave(world, position, red, green, blue, scale, distance);
        }
        if (fx != null) {
            fx.field_70159_w = motionX;
            fx.field_70181_x = motionY;
            fx.field_70179_y = motionZ;
            FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)fx);
        }
    }

    @Override
    public void spawnShock(World world, Vector3 startVec, Vector3 targetVec) {
        FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)new FXElectricBolt(world, startVec, targetVec, 0L));
    }

    @Override
    public void spawnShock(World world, Vector3 startVec, Vector3 targetVec, int duration) {
        FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)new FXElectricBoltSpawner(world, startVec, targetVec, 0L, duration));
    }

    @Override
    public IUpdatePlayerListBox getDaoDanShengYin(EntityMissile eDaoDan) {
        return new MissilePlayerHandler(Minecraft.func_71410_x().field_71416_A, eDaoDan, (EntityPlayerSP)Minecraft.func_71410_x().field_71439_g);
    }

    @Override
    public List<Entity> getEntityFXs() {
        if (!this.disableReflectionFX) {
            try {
                EffectRenderer renderer = Minecraft.func_71410_x().field_71452_i;
                List[] fxLayers = (List[])ReflectionHelper.getPrivateValue(EffectRenderer.class, (Object)renderer, (int)2);
                return fxLayers[0];
            }
            catch (Exception e) {
                ICBMCore.LOGGER.severe("Failed to use relfection on entity effects.");
                e.printStackTrace();
                this.disableReflectionFX = true;
            }
        }
        return null;
    }

    public void renderingLivingEvent(RenderLivingEvent.Specials.Pre evt) {
        if (evt.entity instanceof EntityLivingBase && evt.entity.func_70660_b((Potion)PoisonFrostBite.INSTANCE) != null) {
            try {
                ModelBase modelBase = (ModelBase)ReflectionHelper.getPrivateValue(RendererLivingEntity.class, (Object)evt.renderer, (int)2);
                if (modelBase != null) {
                    if (evt.entity.func_82150_aj()) {
                        GL11.glDepthMask((boolean)false);
                    } else {
                        GL11.glDepthMask((boolean)true);
                    }
                    float f1 = evt.entity.field_70173_aa;
                    RenderUtility.setTerrainTexture();
                    GL11.glMatrixMode((int)5890);
                    GL11.glLoadIdentity();
                    float f2 = f1 * 0.01f;
                    float f3 = f1 * 0.01f;
                    GL11.glTranslatef((float)f2, (float)f3, (float)0.0f);
                    GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
                    evt.renderer.func_77042_a(modelBase);
                    GL11.glMatrixMode((int)5888);
                    GL11.glEnable((int)3042);
                    float f4 = 0.5f;
                    GL11.glColor4f((float)f4, (float)f4, (float)f4, (float)1.0f);
                    GL11.glDisable((int)2896);
                    GL11.glBlendFunc((int)1, (int)1);
                    modelBase.func_78088_a((Entity)evt.entity, (float)evt.entity.field_70165_t, (float)evt.entity.field_70163_u, (float)evt.entity.field_70161_v, evt.entity.field_70125_A, evt.entity.field_70177_z, 0.0625f);
                    GL11.glMatrixMode((int)5890);
                    GL11.glLoadIdentity();
                    GL11.glMatrixMode((int)5888);
                    GL11.glEnable((int)2896);
                    GL11.glDisable((int)3042);
                }
            }
            catch (Exception e) {
                ICBMCore.LOGGER.severe("Failed to render entity layer object");
                e.printStackTrace();
            }
        }
    }
}

