/*
 * Decompiled with CFR 0.152.
 */
package icbm.explosion;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.EntityRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import icbm.Settings;
import icbm.TabICBM;
import icbm.core.ICBMCore;
import icbm.core.implement.IChunkLoadHandler;
import icbm.explosion.CommandICBM;
import icbm.explosion.CommonProxy;
import icbm.explosion.entities.EntityBombCart;
import icbm.explosion.entities.EntityExplosion;
import icbm.explosion.entities.EntityExplosive;
import icbm.explosion.entities.EntityGrenade;
import icbm.explosion.entities.EntityLightBeam;
import icbm.explosion.entities.EntityMissile;
import icbm.explosion.explosive.BlockExplosive;
import icbm.explosion.explosive.Explosive;
import icbm.explosion.explosive.ExplosiveRegistry;
import icbm.explosion.explosive.ItemBlockExplosive;
import icbm.explosion.items.ItemBombCart;
import icbm.explosion.items.ItemDefuser;
import icbm.explosion.items.ItemGrenade;
import icbm.explosion.items.ItemLaserDesignator;
import icbm.explosion.items.ItemMissile;
import icbm.explosion.items.ItemRadarGun;
import icbm.explosion.items.ItemRemoteDetonator;
import icbm.explosion.items.ItemRocketLauncher;
import icbm.explosion.machines.BlockICBMMachine;
import icbm.explosion.machines.BlockMissileAssembler;
import icbm.explosion.machines.ItemBlockMachine;
import icbm.explosion.machines.ItemBlockMissileAssembler;
import icbm.explosion.potion.ContagiousPoison;
import icbm.explosion.potion.PoisonContagion;
import icbm.explosion.potion.PoisonFrostBite;
import icbm.explosion.potion.PoisonToxin;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.BlockRailBase;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandManager;
import net.minecraft.command.ServerCommandManager;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import resonant.api.explosion.ExplosionEvent;
import resonant.api.explosion.ExplosiveHelper;
import resonant.lib.config.Config;
import resonant.lib.flag.FlagRegistry;
import resonant.lib.network.PacketHandler;
import resonant.lib.recipe.RecipeUtility;
import resonant.lib.recipe.UniversalRecipe;
import resonant.lib.utility.PotionUtility;
import universalelectricity.api.CompatibilityModule;
import universalelectricity.api.vector.Vector3;

@Mod(modid="ICBM|Explosion", name="ICBM Explosion", version="1.4.2", dependencies="required-after:ICBM;after:ICBM|Sentry")
@NetworkMod(channels={"ICBM|E"}, clientSideRequired=true, serverSideRequired=false, packetHandler=PacketHandler.class)
public class ICBMExplosion {
    public static final String NAME = "ICBM Explosion";
    public static final String ID = "ICBM|Explosion";
    public static final String CHANNEL = "ICBM|E";
    @Mod.Instance(value="ICBM|Explosion")
    public static ICBMExplosion instance;
    @Mod.Metadata(value="ICBM|Explosion")
    public static ModMetadata metadata;
    @SidedProxy(clientSide="icbm.explosion.ClientProxy", serverSide="icbm.explosion.CommonProxy")
    public static CommonProxy proxy;
    public static Item Du;
    public static final int ENTITY_ID_PREFIX = 50;
    public static Block blockExplosive;
    public static Block blockMachine;
    public static Block blockMissileAssembler;
    public static Item itemMissile;
    public static Item itemDefuser;
    public static Item itemRadarGun;
    public static Item itemRemoteDetonator;
    public static Item itemLaserDesignator;
    public static Item itemRocketLauncher;
    public static Item itemGrenade;
    public static Item itemBombCart;
    public static final ContagiousPoison poisonous_potion;
    public static final ContagiousPoison contagios_potion;
    @Config(key="Creepers Drop Sulfur", category="Extras")
    public static boolean CREEPER_DROP_SULFER;
    @Config(key="Creepers Blow up in Fire", category="Extras")
    public static boolean CREEPER_BLOW_UP_IN_FIRE;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        NetworkRegistry.instance().registerGuiHandler((Object)this, (IGuiHandler)proxy);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)proxy);
        FlagRegistry.registerFlag((String)"ban_ICBM");
        blockExplosive = ICBMCore.contentRegistry.createBlock(BlockExplosive.class, ItemBlockExplosive.class);
        blockMachine = ICBMCore.contentRegistry.createBlock(BlockICBMMachine.class, ItemBlockMachine.class);
        blockMissileAssembler = ICBMCore.contentRegistry.createBlock(BlockMissileAssembler.class, ItemBlockMissileAssembler.class);
        itemMissile = ICBMCore.contentRegistry.createItem(ItemMissile.class);
        itemDefuser = ICBMCore.contentRegistry.createItem(ItemDefuser.class);
        itemRadarGun = ICBMCore.contentRegistry.createItem(ItemRadarGun.class);
        itemRemoteDetonator = ICBMCore.contentRegistry.createItem(ItemRemoteDetonator.class);
        itemLaserDesignator = ICBMCore.contentRegistry.createItem(ItemLaserDesignator.class);
        itemRocketLauncher = ICBMCore.contentRegistry.createItem(ItemRocketLauncher.class);
        itemGrenade = ICBMCore.contentRegistry.createItem(ItemGrenade.class);
        itemBombCart = ICBMCore.contentRegistry.createItem(ItemBombCart.class);
        PoisonToxin.INSTANCE = new PoisonToxin(PotionUtility.getNextOptimalPotId(), true, 5149489, "toxin");
        PoisonContagion.INSTANCE = new PoisonContagion(PotionUtility.getNextOptimalPotId(), false, 5149489, "virus");
        PoisonFrostBite.INSTANCE = new PoisonFrostBite(PotionUtility.getNextOptimalPotId(), false, 5149489, "frostBite");
        if (!Loader.isModLoaded((String)"ICBM|Sentry")) {
            TabICBM.itemStack = new ItemStack(blockExplosive);
        }
        BlockDispenser.field_82527_a.func_82595_a((Object)itemGrenade, (Object)new IBehaviorDispenseItem(){

            public ItemStack func_82482_a(IBlockSource blockSource, ItemStack itemStack) {
                World world = blockSource.func_82618_k();
                if (!world.field_72995_K) {
                    int x = blockSource.func_82623_d();
                    int y = blockSource.func_82622_e();
                    int z = blockSource.func_82621_f();
                    EnumFacing enumFacing = EnumFacing.func_82600_a((int)blockSource.func_82620_h());
                    EntityGrenade entity = new EntityGrenade(world, new Vector3((double)x, (double)y, (double)z), itemStack.func_77960_j());
                    entity.setThrowableHeading(enumFacing.func_82601_c(), 0.1f, enumFacing.func_82599_e(), 0.5f, 1.0f);
                    world.func_72838_d((Entity)entity);
                }
                --itemStack.field_77994_a;
                return itemStack;
            }
        });
        BlockDispenser.field_82527_a.func_82595_a((Object)itemBombCart, (Object)new IBehaviorDispenseItem(){
            private final BehaviorDefaultDispenseItem defaultItemDispenseBehavior = new BehaviorDefaultDispenseItem();

            public ItemStack func_82482_a(IBlockSource blockSource, ItemStack itemStack) {
                World world = blockSource.func_82618_k();
                if (!world.field_72995_K) {
                    double var15;
                    int var13;
                    int var12;
                    int x = blockSource.func_82623_d();
                    int y = blockSource.func_82622_e();
                    int z = blockSource.func_82621_f();
                    EnumFacing var3 = EnumFacing.func_82600_a((int)blockSource.func_82620_h());
                    World var4 = blockSource.func_82618_k();
                    double var5 = blockSource.func_82615_a() + (double)((float)var3.func_82601_c() * 1.125f);
                    double var7 = blockSource.func_82617_b();
                    double var9 = blockSource.func_82616_c() + (double)((float)var3.func_82599_e() * 1.125f);
                    int var11 = blockSource.func_82623_d() + var3.func_82601_c();
                    int var14 = var4.func_72798_a(var11, var12 = blockSource.func_82622_e(), var13 = blockSource.func_82621_f() + var3.func_82599_e());
                    if (BlockRailBase.func_72184_d((int)var14)) {
                        var15 = 0.0;
                    } else {
                        if (var14 != 0 || !BlockRailBase.func_72184_d((int)var4.func_72798_a(var11, var12 - 1, var13))) {
                            return this.defaultItemDispenseBehavior.func_82482_a(blockSource, itemStack);
                        }
                        var15 = -1.0;
                    }
                    EntityBombCart var22 = new EntityBombCart(world, var5, var7 + var15, var9, itemStack.func_77960_j());
                    world.func_72838_d((Entity)var22);
                    world.func_72926_e(1000, x, y, z, 0);
                }
                --itemStack.field_77994_a;
                return itemStack;
            }
        });
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)this, (ForgeChunkManager.LoadingCallback)new ForgeChunkManager.LoadingCallback(){

            public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
                for (ForgeChunkManager.Ticket ticket : tickets) {
                    Vector3 position;
                    TileEntity tileEntity;
                    if (ticket.getEntity() instanceof IChunkLoadHandler) {
                        ((IChunkLoadHandler)ticket.getEntity()).chunkLoaderInit(ticket);
                        continue;
                    }
                    if (ticket.getModData() == null || !((tileEntity = (position = new Vector3(ticket.getModData())).getTileEntity((IBlockAccess)ticket.world)) instanceof IChunkLoadHandler)) continue;
                    ((IChunkLoadHandler)tileEntity).chunkLoaderInit(ticket);
                }
            }
        });
        ExplosiveHelper.explosionManager = ExplosiveRegistry.class;
        proxy.preInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        Settings.setModMetadata(ID, NAME, metadata, "ICBM");
        EntityRegistry.registerGlobalEntityID(EntityExplosive.class, (String)"ICBMExplosive", (int)EntityRegistry.findGlobalUniqueEntityId());
        EntityRegistry.registerGlobalEntityID(EntityMissile.class, (String)"ICBMMissile", (int)EntityRegistry.findGlobalUniqueEntityId());
        EntityRegistry.registerGlobalEntityID(EntityExplosion.class, (String)"ICBMProceduralExplosion", (int)EntityRegistry.findGlobalUniqueEntityId());
        EntityRegistry.registerGlobalEntityID(EntityLightBeam.class, (String)"ICBMLightBeam", (int)EntityRegistry.findGlobalUniqueEntityId());
        EntityRegistry.registerGlobalEntityID(EntityGrenade.class, (String)"ICBMGrenade", (int)EntityRegistry.findGlobalUniqueEntityId());
        EntityRegistry.registerGlobalEntityID(EntityBombCart.class, (String)"ICBMChe", (int)EntityRegistry.findGlobalUniqueEntityId());
        EntityRegistry.registerModEntity(EntityExplosive.class, (String)"ICBMExplosive", (int)50, (Object)this, (int)50, (int)5, (boolean)true);
        EntityRegistry.registerModEntity(EntityMissile.class, (String)"ICBMMissile", (int)51, (Object)this, (int)500, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(EntityExplosion.class, (String)"ICBMProceduralExplosion", (int)52, (Object)this, (int)100, (int)5, (boolean)true);
        EntityRegistry.registerModEntity(EntityLightBeam.class, (String)"ICBMLightBeam", (int)54, (Object)this, (int)80, (int)5, (boolean)true);
        EntityRegistry.registerModEntity(EntityGrenade.class, (String)"ICBMGrenade", (int)56, (Object)this, (int)50, (int)5, (boolean)true);
        EntityRegistry.registerModEntity(EntityBombCart.class, (String)"ICBMChe", (int)58, (Object)this, (int)50, (int)4, (boolean)true);
        proxy.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(itemRocketLauncher, new Object[]{"SCR", "SB ", Character.valueOf('R'), itemRadarGun, Character.valueOf('C'), new ItemStack(blockMachine, 1, BlockICBMMachine.MachineData.CruiseLauncher.ordinal() + 6), Character.valueOf('B'), Block.field_72034_aR, Character.valueOf('S'), UniversalRecipe.PRIMARY_METAL.get()}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(itemRadarGun), new Object[]{"@#!", " $!", "  !", Character.valueOf('@'), Block.field_71946_M, Character.valueOf('!'), UniversalRecipe.PRIMARY_METAL.get(), Character.valueOf('#'), UniversalRecipe.CIRCUIT_T1.get(), Character.valueOf('$'), Block.field_72034_aR}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(itemRemoteDetonator), new Object[]{"?@@", "@#$", "@@@", Character.valueOf('@'), UniversalRecipe.PRIMARY_METAL.get(), Character.valueOf('?'), Item.field_77767_aC, Character.valueOf('#'), UniversalRecipe.CIRCUIT_T2.get(), Character.valueOf('$'), Block.field_72034_aR}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(itemLaserDesignator), new Object[]{"!  ", " ? ", "  @", Character.valueOf('@'), itemRemoteDetonator, Character.valueOf('?'), UniversalRecipe.CIRCUIT_T3.get(), Character.valueOf('!'), itemRadarGun}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(itemDefuser), new Object[]{"I  ", " W ", "  C", Character.valueOf('C'), UniversalRecipe.CIRCUIT_T2.get(), Character.valueOf('W'), UniversalRecipe.WRENCH.get(), Character.valueOf('I'), UniversalRecipe.WIRE.get()}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(blockMachine, 1, 0), new Object[]{"! !", "!C!", "!!!", Character.valueOf('!'), UniversalRecipe.SECONDARY_METAL.get(), Character.valueOf('C'), UniversalRecipe.CIRCUIT_T1.get()}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(blockMachine, 1, 1), new Object[]{"! !", "!C!", "!@!", Character.valueOf('@'), new ItemStack(blockMachine, 1, 0), Character.valueOf('!'), UniversalRecipe.PRIMARY_METAL.get(), Character.valueOf('C'), UniversalRecipe.CIRCUIT_T2.get()}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(blockMachine, 1, 2), new Object[]{"! !", "!C!", "!@!", Character.valueOf('@'), new ItemStack(blockMachine, 1, 1), Character.valueOf('!'), UniversalRecipe.PRIMARY_PLATE.get(), Character.valueOf('C'), UniversalRecipe.CIRCUIT_T3.get()}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(blockMachine, 1, 3), new Object[]{"!!!", "!#!", "!?!", Character.valueOf('#'), UniversalRecipe.CIRCUIT_T1.get(), Character.valueOf('!'), Block.field_71946_M, Character.valueOf('?'), UniversalRecipe.WIRE.get()}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(blockMachine, 1, 4), new Object[]{"!$!", "!#!", "!?!", Character.valueOf('#'), UniversalRecipe.CIRCUIT_T2.get(), Character.valueOf('!'), UniversalRecipe.PRIMARY_METAL.get(), Character.valueOf('?'), UniversalRecipe.WIRE.get(), Character.valueOf('$'), new ItemStack(blockMachine, 1, 3)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(blockMachine, 1, 5), new Object[]{"!$!", "!#!", "!?!", Character.valueOf('#'), UniversalRecipe.CIRCUIT_T3.get(), Character.valueOf('!'), Item.field_77717_p, Character.valueOf('?'), UniversalRecipe.WIRE.get(), Character.valueOf('$'), new ItemStack(blockMachine, 1, 4)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(blockMachine, 1, 6), new Object[]{"! !", "!!!", "! !", Character.valueOf('!'), UniversalRecipe.SECONDARY_METAL.get()}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(blockMachine, 1, 7), new Object[]{"! !", "!@!", "! !", Character.valueOf('!'), UniversalRecipe.PRIMARY_METAL.get(), Character.valueOf('@'), new ItemStack(blockMachine, 1, 6)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(blockMachine, 1, 8), new Object[]{"! !", "!@!", "! !", Character.valueOf('!'), UniversalRecipe.PRIMARY_PLATE.get(), Character.valueOf('@'), new ItemStack(blockMachine, 1, 7)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(blockMachine, 1, 9), new Object[]{"?@?", " ! ", "!#!", Character.valueOf('@'), CompatibilityModule.getItemWithCharge((ItemStack)new ItemStack(itemRadarGun), (long)0L), Character.valueOf('!'), UniversalRecipe.PRIMARY_PLATE.get(), Character.valueOf('#'), UniversalRecipe.CIRCUIT_T1.get(), Character.valueOf('?'), Item.field_77717_p}));
        RecipeUtility.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(blockMachine, 1, 10), new Object[]{"?W?", "@!@", "?#?", Character.valueOf('?'), UniversalRecipe.PRIMARY_PLATE.get(), Character.valueOf('!'), UniversalRecipe.CIRCUIT_T3.get(), Character.valueOf('@'), UniversalRecipe.BATTERY_BOX.get(), Character.valueOf('#'), UniversalRecipe.MOTOR.get(), Character.valueOf('W'), UniversalRecipe.WIRE.get()}), (String)"EMP Tower", (Configuration)Settings.CONFIGURATION, (boolean)true);
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(blockMachine, 1, 11), new Object[]{"?! ", "@@@", Character.valueOf('@'), UniversalRecipe.PRIMARY_PLATE.get(), Character.valueOf('!'), new ItemStack(blockMachine, 1, 2), Character.valueOf('?'), new ItemStack(blockMachine, 1, 8)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(blockMachine, 1, 12), new Object[]{"R R", "SCS", "SSS", Character.valueOf('C'), UniversalRecipe.CIRCUIT_T2.get(), Character.valueOf('S'), UniversalRecipe.PRIMARY_PLATE.get(), Character.valueOf('R'), itemRemoteDetonator}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(itemMissile, 1, Explosive.missileModule.getID()), new Object[]{" @ ", "@#@", "@?@", Character.valueOf('@'), UniversalRecipe.PRIMARY_METAL.get(), Character.valueOf('?'), Item.field_77709_i, Character.valueOf('#'), UniversalRecipe.CIRCUIT_T1.get()}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(itemMissile, 1, Explosive.homing.getID()), new Object[]{" B ", " C ", "BMB", Character.valueOf('M'), new ItemStack(itemMissile, 1, Explosive.missileModule.getID()), Character.valueOf('C'), UniversalRecipe.CIRCUIT_T1.get(), Character.valueOf('B'), UniversalRecipe.SECONDARY_METAL.get()}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(itemMissile, 1, Explosive.antiBallistic.getID()), new Object[]{"!", "?", "@", Character.valueOf('@'), new ItemStack(itemMissile, 1, Explosive.missileModule.getID()), Character.valueOf('?'), new ItemStack(blockExplosive, 1, 0), Character.valueOf('!'), UniversalRecipe.CIRCUIT_T1.get()}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(itemMissile, 1, Explosive.cluster.getID()), new Object[]{" ! ", " ? ", "!@!", Character.valueOf('@'), new ItemStack(itemMissile, 1, Explosive.missileModule.getID()), Character.valueOf('?'), Explosive.fragmentation.getItemStack(), Character.valueOf('!'), new ItemStack(itemMissile, 1, 0)}));
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(itemMissile, 1, Explosive.nuclearCluster.getID()), new Object[]{" N ", "NCN", Character.valueOf('C'), new ItemStack(itemMissile, 1, Explosive.cluster.getID()), Character.valueOf('N'), Explosive.nuclear.getItemStack()}));
        if (!Loader.isModLoaded((String)"ResonantInduction|Atomic")) {
            OreDictionary.registerOre((String)"strangeMatter", (ItemStack)new ItemStack(397, 1, 1));
        }
        for (Explosive explosive : ExplosiveRegistry.getExplosives()) {
            explosive.init();
            RecipeUtility.addRecipe((IRecipe)new ShapelessOreRecipe(new ItemStack(itemMissile, 1, explosive.getID()), new Object[]{new ItemStack(itemMissile, 1, Explosive.missileModule.getID()), new ItemStack(blockExplosive, 1, explosive.getID())}), (String)(explosive.getUnlocalizedName() + " Missile"), (Configuration)Settings.CONFIGURATION, (boolean)true);
            if (explosive.getTier() < 2) {
                RecipeUtility.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(itemGrenade, 1, explosive.getID()), new Object[]{"?", "@", Character.valueOf('@'), new ItemStack(blockExplosive, 1, explosive.getID()), Character.valueOf('?'), Item.field_77683_K}), (String)(explosive.getUnlocalizedName() + " Grenade"), (Configuration)Settings.CONFIGURATION, (boolean)true);
            }
            if (explosive.getTier() >= 3) continue;
            RecipeUtility.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(itemBombCart, 1, explosive.getID()), new Object[]{"?", "@", Character.valueOf('?'), new ItemStack(blockExplosive, 1, explosive.getID()), Character.valueOf('@'), Item.field_77773_az}), (String)(explosive.getUnlocalizedName() + " Minecart"), (Configuration)Settings.CONFIGURATION, (boolean)true);
        }
    }

    @ForgeSubscribe
    public void enteringChunk(EntityEvent.EnteringChunk evt) {
        if (evt.entity instanceof EntityMissile) {
            ((EntityMissile)evt.entity).updateLoadChunk(evt.newChunkX, evt.newChunkZ);
        }
    }

    @ForgeSubscribe
    public void creeperDeathEvent(LivingDeathEvent evt) {
        if (evt.entityLiving instanceof EntityCreeper && CREEPER_BLOW_UP_IN_FIRE && (evt.source == DamageSource.field_76370_b || evt.source == DamageSource.field_76372_a)) {
            evt.setCanceled(true);
            boolean flag = evt.entityLiving.field_70170_p.func_82736_K().func_82766_b("mobGriefing");
            if (((EntityCreeper)evt.entityLiving).func_70830_n()) {
                evt.entityLiving.field_70170_p.func_72876_a((Entity)evt.entityLiving, evt.entityLiving.field_70165_t, evt.entityLiving.field_70163_u, evt.entityLiving.field_70161_v, 6.0f, flag);
            } else {
                evt.entityLiving.field_70170_p.func_72876_a((Entity)evt.entityLiving, evt.entityLiving.field_70165_t, evt.entityLiving.field_70163_u, evt.entityLiving.field_70161_v, 3.0f, flag);
            }
        }
    }

    @ForgeSubscribe
    public void creeperDropEvent(LivingDropsEvent evt) {
        if (evt.entityLiving instanceof EntityCreeper && CREEPER_DROP_SULFER) {
            evt.entityLiving.func_70025_b(ICBMCore.itemSulfurDust.field_77779_bT, 1 + evt.entityLiving.field_70170_p.field_73012_v.nextInt(6));
        }
    }

    @ForgeSubscribe
    public void preDetonationEvent(ExplosionEvent.ExplosivePreDetonationEvent evt) {
        if (FlagRegistry.getModFlag() != null && evt.explosion instanceof Explosive && ((Explosive)evt.explosion).isBannedInRegion(evt.world, evt.x, evt.y, evt.z)) {
            ICBMCore.LOGGER.fine("ICBM prevented explosive:" + evt.x + ", " + evt.y + "," + evt.z);
            evt.setCanceled(true);
        }
    }

    @ForgeSubscribe
    public void preConstructionEvent(ExplosionEvent.ExplosionConstructionEvent evt) {
        if (FlagRegistry.getModFlag() != null && evt.iExplosion instanceof Explosive && ((Explosive)evt.iExplosion).isBannedInRegion(evt.world, evt.x, evt.y, evt.z)) {
            ICBMCore.LOGGER.fine("ICBM prevented explosive:" + evt.x + ", " + evt.y + "," + evt.z);
            evt.setCanceled(true);
        }
    }

    @ForgeSubscribe
    public void preExplosionEvent(ExplosionEvent.PreExplosionEvent evt) {
        if (FlagRegistry.getModFlag() != null && evt.iExplosion instanceof Explosive && ((Explosive)evt.iExplosion).isBannedInRegion(evt.world, evt.x, evt.y, evt.z)) {
            ICBMCore.LOGGER.fine("ICBM prevented explosive:" + evt.x + ", " + evt.y + "," + evt.z);
            evt.setCanceled(true);
        }
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        ICommandManager commandManager = FMLCommonHandler.instance().getMinecraftServerInstance().func_71187_D();
        ServerCommandManager serverCommandManager = (ServerCommandManager)commandManager;
        serverCommandManager.func_71560_a((ICommand)new CommandICBM());
    }

    static {
        poisonous_potion = new ContagiousPoison("Chemical", 1, false);
        contagios_potion = new ContagiousPoison("Contagious", 1, true);
        CREEPER_DROP_SULFER = true;
        CREEPER_BLOW_UP_IN_FIRE = true;
    }
}

