/*
 * Decompiled with CFR 0.152.
 */
package icbm.explosion.ex;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import icbm.explosion.entities.EntityMissile;
import icbm.explosion.explosive.Explosive;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.AdvancedModelLoader;
import net.minecraftforge.client.model.IModelCustom;
import net.minecraftforge.client.model.ModelFormatException;

public abstract class Ex
extends Explosive {
    @SideOnly(value=Side.CLIENT)
    private ResourceLocation resourceLocation;
    @SideOnly(value=Side.CLIENT)
    private IModelCustom model;
    protected String modelName;

    public Ex(String name, int tier) {
        super(name, tier);
    }

    public void launch(EntityMissile missileObj) {
    }

    public void update(EntityMissile missileObj) {
    }

    public boolean onInteract(EntityMissile missileObj, EntityPlayer entityPlayer) {
        return false;
    }

    public boolean isCruise() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getMissileResource() {
        if (this.resourceLocation == null) {
            this.resourceLocation = new ResourceLocation("icbm", "textures/models/missile_" + this.getUnlocalizedName() + ".png");
        }
        return this.resourceLocation;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IModelCustom getMissileModel() {
        try {
            if (this.model == null) {
                this.model = AdvancedModelLoader.loadModel((String)("/assets/icbm/models/" + this.modelName));
            }
        }
        catch (ModelFormatException e) {
            System.out.println("Crash  ModelName: " + this.modelName);
            e.printStackTrace();
        }
        return this.model;
    }
}

