/*
 * Decompiled with CFR 0.152.
 */
package icbm.explosion.ex.missiles;

import icbm.explosion.entities.EntityMissile;
import icbm.explosion.ex.missiles.Missile;
import icbm.explosion.explosive.blast.BlastRepulsive;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import resonant.api.ai.ITarget;
import universalelectricity.api.vector.Vector3;

public class MissileAnti
extends Missile {
    public static final int ABMRange = 30;

    public MissileAnti() {
        super("antiBallistic", 2);
        this.hasBlock = false;
        this.modelName = "missile_antimatter.tcn";
    }

    @Override
    public void update(EntityMissile missileObj) {
        if (missileObj.lockedTarget != null) {
            Vector3 target = new Vector3(missileObj.lockedTarget);
            if (missileObj.lockedTarget.field_70128_L) {
                missileObj.explode();
                return;
            }
            if (missileObj.lockedTarget instanceof ITarget && ((ITarget)missileObj.lockedTarget).getType() == ITarget.TargetType.MISSILE && ((ITarget)missileObj.lockedTarget).canBeTargeted((Object)this)) {
                target = ((ITarget)missileObj.lockedTarget).getPredictedPosition(4);
            }
            missileObj.field_70159_w = (target.x - missileObj.field_70165_t) * (double)0.3f;
            missileObj.field_70181_x = (target.y - missileObj.field_70163_u) * (double)0.3f;
            missileObj.field_70179_y = (target.z - missileObj.field_70161_v) * (double)0.3f;
            return;
        }
        AxisAlignedBB bounds = AxisAlignedBB.func_72330_a((double)(missileObj.field_70165_t - 30.0), (double)(missileObj.field_70163_u - 30.0), (double)(missileObj.field_70161_v - 30.0), (double)(missileObj.field_70165_t + 30.0), (double)(missileObj.field_70163_u + 30.0), (double)(missileObj.field_70161_v + 30.0));
        Entity nearestEntity = missileObj.field_70170_p.func_72857_a(ITarget.class, bounds, (Entity)missileObj);
        if (nearestEntity instanceof ITarget && ((ITarget)nearestEntity).getType() == ITarget.TargetType.MISSILE) {
            if (((ITarget)nearestEntity).canBeTargeted((Object)this)) {
                missileObj.lockedTarget = nearestEntity;
                missileObj.didTargetLockBefore = true;
                missileObj.field_70170_p.func_72956_a((Entity)missileObj, "icbm:targetlocked", 5.0f, 0.9f);
            }
        } else {
            missileObj.field_70159_w = missileObj.deltaPathX / (double)missileObj.missileFlightTime;
            missileObj.field_70179_y = missileObj.deltaPathZ / (double)missileObj.missileFlightTime;
            if (missileObj.didTargetLockBefore) {
                missileObj.explode();
            }
        }
    }

    @Override
    public boolean isCruise() {
        return true;
    }

    @Override
    public void doCreateExplosion(World world, double x, double y, double z, Entity entity) {
        new BlastRepulsive(world, entity, x, y, z, 6.0f).setDestroyItems().explode();
    }
}

