/*
 * Decompiled with CFR 0.152.
 */
package icbm.explosion.ex.missiles;

import icbm.explosion.entities.EntityMissile;
import icbm.explosion.ex.missiles.Missile;
import icbm.explosion.explosive.blast.BlastRepulsive;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import resonant.api.items.IItemTracker;
import universalelectricity.api.vector.Vector2;
import universalelectricity.api.vector.Vector3;

public class MissileHoming
extends Missile {
    public MissileHoming() {
        super("homing", 1);
        this.hasBlock = false;
        this.modelName = "missile_homing.tcn";
    }

    @Override
    public void launch(EntityMissile missileObj) {
        WorldServer worldServer;
        Entity trackingEntity;
        if (!missileObj.field_70170_p.field_72995_K && (trackingEntity = (worldServer = (WorldServer)missileObj.field_70170_p).func_73045_a(missileObj.trackingVar)) != null) {
            if (trackingEntity == missileObj) {
                missileObj.setExplode();
            }
            missileObj.targetVector = new Vector3(trackingEntity);
        }
    }

    @Override
    public void update(EntityMissile missileObj) {
        WorldServer worldServer;
        Entity trackingEntity;
        if ((float)missileObj.feiXingTick > missileObj.missileFlightTime / 2.0f && missileObj.missileType == EntityMissile.MissileType.MISSILE && (trackingEntity = (worldServer = (WorldServer)missileObj.field_70170_p).func_73045_a(missileObj.trackingVar)) != null) {
            if (trackingEntity.equals((Object)missileObj)) {
                missileObj.setExplode();
            }
            missileObj.targetVector = new Vector3(trackingEntity);
            missileObj.missileType = EntityMissile.MissileType.CruiseMissile;
            missileObj.deltaPathX = missileObj.targetVector.x - missileObj.field_70165_t;
            missileObj.deltaPathY = missileObj.targetVector.y - missileObj.field_70163_u;
            missileObj.deltaPathZ = missileObj.targetVector.z - missileObj.field_70161_v;
            missileObj.flatDistance = Vector2.distance((Vector2)missileObj.startPos.toVector2(), (Vector2)missileObj.targetVector.toVector2());
            missileObj.maxHeight = 150 + (int)(missileObj.flatDistance * 1.8);
            missileObj.missileFlightTime = (float)Math.max(100.0, 2.4 * missileObj.flatDistance);
            missileObj.acceleration = (float)missileObj.maxHeight * 2.0f / (missileObj.missileFlightTime * missileObj.missileFlightTime);
            if (missileObj.xiaoDanMotion.equals((Object)new Vector3()) || missileObj.xiaoDanMotion == null) {
                float suDu = 0.3f;
                missileObj.xiaoDanMotion = new Vector3();
                missileObj.xiaoDanMotion.x = missileObj.deltaPathX / (double)(missileObj.missileFlightTime * suDu);
                missileObj.xiaoDanMotion.y = missileObj.deltaPathY / (double)(missileObj.missileFlightTime * suDu);
                missileObj.xiaoDanMotion.z = missileObj.deltaPathZ / (double)(missileObj.missileFlightTime * suDu);
            }
        }
    }

    @Override
    public boolean onInteract(EntityMissile missileObj, EntityPlayer entityPlayer) {
        Entity trackingEntity;
        if (!missileObj.field_70170_p.field_72995_K && missileObj.feiXingTick <= 0 && entityPlayer.func_71045_bC() != null && entityPlayer.func_71045_bC().func_77973_b() instanceof IItemTracker && (trackingEntity = ((IItemTracker)entityPlayer.func_71045_bC().func_77973_b()).getTrackingEntity(missileObj.field_70170_p, entityPlayer.func_71045_bC())) != null && missileObj.trackingVar != trackingEntity.field_70157_k) {
            missileObj.trackingVar = trackingEntity.field_70157_k;
            entityPlayer.func_71035_c("Missile target locked to: " + trackingEntity.func_70023_ak());
            if (missileObj.getLauncher() != null && missileObj.getLauncher().getController() != null) {
                Vector3 newTarget = new Vector3(trackingEntity);
                newTarget.y = 0.0;
                missileObj.getLauncher().getController().setTarget(newTarget);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isCruise() {
        return false;
    }

    @Override
    public void doCreateExplosion(World world, double x, double y, double z, Entity entity) {
        new BlastRepulsive(world, entity, x, y, z, 4.0f).setDestroyItems().explode();
    }
}

