/*
 * Decompiled with CFR 0.152.
 */
package icbm.explosion.explosive;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import icbm.ModelICBM;
import icbm.Settings;
import icbm.explosion.ICBMExplosion;
import icbm.explosion.ex.Ex;
import icbm.explosion.ex.ExAntiGravitational;
import icbm.explosion.ex.ExAntimatter;
import icbm.explosion.ex.ExBreaching;
import icbm.explosion.ex.ExChemical;
import icbm.explosion.ex.ExCondensed;
import icbm.explosion.ex.ExDebilitation;
import icbm.explosion.ex.ExEMP;
import icbm.explosion.ex.ExEnder;
import icbm.explosion.ex.ExEndothermic;
import icbm.explosion.ex.ExExothermic;
import icbm.explosion.ex.ExIncendiary;
import icbm.explosion.ex.ExNuclear;
import icbm.explosion.ex.ExRedMatter;
import icbm.explosion.ex.ExRejuvenation;
import icbm.explosion.ex.ExRepulsive;
import icbm.explosion.ex.ExSMine;
import icbm.explosion.ex.ExShrapnel;
import icbm.explosion.ex.ExSonic;
import icbm.explosion.ex.missiles.MissileAnti;
import icbm.explosion.ex.missiles.MissileCluster;
import icbm.explosion.ex.missiles.MissileHoming;
import icbm.explosion.ex.missiles.MissileModule;
import icbm.explosion.ex.missiles.MissileNuclearCluster;
import icbm.explosion.explosive.ExplosiveRegistry;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModelCustom;
import resonant.api.explosion.IExplosive;
import resonant.lib.flag.FlagRegistry;
import resonant.lib.utility.LanguageUtility;
import universalelectricity.api.vector.Vector3;

public abstract class Explosive
implements IExplosive {
    public static final Explosive condensed;
    public static final Explosive shrapnel;
    public static final Explosive incendiary;
    public static final Explosive debilitation;
    public static final Explosive chemical;
    public static final Explosive anvil;
    public static final Explosive replsive;
    public static final Explosive attractive;
    public static final Explosive fragmentation;
    public static final Explosive contagious;
    public static final Explosive sonic;
    public static final Explosive breaching;
    public static final Explosive rejuvenation;
    public static final Explosive thermobaric;
    public static final Explosive sMine;
    public static final Explosive nuclear;
    public static final Explosive emp;
    public static final Explosive exothermic;
    public static final Explosive endothermic;
    public static final Explosive antiGrav;
    public static final Explosive ender;
    public static final Explosive hypersonic;
    public static final Explosive antimatter;
    public static final Explosive redMatter;
    public static final Ex missileModule;
    public static final Ex homing;
    public static final Ex antiBallistic;
    public static final Ex cluster;
    public static final Ex nuclearCluster;
    public static boolean registered;
    private String nameID;
    private int tier;
    private int fuseTime;
    public final String flagName;
    protected boolean isDisabled;
    protected boolean isMobile = false;
    protected boolean hasBlock;
    protected boolean hasGrenade;
    protected boolean hasMinecart;
    protected boolean hasMissile;

    protected Explosive(String name, int tier) {
        this.nameID = name;
        this.tier = tier;
        this.fuseTime = 100;
        this.hasBlock = true;
        this.hasMissile = true;
        this.hasGrenade = this.tier <= 1;
        this.hasMinecart = this.tier <= 2;
        this.flagName = FlagRegistry.registerFlag((String)("ban_" + this.nameID));
        this.isDisabled = Settings.CONFIGURATION.get("Disable_Explosives", "Disable " + this.nameID, false).getBoolean(false);
    }

    public final int getID() {
        return ExplosiveRegistry.getID(this.getUnlocalizedName());
    }

    public String getUnlocalizedName() {
        return this.nameID;
    }

    public String getExplosiveName() {
        return LanguageUtility.getLocal((String)("icbm.explosive." + this.nameID + ".name"));
    }

    public String getGrenadeName() {
        return LanguageUtility.getLocal((String)("icbm.grenade." + this.nameID + ".name"));
    }

    public String getMissileName() {
        return LanguageUtility.getLocal((String)("icbm.missile." + this.nameID + ".name"));
    }

    public String getMinecartName() {
        return LanguageUtility.getLocal((String)("icbm.minecart." + this.nameID + ".name"));
    }

    public int getTier() {
        return this.tier;
    }

    public void setTier(int tier) {
        this.tier = tier;
    }

    public Explosive setYinXin(int fuse) {
        this.fuseTime = fuse;
        return this;
    }

    public int getYinXin() {
        return this.fuseTime;
    }

    public void yinZhaQian(World world, Entity entity) {
        world.func_72956_a(entity, "random.fuse", 1.0f, 1.0f);
    }

    public void onYinZha(World world, Vector3 position, int fuseTicks) {
        world.func_72869_a("smoke", position.x, position.y + 0.5, position.z, 0.0, 0.0, 0.0);
    }

    public int onBeiZha() {
        return (int)((double)(this.fuseTime / 2) + Math.random() * (double)this.fuseTime / 4.0);
    }

    @SideOnly(value=Side.CLIENT)
    public ModelICBM getBlockModel() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getBlockResource() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getIcon() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public IModelCustom getMissileModel() {
        return null;
    }

    public boolean hasGrenadeForm() {
        return this.hasGrenade;
    }

    public boolean hasMissileForm() {
        return this.hasMissile;
    }

    public boolean hasMinecartForm() {
        return this.hasMinecart;
    }

    public boolean hasBlockForm() {
        return this.hasBlock;
    }

    public void init() {
    }

    public ItemStack getItemStack() {
        return this.getItemStack(1);
    }

    public ItemStack getItemStack(int amount) {
        return new ItemStack(ICBMExplosion.blockExplosive, amount, this.getID());
    }

    public boolean onBlockActivated(World world, int x, int y, int z, EntityPlayer entityPlayer, int par6, float par7, float par8, float par9) {
        return false;
    }

    public void createExplosion(World world, double x, double y, double z, Entity entity) {
        if (!this.isDisabled) {
            this.doCreateExplosion(world, x, y, z, entity);
        }
    }

    public abstract void doCreateExplosion(World var1, double var2, double var4, double var6, Entity var8);

    public boolean isBannedInRegion(World world, double x, double y, double z) {
        boolean flag_all = FlagRegistry.getModFlag().getFlagWorld(world).containsValue("ban_ICBM", "true", new Vector3(x, y, z));
        boolean flag_missile = FlagRegistry.getModFlag().getFlagWorld(world).containsValue(this.flagName, "true", new Vector3(x, y, z));
        return flag_all || flag_missile;
    }

    static {
        registered = false;
        Settings.CONFIGURATION.load();
        condensed = ExplosiveRegistry.register(new ExCondensed("condensed", 1));
        shrapnel = ExplosiveRegistry.register(new ExShrapnel("shrapnel", 1));
        incendiary = ExplosiveRegistry.register(new ExIncendiary("incendiary", 1));
        debilitation = ExplosiveRegistry.register(new ExDebilitation("debilitation", 1));
        chemical = ExplosiveRegistry.register(new ExChemical("chemical", 1));
        anvil = ExplosiveRegistry.register(new ExShrapnel("anvil", 1));
        replsive = ExplosiveRegistry.register(new ExRepulsive("repulsive", 1));
        attractive = ExplosiveRegistry.register(new ExRepulsive("attractive", 1));
        fragmentation = ExplosiveRegistry.register(new ExShrapnel("fragmentation", 2));
        contagious = ExplosiveRegistry.register(new ExChemical("contagious", 2));
        sonic = ExplosiveRegistry.register(new ExSonic("sonic", 2));
        breaching = ExplosiveRegistry.register(new ExBreaching());
        rejuvenation = ExplosiveRegistry.register(new ExRejuvenation());
        thermobaric = ExplosiveRegistry.register(new ExNuclear("thermobaric", 2));
        sMine = ExplosiveRegistry.register(new ExSMine("sMine", 2));
        nuclear = ExplosiveRegistry.register(new ExNuclear("nuclear", 3));
        emp = ExplosiveRegistry.register(new ExEMP());
        exothermic = ExplosiveRegistry.register(new ExExothermic());
        endothermic = ExplosiveRegistry.register(new ExEndothermic());
        antiGrav = ExplosiveRegistry.register(new ExAntiGravitational());
        ender = ExplosiveRegistry.register(new ExEnder());
        hypersonic = ExplosiveRegistry.register(new ExSonic("hypersonic", 3));
        antimatter = ExplosiveRegistry.register(new ExAntimatter());
        redMatter = ExplosiveRegistry.register(new ExRedMatter());
        missileModule = (Ex)ExplosiveRegistry.register(new MissileModule());
        homing = (Ex)ExplosiveRegistry.register(new MissileHoming());
        antiBallistic = (Ex)ExplosiveRegistry.register(new MissileAnti());
        cluster = (Ex)ExplosiveRegistry.register(new MissileCluster("cluster", 2));
        nuclearCluster = (Ex)ExplosiveRegistry.register(new MissileNuclearCluster());
        Settings.CONFIGURATION.save();
        registered = true;
    }
}

