/*
 * Decompiled with CFR 0.152.
 */
package icbm.explosion.explosive.blast;

import calclavia.api.mffs.IForceFieldBlock;
import icbm.core.entity.EntityFlyingBlock;
import icbm.explosion.explosive.blast.Blast;
import icbm.explosion.explosive.thread.ThreadSmallExplosion;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import universalelectricity.api.vector.IVector3;
import universalelectricity.api.vector.Vector3;

public class BlastAntiGravitational
extends Blast {
    protected ThreadSmallExplosion thread;
    protected Set<EntityFlyingBlock> flyingBlocks = new HashSet<EntityFlyingBlock>();

    public BlastAntiGravitational(World world, Entity entity, double x, double y, double z, float size) {
        super(world, entity, x, y, z, size);
    }

    @Override
    public void doPreExplode() {
        if (!this.world().field_72995_K) {
            this.thread = new ThreadSmallExplosion(this.position, (int)this.getRadius(), this.field_77283_e);
            this.thread.start();
        }
        this.world().func_72908_a(this.position.x, this.position.y, this.position.z, "icbm:antigravity", 6.0f, (1.0f + (this.world().field_73012_v.nextFloat() - this.world().field_73012_v.nextFloat()) * 0.2f) * 0.7f);
    }

    @Override
    public void doExplode() {
        int r = this.callCount;
        if (!this.world().field_72995_K && this.thread.isComplete) {
            int blocksToTake = 20;
            for (Vector3 targetPosition : this.thread.results) {
                Block block;
                double distance = Vector3.distance((Vector3)targetPosition, (IVector3)this.position);
                if (distance > (double)r || distance < (double)(r - 2) || blocksToTake <= 0 || (block = Block.field_71973_m[this.world().func_72798_a(targetPosition.intX(), targetPosition.intY(), targetPosition.intZ())]) == null || block.func_71934_m(this.world(), targetPosition.intX(), targetPosition.intY(), targetPosition.intZ()) < 0.0f || block instanceof IForceFieldBlock) continue;
                int metadata = this.world().func_72805_g(targetPosition.intX(), targetPosition.intY(), targetPosition.intZ());
                if (!(distance < (double)(r - 1)) && this.world().field_73012_v.nextInt(3) <= 0) continue;
                this.world().func_94571_i(targetPosition.intX(), targetPosition.intY(), targetPosition.intZ());
                targetPosition.translate(0.5);
                if ((double)this.world().field_73012_v.nextFloat() < 0.3 * (double)(this.getRadius() - (float)r)) {
                    EntityFlyingBlock entity = new EntityFlyingBlock(this.world(), targetPosition, block.field_71990_ca, metadata, 0.0f);
                    this.world().func_72838_d((Entity)entity);
                    this.flyingBlocks.add(entity);
                    entity.yawChange = 50.0f * this.world().field_73012_v.nextFloat();
                    entity.pitchChange = 100.0f * this.world().field_73012_v.nextFloat();
                    entity.field_70181_x += Math.max(0.15 * (double)this.world().field_73012_v.nextFloat(), 0.1);
                }
                --blocksToTake;
            }
        }
        int radius = (int)this.getRadius();
        AxisAlignedBB bounds = AxisAlignedBB.func_72330_a((double)(this.position.x - (double)radius), (double)(this.position.y - (double)radius), (double)(this.position.z - (double)radius), (double)(this.position.x + (double)radius), (double)100.0, (double)(this.position.z + (double)radius));
        List allEntities = this.world().func_72872_a(Entity.class, bounds);
        for (Entity entity : allEntities) {
            if (entity instanceof EntityFlyingBlock || !(entity.field_70163_u < 100.0 + this.position.y) || !(entity.field_70181_x < 0.4)) continue;
            entity.field_70181_x += 0.15;
        }
        if (this.callCount > 2400) {
            this.controller.endExplosion();
        }
    }

    @Override
    public int proceduralInterval() {
        return 1;
    }

    @Override
    public float getRadius() {
        return 15.0f;
    }

    @Override
    public long getEnergy() {
        return 10000L;
    }
}

