/*
 * Decompiled with CFR 0.152.
 */
package icbm.explosion.explosive.blast;

import icbm.explosion.entities.EntityExplosion;
import icbm.explosion.explosive.blast.Blast;
import icbm.explosion.explosive.blast.BlastRedmatter;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import universalelectricity.api.vector.IVector3;
import universalelectricity.api.vector.Vector3;

public class BlastAntimatter
extends Blast {
    private boolean destroyBedrock;

    public BlastAntimatter(World world, Entity entity, double x, double y, double z, float size) {
        super(world, entity, x, y, z, size);
    }

    public BlastAntimatter(World world, Entity entity, double x, double y, double z, float size, boolean destroyBedrock) {
        this(world, entity, x, y, z, size);
        this.destroyBedrock = destroyBedrock;
    }

    @Override
    public void doPreExplode() {
        super.doPreExplode();
        this.world().func_72908_a(this.position.x, this.position.y, this.position.z, "icbm:antimatter", 7.0f, (float)((double)this.world().field_73012_v.nextFloat() * 0.1 + (double)0.9f));
        this.doDamageEntities(this.getRadius() * 2.0f, 2.1474836E9f);
    }

    @Override
    public void doExplode() {
        if (!this.world().field_72995_K) {
            int x = (int)(-this.getRadius());
            while ((float)x < this.getRadius()) {
                int y = (int)(-this.getRadius());
                while ((float)y < this.getRadius()) {
                    int z = (int)(-this.getRadius());
                    while ((float)z < this.getRadius()) {
                        int blockID;
                        Block block;
                        Vector3 targetPosition = this.position.clone().translate((IVector3)new Vector3((double)x, (double)y, (double)z));
                        double dist = this.position.distance((IVector3)targetPosition);
                        if (dist < (double)this.getRadius() && (block = Block.field_71973_m[blockID = targetPosition.getBlockID((IBlockAccess)this.world())]) != null && !block.isAirBlock(this.world(), x, y, x) && (this.destroyBedrock || !(block.func_71934_m(this.world(), x, y, x) < 0.0f)) && (dist < (double)(this.getRadius() - 1.0f) || (double)this.world().field_73012_v.nextFloat() > 0.7)) {
                            targetPosition.setBlock(this.world(), 0);
                        }
                        ++z;
                    }
                    ++y;
                }
                ++x;
            }
        }
    }

    @Override
    public void doPostExplode() {
        this.doDamageEntities(this.getRadius() * 2.0f, 2.1474836E9f);
    }

    @Override
    protected boolean onDamageEntity(Entity entity) {
        if (entity instanceof EntityExplosion && ((EntityExplosion)entity).blast instanceof BlastRedmatter) {
            entity.func_70106_y();
            return true;
        }
        return false;
    }

    @Override
    public long getEnergy() {
        return 30000000L;
    }
}

