/*
 * Decompiled with CFR 0.152.
 */
package icbm.explosion.explosive.blast;

import icbm.core.entity.EntityFlyingBlock;
import icbm.explosion.entities.EntityLightBeam;
import icbm.explosion.explosive.blast.Blast;
import icbm.explosion.explosive.thread.ThreadExplosion;
import icbm.explosion.explosive.thread.ThreadSky;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import universalelectricity.api.vector.IVector3;
import universalelectricity.api.vector.Vector3;

public abstract class BlastBeam
extends Blast {
    protected ThreadExplosion thread;
    protected Set<EntityFlyingBlock> feiBlocks = new HashSet<EntityFlyingBlock>();
    protected EntityLightBeam lightBeam;
    protected float red;
    protected float green;
    protected float blue;
    protected int radius = 5;

    public BlastBeam(World world, Entity entity, double x, double y, double z, float size) {
        super(world, entity, x, y, z, size);
    }

    @Override
    public void doPreExplode() {
        if (!this.world().field_72995_K) {
            this.world().func_72876_a(this.field_77283_e, this.position.x, this.position.y, this.position.z, 4.0f, true);
            this.lightBeam = new EntityLightBeam(this.world(), (Vector3)this.position, 400, this.red, this.green, this.blue);
            this.world().func_72838_d((Entity)this.lightBeam);
            this.thread = new ThreadSky(this.position, (int)this.getRadius(), 50.0f, this.field_77283_e);
            this.thread.start();
        }
    }

    @Override
    public void doExplode() {
        if (!this.world().field_72995_K) {
            if (this.callCount > 100 / this.proceduralInterval() && this.thread.isComplete) {
                this.controller.endExplosion();
            }
            if (this.canFocusBeam(this.world(), (Vector3)this.position)) {
                int r = this.radius;
                for (int x = -r; x < r; ++x) {
                    for (int y = -r; y < r; ++y) {
                        for (int z = -r; z < r; ++z) {
                            double dist = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
                            if (dist > (double)r || dist < (double)(r - 3)) continue;
                            Vector3 currentPos = new Vector3(this.position.x + (double)x, this.position.y + (double)y, this.position.z + (double)z);
                            int blockID = this.world().func_72798_a(currentPos.intX(), currentPos.intY(), currentPos.intZ());
                            Block block = Block.field_71973_m[blockID];
                            if (block == null || block.isAirBlock(this.world(), x, y, z) || block.func_71934_m(this.world(), x, y, x) < 0.0f) continue;
                            int metadata = this.world().func_72805_g(currentPos.intX(), currentPos.intY(), currentPos.intZ());
                            if (this.world().field_73012_v.nextInt(2) <= 0) continue;
                            this.world().func_72832_d(currentPos.intX(), currentPos.intY(), currentPos.intZ(), 0, 0, 2);
                            currentPos.translate(0.5);
                            EntityFlyingBlock entity = new EntityFlyingBlock(this.world(), currentPos, blockID, metadata);
                            this.world().func_72838_d((Entity)entity);
                            this.feiBlocks.add(entity);
                            entity.pitchChange = 50.0f * this.world().field_73012_v.nextFloat();
                        }
                    }
                }
            } else {
                this.controller.endExplosion();
            }
            for (EntityFlyingBlock entity : this.feiBlocks) {
                Vector3 entityPosition = new Vector3((Entity)entity);
                Vector3 centeredPosition = entityPosition.clone().translate((IVector3)this.position.invert());
                centeredPosition.rotate(2.0);
                Vector3 newPosition = this.position.clone().translate((IVector3)centeredPosition);
                entity.field_70159_w /= 3.0;
                entity.field_70181_x /= 3.0;
                entity.field_70179_y /= 3.0;
                entity.func_70024_g((newPosition.x - entityPosition.x) * 0.5 * (double)this.proceduralInterval(), 0.09 * (double)this.proceduralInterval(), (newPosition.z - entityPosition.z) * 0.5 * (double)this.proceduralInterval());
                entity.yawChange += 3.0f * this.world().field_73012_v.nextFloat();
            }
        }
    }

    @Override
    public void doPostExplode() {
        if (!this.world().field_72995_K && this.lightBeam != null) {
            this.lightBeam.func_70106_y();
            this.lightBeam = null;
        }
    }

    public boolean canFocusBeam(World worldObj, Vector3 position) {
        return worldObj.func_72937_j(position.intX(), position.intY() + 1, position.intZ());
    }

    @Override
    public int proceduralInterval() {
        return 4;
    }

    @Override
    public long getEnergy() {
        return 10000L;
    }
}

