/*
 * Decompiled with CFR 0.152.
 */
package icbm.explosion.explosive.blast;

import icbm.explosion.ICBMExplosion;
import icbm.explosion.explosive.blast.Blast;
import icbm.explosion.explosive.blast.BlastMutation;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import resonant.lib.prefab.potion.CustomPotionEffect;
import universalelectricity.api.vector.IVector3;
import universalelectricity.api.vector.Vector3;

public class BlastChemical
extends Blast {
    private static final int CHECK_BAN_JING = 16;
    private static final float NENG_LIANG = 10.0f;
    private int duration;
    private float red = 1.0f;
    private float green = 1.0f;
    private float blue = 1.0f;
    private boolean playShortSoundFX;
    private boolean isContagious;
    private boolean isPoisonous;
    private boolean isConfuse;
    private boolean isMutate;

    public BlastChemical(World world, Entity entity, double x, double y, double z, float size) {
        super(world, entity, x, y, z, size);
    }

    public BlastChemical(World world, Entity entity, double x, double y, double z, float size, int duration, boolean playShortSoundFX) {
        this(world, entity, x, y, z, size);
        this.duration = duration / this.proceduralInterval();
        this.playShortSoundFX = playShortSoundFX;
    }

    public BlastChemical setRGB(float r, float g, float b) {
        this.red = r;
        this.green = g;
        this.blue = b;
        return this;
    }

    public BlastChemical setConfuse() {
        this.isConfuse = true;
        return this;
    }

    public BlastChemical setPoison() {
        this.isPoisonous = true;
        return this;
    }

    public BlastChemical setContagious() {
        this.isContagious = true;
        this.isMutate = true;
        return this;
    }

    @Override
    public void doPreExplode() {
        super.doPreExplode();
        if (!this.playShortSoundFX) {
            this.world().func_72908_a(this.position.x, this.position.y, this.position.z, "icbm:debilitation", 4.0f, (1.0f + (this.world().field_73012_v.nextFloat() - this.world().field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        }
    }

    @Override
    public void doExplode() {
        float radius = this.getRadius();
        if (this.world().field_72995_K) {
            for (int i = 0; i < 200; ++i) {
                Vector3 diDian = new Vector3();
                diDian.x = Math.random() * (double)radius / 2.0 - (double)(radius / 4.0f);
                diDian.y = Math.random() * (double)radius / 2.0 - (double)(radius / 4.0f);
                diDian.z = Math.random() * (double)radius / 2.0 - (double)(radius / 4.0f);
                diDian.scale((double)(Math.min(radius, (float)this.callCount) / 10.0f));
                if (!(diDian.getMagnitude() <= (double)radius)) continue;
                diDian.translate((IVector3)this.position);
                ICBMExplosion.proxy.spawnParticle("smoke", this.world(), diDian, (Math.random() - 0.5) / 2.0, (Math.random() - 0.5) / 2.0, (Math.random() - 0.5) / 2.0, this.red, this.green, this.blue, 7.0f, 8.0);
            }
        }
        AxisAlignedBB bounds = AxisAlignedBB.func_72330_a((double)(this.position.x - (double)radius), (double)(this.position.y - (double)radius), (double)(this.position.z - (double)radius), (double)(this.position.x + (double)radius), (double)(this.position.y + (double)radius), (double)(this.position.z + (double)radius));
        List allEntities = this.world().func_72872_a(EntityLivingBase.class, bounds);
        for (EntityLivingBase entity : allEntities) {
            if (this.isContagious) {
                ICBMExplosion.contagios_potion.poisonEntity((Vector3)this.position, entity);
            }
            if (this.isPoisonous) {
                ICBMExplosion.poisonous_potion.poisonEntity((Vector3)this.position, entity);
            }
            if (!this.isConfuse) continue;
            entity.func_70690_d((PotionEffect)new CustomPotionEffect(Potion.field_76431_k.field_76415_H, 360, 0));
            entity.func_70690_d((PotionEffect)new CustomPotionEffect(Potion.field_76419_f.field_76415_H, 1200, 0));
            entity.func_70690_d((PotionEffect)new CustomPotionEffect(Potion.field_76421_d.field_76415_H, 1200, 2));
        }
        if (this.isMutate) {
            new BlastMutation(this.world(), this.field_77283_e, this.position.x, this.position.y, this.position.z, this.getRadius()).explode();
        }
        if (this.playShortSoundFX) {
            this.world().func_72908_a(this.position.x + 0.5, this.position.y + 0.5, this.position.z + 0.5, "icbm:gasleak", 4.0f, (1.0f + (this.world().field_73012_v.nextFloat() - this.world().field_73012_v.nextFloat()) * 0.2f) * 1.0f);
        }
        if (this.callCount > this.duration) {
            this.controller.endExplosion();
        }
    }

    @Override
    public long getEnergy() {
        return 20L;
    }

    @Override
    public int proceduralInterval() {
        return 5;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.duration = nbt.func_74762_e("duration");
        this.isContagious = nbt.func_74767_n("isContagious");
        this.isPoisonous = nbt.func_74767_n("isPoisonous");
        this.isConfuse = nbt.func_74767_n("isConfuse");
        this.isMutate = nbt.func_74767_n("isMutate");
        this.red = nbt.func_74760_g("red");
        this.green = nbt.func_74760_g("green");
        this.blue = nbt.func_74760_g("blue");
        this.playShortSoundFX = nbt.func_74767_n("playShortSoundFX");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74768_a("duration", this.duration);
        nbt.func_74757_a("isContagious", this.isContagious);
        nbt.func_74757_a("isPoisonous", this.isPoisonous);
        nbt.func_74757_a("isConfuse", this.isConfuse);
        nbt.func_74757_a("isMutate", this.isMutate);
        nbt.func_74776_a("red", this.red);
        nbt.func_74776_a("green", this.green);
        nbt.func_74776_a("blue", this.blue);
        nbt.func_74757_a("playShortSoundFX", this.playShortSoundFX);
    }
}

