/*
 * Decompiled with CFR 0.152.
 */
package icbm.explosion.explosive.blast;

import calclavia.api.mffs.IForceFieldBlock;
import calclavia.api.mffs.fortron.IFortronStorage;
import ic2.api.item.ISpecialElectricItem;
import ic2.api.tile.IEnergyStorage;
import icbm.explosion.ICBMExplosion;
import icbm.explosion.entities.EntityExplosive;
import icbm.explosion.explosive.blast.Blast;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import resonant.api.explosion.IEMPBlock;
import resonant.api.explosion.IEMPItem;
import resonant.api.explosion.IExplosion;
import resonant.api.explosion.IMissile;
import resonant.api.map.RadarRegistry;
import universalelectricity.api.CompatibilityModule;
import universalelectricity.api.energy.IEnergyContainer;
import universalelectricity.api.item.IEnergyItem;
import universalelectricity.api.vector.IVector3;
import universalelectricity.api.vector.Vector2;
import universalelectricity.api.vector.Vector3;

public class BlastEMP
extends Blast {
    private boolean effectEntities = false;
    private boolean effectBlocks = false;

    public BlastEMP(World world, Entity entity, double x, double y, double z, float size) {
        super(world, entity, x, y, z, size);
    }

    public BlastEMP setEffectBlocks() {
        this.effectBlocks = true;
        return this;
    }

    public BlastEMP setEffectEntities() {
        this.effectEntities = true;
        return this;
    }

    @Override
    public void doExplode() {
        if (this.effectBlocks) {
            for (int x = (int)(-this.getRadius()); x < (int)this.getRadius(); ++x) {
                for (int y = (int)(-this.getRadius()); y < (int)this.getRadius(); ++y) {
                    for (int z = (int)(-this.getRadius()); z < (int)this.getRadius(); ++z) {
                        double dist = MathHelper.func_76133_a((double)(x * x + y * y + z * z));
                        Vector3 searchPosition = Vector3.translate((Vector3)this.position, (IVector3)new Vector3((double)x, (double)y, (double)z));
                        if (dist > (double)this.getRadius()) continue;
                        if (Math.round(this.position.x + (double)y) == (long)this.position.intY()) {
                            this.world().func_72869_a("largesmoke", searchPosition.x, searchPosition.y, searchPosition.z, 0.0, 0.0, 0.0);
                        }
                        int blockID = searchPosition.getBlockID((IBlockAccess)this.world());
                        Block block = Block.field_71973_m[blockID];
                        TileEntity tileEntity = searchPosition.getTileEntity((IBlockAccess)this.world());
                        if (block != null) {
                            if (block instanceof IForceFieldBlock) {
                                ((IForceFieldBlock)Block.field_71973_m[blockID]).weakenForceField(this.world(), searchPosition.intX(), searchPosition.intY(), searchPosition.intZ(), 1000);
                            } else if (block instanceof IEMPBlock) {
                                ((IEMPBlock)block).onEMP(this.world(), searchPosition.intX(), searchPosition.intY(), searchPosition.intZ(), (IExplosion)this);
                            }
                        }
                        if (tileEntity == null) continue;
                        if (tileEntity instanceof IFortronStorage) {
                            ((IFortronStorage)tileEntity).provideFortron((int)this.world().field_73012_v.nextFloat() * ((IFortronStorage)tileEntity).getFortronCapacity(), true);
                        }
                        if (tileEntity instanceof IEnergyContainer) {
                            ((IEnergyContainer)tileEntity).setEnergy(null, 0L);
                        }
                        if (tileEntity instanceof IEnergyStorage) {
                            ((IEnergyStorage)tileEntity).setStored(0);
                        }
                        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                            CompatibilityModule.extractEnergy((Object)tileEntity, (ForgeDirection)dir, (long)Integer.MAX_VALUE, (boolean)true);
                        }
                    }
                }
            }
        }
        if (this.effectEntities) {
            List entitiesNearby = RadarRegistry.getEntitiesWithinRadius((Vector2)this.position.toVector2(), (int)((int)this.getRadius()));
            for (Entity entity : entitiesNearby) {
                if (!(entity instanceof IMissile) || entity.func_70028_i((Entity)this.controller) || ((IMissile)entity).getTicksInAir() <= -1) continue;
                ((IMissile)entity).dropMissileAsItem();
            }
            int maxFx = 10;
            AxisAlignedBB bounds = AxisAlignedBB.func_72330_a((double)(this.position.x - (double)this.getRadius()), (double)(this.position.y - (double)this.getRadius()), (double)(this.position.z - (double)this.getRadius()), (double)(this.position.x + (double)this.getRadius()), (double)(this.position.y + (double)this.getRadius()), (double)(this.position.z + (double)this.getRadius()));
            List entities = this.world().func_72872_a(Entity.class, bounds);
            for (Entity entity : entities) {
                if (entity instanceof EntityLivingBase) {
                    if (this.world().field_72995_K && maxFx > 0) {
                        ICBMExplosion.proxy.spawnShock(this.world(), (Vector3)this.position, new Vector3(entity), 20);
                        --maxFx;
                    }
                    if (entity instanceof EntityCreeper && !this.world().field_72995_K) {
                        try {
                            ((EntityCreeper)entity).func_70096_w().func_75692_b(17, (Object)1);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (!(entity instanceof EntityPlayer)) continue;
                    InventoryPlayer inventory = ((EntityPlayer)entity).field_71071_by;
                    for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                        ItemStack itemStack = inventory.func_70301_a(i);
                        if (itemStack == null) continue;
                        if (itemStack.func_77973_b() instanceof IEMPItem) {
                            ((IEMPItem)itemStack.func_77973_b()).onEMP(itemStack, entity, (IExplosion)this);
                            continue;
                        }
                        if (itemStack.func_77973_b() instanceof IEnergyItem) {
                            ((IEnergyItem)itemStack.func_77973_b()).setEnergy(itemStack, 0L);
                            continue;
                        }
                        if (!(itemStack.func_77973_b() instanceof ISpecialElectricItem)) continue;
                        ((ISpecialElectricItem)itemStack.func_77973_b()).getManager(itemStack).discharge(itemStack, ((ISpecialElectricItem)itemStack.func_77973_b()).getMaxCharge(itemStack), 0, true, false);
                    }
                    continue;
                }
                if (!(entity instanceof EntityExplosive)) continue;
                entity.func_70106_y();
            }
        }
        ICBMExplosion.proxy.spawnParticle("shockwave", this.world(), (Vector3)this.position, 0.0, 0.0, 0.0, 0.0f, 0.0f, 255.0f, 10.0f, 3.0);
        this.world().func_72908_a(this.position.x, this.position.y, this.position.z, "icbm:emp", 4.0f, (1.0f + (this.world().field_73012_v.nextFloat() - this.world().field_73012_v.nextFloat()) * 0.2f) * 0.7f);
    }

    @Override
    public long getEnergy() {
        return 3000L;
    }
}

