/*
 * Decompiled with CFR 0.152.
 */
package icbm.explosion.explosive.blast;

import calclavia.api.mffs.IForceFieldBlock;
import icbm.core.entity.EntityFlyingBlock;
import icbm.explosion.ICBMExplosion;
import icbm.explosion.entities.EntityExplosion;
import icbm.explosion.entities.EntityExplosive;
import icbm.explosion.explosive.blast.Blast;
import icbm.explosion.explosive.blast.BlastAntimatter;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFluid;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidBlock;
import resonant.api.explosion.IExplosion;
import resonant.api.explosion.IExplosiveIgnore;
import resonant.lib.config.Config;
import universalelectricity.api.vector.IVector3;
import universalelectricity.api.vector.Vector3;

public class BlastRedmatter
extends Blast {
    private int maxTakeBlocks = 5;
    @Config(category="Features", key="RedMatter Life Span in ticks")
    public static int MAX_LIFESPAN = 3600;
    @Config(category="Features", key="RedMatter despawn")
    public static boolean DO_DESPAWN = true;

    public BlastRedmatter(World world, Entity entity, double x, double y, double z, float size) {
        super(world, entity, x, y, z, size);
    }

    @Override
    public void doPreExplode() {
        if (!this.world().field_72995_K) {
            this.world().func_72876_a(this.field_77283_e, this.position.x, this.position.y, this.position.z, 5.0f, true);
        }
    }

    @Override
    protected void doPostExplode() {
        AxisAlignedBB bounds = AxisAlignedBB.func_72330_a((double)(this.field_77284_b - (double)this.field_77280_f), (double)(this.field_77285_c - (double)this.field_77280_f), (double)(this.field_77282_d - (double)this.field_77280_f), (double)(this.field_77284_b + (double)this.field_77280_f), (double)(this.field_77285_c + (double)this.field_77280_f), (double)(this.field_77282_d + (double)this.field_77280_f));
        List list = this.world().func_72872_a(EntityExplosion.class, bounds);
        for (Object obj : list) {
            if (!(obj instanceof EntityExplosion)) continue;
            EntityExplosion explosion = (EntityExplosion)((Object)obj);
            if (!(explosion.blast instanceof BlastRedmatter)) continue;
            explosion.func_70106_y();
        }
    }

    @Override
    public void doExplode() {
        if (DO_DESPAWN && this.callCount >= MAX_LIFESPAN) {
            this.postExplode();
        }
        if (!this.world().field_72995_K) {
            Vector3 currentPos = new Vector3();
            int blockID = -1;
            int metadata = -1;
            double dist = -1.0;
            int takenBlocks = 0;
            Block block = null;
            int radius = 1;
            block0: while ((float)radius < this.getRadius()) {
                for (int xCoord = -radius; xCoord < radius; ++xCoord) {
                    for (int yCoord = -radius; yCoord < radius; ++yCoord) {
                        for (int zCoord = -radius; zCoord < radius; ++zCoord) {
                            currentPos.x = this.position.x + (double)xCoord;
                            currentPos.y = this.position.y + (double)yCoord;
                            currentPos.z = this.position.z + (double)zCoord;
                            dist = MathHelper.func_76133_a((double)(xCoord * xCoord + yCoord * yCoord + zCoord * zCoord));
                            if (dist > (double)radius || dist < (double)(radius - 2)) continue;
                            blockID = currentPos.getBlockID((IBlockAccess)this.world());
                            metadata = currentPos.getBlockMetadata((IBlockAccess)this.world());
                            block = Block.field_71973_m[blockID];
                            if (block == null || !(block.func_71934_m(this.world(), currentPos.intX(), currentPos.intY(), currentPos.intZ()) >= 0.0f)) continue;
                            if (block instanceof IForceFieldBlock) {
                                ((IForceFieldBlock)block).weakenForceField(this.world(), currentPos.intX(), currentPos.intY(), currentPos.intZ(), 50);
                                continue;
                            }
                            this.world().func_72832_d(currentPos.intX(), currentPos.intY(), currentPos.intZ(), 0, 0, block instanceof BlockFluid ? 0 : 2);
                            if (block instanceof BlockFluid || block instanceof IFluidBlock) continue;
                            currentPos.add(0.5);
                            if ((double)this.world().field_73012_v.nextFloat() > 0.8) {
                                EntityFlyingBlock entity = new EntityFlyingBlock(this.world(), currentPos, blockID, metadata);
                                this.world().func_72838_d((Entity)entity);
                                entity.yawChange = 50.0f * this.world().field_73012_v.nextFloat();
                                entity.pitchChange = 50.0f * this.world().field_73012_v.nextFloat();
                            }
                            if (++takenBlocks > this.maxTakeBlocks) break block0;
                        }
                    }
                }
                ++radius;
            }
        }
        float radius = this.getRadius() + this.getRadius() / 2.0f;
        AxisAlignedBB bounds = AxisAlignedBB.func_72330_a((double)(this.position.x - (double)radius), (double)(this.position.y - (double)radius), (double)(this.position.z - (double)radius), (double)(this.position.x + (double)radius), (double)(this.position.y + (double)radius), (double)(this.position.z + (double)radius));
        List allEntities = this.world().func_72872_a(Entity.class, bounds);
        boolean doExplosion = true;
        for (Entity entity : allEntities) {
            doExplosion = !this.affectEntity(radius, entity, doExplosion);
        }
        if (this.world().field_73012_v.nextInt(8) == 0) {
            this.world().func_72908_a(this.position.x + (Math.random() - 0.5) * (double)radius, this.position.y + (Math.random() - 0.5) * (double)radius, this.position.z + (Math.random() - 0.5) * (double)radius, "icbm:collapse", 6.0f - this.world().field_73012_v.nextFloat(), 1.0f - this.world().field_73012_v.nextFloat() * 0.4f);
        }
        this.world().func_72908_a(this.position.x, this.position.y, this.position.z, "icbm:redmatter", 3.0f, (1.0f + (this.world().field_73012_v.nextFloat() - this.world().field_73012_v.nextFloat()) * 0.2f) * 1.0f);
    }

    public boolean affectEntity(float radius, Entity entity, boolean doExplosion) {
        boolean explosionCreated = false;
        if (entity == this.controller) {
            return false;
        }
        if (entity instanceof IExplosiveIgnore && ((IExplosiveIgnore)entity).canIgnore((IExplosion)this)) {
            return false;
        }
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
            return false;
        }
        double xDifference = entity.field_70165_t - this.position.x;
        double yDifference = entity.field_70163_u - this.position.y;
        double zDifference = entity.field_70161_v - this.position.z;
        double xPercentage = 1.0 - xDifference / (double)radius;
        double yPercentage = 1.0 - yDifference / (double)radius;
        double zPercentage = 1.0 - zDifference / (double)radius;
        double distancePercentage = this.position.distance((IVector3)new Vector3(entity)) / (double)radius;
        Vector3 entityPosition = new Vector3(entity);
        Vector3 centeredPosition = entityPosition.clone().subtract((IVector3)this.position);
        centeredPosition.rotate(1.5 * distancePercentage * Math.random(), 1.5 * distancePercentage * Math.random(), 1.5 * distancePercentage * Math.random());
        Vector3 newPosition = Vector3.translate((Vector3)this.position, (IVector3)centeredPosition);
        entity.func_70024_g(newPosition.x - entityPosition.x, 0.0, newPosition.z - entityPosition.z);
        entity.func_70024_g(-xDifference * 0.015 * xPercentage, -yDifference * 0.015 * yPercentage, -zDifference * 0.015 * zPercentage);
        if (this.world().field_72995_K && entity instanceof EntityFlyingBlock && ICBMExplosion.proxy.getParticleSetting() == 0 && this.world().field_73012_v.nextInt(5) == 0) {
            ICBMExplosion.proxy.spawnParticle("digging", this.world(), new Vector3(entity), -xDifference, -yDifference + 10.0, -zDifference, ((EntityFlyingBlock)entity).blockID, 0.0f, ((EntityFlyingBlock)entity).metadata, 2.0f, 1.0);
        }
        Vector3 vector3 = new Vector3(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        if (Vector3.distance((Vector3)vector3, (IVector3)this.position) < 4.0) {
            if (doExplosion && !explosionCreated && this.callCount % 5 == 0) {
                Vector3 tempMotion = new Vector3(this.controller.field_70159_w, this.controller.field_70181_x, this.controller.field_70179_y);
                this.world().func_72876_a(this.field_77283_e, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, 3.0f, true);
                this.controller.field_70159_w = tempMotion.x;
                this.controller.field_70181_x = tempMotion.y;
                this.controller.field_70179_y = tempMotion.z;
                explosionCreated = true;
            }
            if (entity instanceof EntityLiving) {
                entity.field_70143_R = 0.0f;
            } else if (entity instanceof EntityExplosion) {
                if (((EntityExplosion)entity).blast instanceof BlastAntimatter || ((EntityExplosion)entity).blast instanceof BlastRedmatter) {
                    this.world().func_72908_a(this.position.x, this.position.y, this.position.z, "icbm:explosion", 7.0f, (1.0f + (this.world().field_73012_v.nextFloat() - this.world().field_73012_v.nextFloat()) * 0.2f) * 0.7f);
                    if ((double)this.world().field_73012_v.nextFloat() > 0.85 && !this.world().field_72995_K) {
                        entity.func_70106_y();
                        return explosionCreated;
                    }
                }
            } else if (entity instanceof EntityExplosive) {
                ((EntityExplosive)entity).explode();
            } else {
                entity.func_70106_y();
            }
        }
        return explosionCreated;
    }

    @Override
    public int proceduralInterval() {
        return 1;
    }

    @Override
    public long getEnergy() {
        return -3000L;
    }

    @Override
    public boolean isMovable() {
        return this.callCount > 1;
    }
}

