/*
 * Decompiled with CFR 0.152.
 */
package icbm.explosion.explosive.blast;

import icbm.explosion.explosive.blast.Blast;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import resonant.lib.prefab.vector.Cuboid;
import universalelectricity.api.vector.Vector3;
import universalelectricity.api.vector.VectorWorld;

public class BlastRepulsive
extends Blast {
    private int checkBanJing = 16;
    protected float nengLiang = 10.0f;
    private List<Vector3> blownBlocks = new ArrayList<Vector3>();
    private int pushType = 0;
    private boolean destroyItem = false;

    public BlastRepulsive(World world, Entity entity, double x, double y, double z, float size) {
        super(world, entity, x, y, z, size);
    }

    public BlastRepulsive setPushType(int type) {
        this.pushType = type;
        return this;
    }

    public BlastRepulsive setDestroyItems() {
        this.destroyItem = true;
        return this;
    }

    @Override
    public void doExplode() {
        if (!this.world().field_72995_K) {
            for (int x = 0; x < this.checkBanJing; ++x) {
                for (int y = 0; y < this.checkBanJing; ++y) {
                    for (int z = 0; z < this.checkBanJing; ++z) {
                        if (x != 0 && x != this.checkBanJing - 1 && y != 0 && y != this.checkBanJing - 1 && z != 0 && z != this.checkBanJing - 1) continue;
                        double xStep = (float)x / ((float)this.checkBanJing - 1.0f) * 2.0f - 1.0f;
                        double yStep = (float)y / ((float)this.checkBanJing - 1.0f) * 2.0f - 1.0f;
                        double zStep = (float)z / ((float)this.checkBanJing - 1.0f) * 2.0f - 1.0f;
                        double diagonalDistance = Math.sqrt(xStep * xStep + yStep * yStep + zStep * zStep);
                        xStep /= diagonalDistance;
                        yStep /= diagonalDistance;
                        zStep /= diagonalDistance;
                        double var15 = this.position.x;
                        double var17 = this.position.y;
                        double var19 = this.position.z;
                        float var21 = 0.3f;
                        for (float var14 = this.getRadius() * (0.7f + this.world().field_73012_v.nextFloat() * 0.6f); var14 > 0.0f; var14 -= var21 * 0.75f) {
                            int var22 = MathHelper.func_76128_c((double)var15);
                            int var23 = MathHelper.func_76128_c((double)var17);
                            int var24 = MathHelper.func_76128_c((double)var19);
                            int var25 = this.world().func_72798_a(var22, var23, var24);
                            if (var25 > 0) {
                                var14 -= (Block.field_71973_m[var25].getExplosionResistance(this.field_77283_e, this.world(), var22, var23, var24, (double)this.position.intX(), (double)this.position.intY(), (double)this.position.intZ()) + 0.3f) * var21;
                            }
                            if (var14 > 0.0f) {
                                this.blownBlocks.add(new Vector3((double)var22, (double)var23, (double)var24));
                            }
                            var15 += xStep * (double)var21;
                            var17 += yStep * (double)var21;
                            var19 += zStep * (double)var21;
                        }
                    }
                }
            }
        }
        this.world().func_72908_a(this.position.x, this.position.y, this.position.z, "random.explode", 4.0f, (1.0f + (this.world().field_73012_v.nextFloat() - this.world().field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        switch (this.pushType) {
            case 0: {
                this.doDamageEntities(this.getRadius(), this.nengLiang, this.destroyItem);
                break;
            }
            default: {
                this.pushEntities(12.0f, this.getRadius() * 4.0f, this.pushType);
            }
        }
        if (!this.world().field_72995_K) {
            for (int var3 = this.blownBlocks.size() - 1; var3 >= 0; --var3) {
                Vector3 blownPosition = this.blownBlocks.get(var3);
                int var5 = blownPosition.intX();
                int var6 = blownPosition.intY();
                int var7 = blownPosition.intZ();
                int blockID = this.world().func_72798_a(var5, var6, var7);
                int metadata = this.world().func_72805_g(var5, var6, var7);
                double var9 = (float)var5 + this.world().field_73012_v.nextFloat();
                double var11 = (float)var6 + this.world().field_73012_v.nextFloat();
                double var13 = (float)var7 + this.world().field_73012_v.nextFloat();
                double var151 = var9 - this.position.y;
                double var171 = var11 - this.position.y;
                double var191 = var13 - this.position.z;
                double var211 = MathHelper.func_76133_a((double)(var151 * var151 + var171 * var171 + var191 * var191));
                var151 /= var211;
                var171 /= var211;
                var191 /= var211;
                double var23 = 0.5 / (var211 / (double)this.getRadius() + 0.1);
                this.world().func_72869_a("explode", (var9 + this.position.x * 1.0) / 2.0, (var11 + this.position.y * 1.0) / 2.0, (var13 + this.position.z * 1.0) / 2.0, var151 *= (var23 *= (double)(this.world().field_73012_v.nextFloat() * this.world().field_73012_v.nextFloat() + 0.3f)), var171 *= var23, var191 *= var23);
                this.world().func_72869_a("smoke", var9, var11, var13, var151, var171, var191);
                if (blockID <= 0) continue;
                try {
                    Block block = Block.field_71973_m[blockID];
                    if (block.func_85103_a(null)) {
                        block.func_71914_a(this.world(), var5, var6, var7, this.world().func_72805_g(var5, var6, var7), 1.0f, 0);
                    }
                    block.onBlockExploded(this.world(), var5, var6, var7, (Explosion)this);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void pushEntities(float radius, float force, int type) {
        VectorWorld minCoord = this.position.clone();
        minCoord.add((double)(-radius - 1.0f));
        VectorWorld maxCoord = this.position.clone();
        maxCoord.add((double)(radius + 1.0f));
        Cuboid region = new Cuboid((Vector3)minCoord, (Vector3)maxCoord);
        List entities = region.getEntities(this.world(), Entity.class);
        for (Entity entity : entities) {
            double modifier;
            double var13 = entity.func_70011_f(this.position.x, this.position.y, this.position.z) / (double)radius;
            if (!(var13 <= 1.0)) continue;
            double xDifference = entity.field_70165_t - this.position.x;
            double yDifference = entity.field_70163_u - this.position.y;
            double zDifference = entity.field_70161_v - this.position.z;
            double distance = MathHelper.func_76133_a((double)(xDifference * xDifference + yDifference * yDifference + zDifference * zDifference));
            xDifference /= distance;
            yDifference /= distance;
            zDifference /= distance;
            if (type == 1) {
                modifier = var13 * (double)force * (entity instanceof EntityPlayer ? 0.5 : 1.0);
                entity.func_70024_g(-xDifference * modifier, -yDifference * modifier, -zDifference * modifier);
                continue;
            }
            if (type != 2) continue;
            modifier = (1.0 - var13) * (double)force * (entity instanceof EntityPlayer ? 0.5 : 1.0);
            entity.func_70024_g(xDifference * modifier, yDifference * modifier, zDifference * modifier);
        }
    }

    @Override
    public long getEnergy() {
        return 418000L;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.pushType = nbt.func_74762_e("pushType");
        this.destroyItem = nbt.func_74767_n("destroyItem");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74768_a("pushType", this.pushType);
        nbt.func_74757_a("destroyItem", this.destroyItem);
    }
}

