/*
 * Decompiled with CFR 0.152.
 */
package icbm.explosion.explosive.blast;

import icbm.explosion.explosive.blast.BlastBeam;
import icbm.explosion.potion.PoisonFrostBite;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import resonant.lib.prefab.potion.CustomPotionEffect;
import universalelectricity.api.vector.IVector3;
import universalelectricity.api.vector.Vector3;

public class BlastSky
extends BlastBeam {
    public BlastSky(World world, Entity entity, double x, double y, double z, float size) {
        super(world, entity, x, y, z, size);
        this.red = 0.0f;
        this.green = 0.3f;
        this.blue = 0.7f;
    }

    @Override
    public void doExplode() {
        super.doExplode();
        this.world().func_72908_a(this.position.x, this.position.y, this.position.z, "icbm:redmatter", 4.0f, 0.8f);
    }

    @Override
    public void doPostExplode() {
        super.doPostExplode();
        if (!this.world().field_72995_K) {
            if (this.canFocusBeam(this.world(), (Vector3)this.position) && this.thread.isComplete) {
                List livingEntities = this.world().func_72872_a(EntityLiving.class, AxisAlignedBB.func_72330_a((double)(this.position.x - (double)this.getRadius()), (double)(this.position.y - (double)this.getRadius()), (double)(this.position.z - (double)this.getRadius()), (double)(this.position.x + (double)this.getRadius()), (double)(this.position.y + (double)this.getRadius()), (double)(this.position.z + (double)this.getRadius())));
                for (EntityLiving entity : livingEntities) {
                    entity.func_70690_d((PotionEffect)new CustomPotionEffect(PoisonFrostBite.INSTANCE.func_76396_c(), 1200, 1, null));
                    entity.func_70690_d(new PotionEffect(Potion.field_76431_k.field_76415_H, 200, 2));
                    entity.func_70690_d(new PotionEffect(Potion.field_76419_f.field_76415_H, 2400, 2));
                    entity.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 2400, 4));
                }
                for (Vector3 targetPosition : this.thread.results) {
                    double chance;
                    double distance = Vector3.distance((Vector3)targetPosition, (IVector3)this.position);
                    double distanceFromCenter = this.position.distance((IVector3)targetPosition);
                    if (distanceFromCenter > (double)this.getRadius() || !((chance = (double)this.getRadius() - Math.random() * distanceFromCenter) > distanceFromCenter * 0.55)) continue;
                    int blockID = this.world().func_72798_a(targetPosition.intX(), targetPosition.intY(), targetPosition.intZ());
                    if (blockID == Block.field_72067_ar.field_71990_ca || blockID == Block.field_71944_C.field_71990_ca || blockID == Block.field_71938_D.field_71990_ca) {
                        this.world().func_72832_d(targetPosition.intX(), targetPosition.intY(), targetPosition.intZ(), Block.field_72037_aS.field_71990_ca, 0, 2);
                        continue;
                    }
                    if (blockID != 0 || this.world().func_72798_a(targetPosition.intX(), targetPosition.intY() - 1, targetPosition.intZ()) == Block.field_72036_aT.field_71990_ca || this.world().func_72798_a(targetPosition.intX(), targetPosition.intY() - 1, targetPosition.intZ()) == 0) continue;
                    this.world().func_72832_d(targetPosition.intX(), targetPosition.intY(), targetPosition.intZ(), Block.field_72036_aT.field_71990_ca, 0, 2);
                }
                this.world().func_72908_a(this.position.x + 0.5, this.position.y + 0.5, this.position.z + 0.5, "icbm:redmatter", 6.0f, (1.0f + (this.world().field_73012_v.nextFloat() - this.world().field_73012_v.nextFloat()) * 0.2f) * 1.0f);
            }
            this.world().func_72877_b(1200L);
        }
    }

    @Override
    public boolean canFocusBeam(World worldObj, Vector3 position) {
        long worldTime;
        for (worldTime = worldObj.func_72820_D(); worldTime > 23999L; worldTime -= 23999L) {
        }
        return worldTime > 12000L && super.canFocusBeam(worldObj, position);
    }
}

