/*
 * Decompiled with CFR 0.152.
 */
package icbm.explosion.explosive.blast;

import calclavia.api.mffs.IForceFieldBlock;
import icbm.core.entity.EntityFlyingBlock;
import icbm.explosion.ICBMExplosion;
import icbm.explosion.entities.EntityMissile;
import icbm.explosion.explosive.BlockExplosive;
import icbm.explosion.explosive.TileExplosive;
import icbm.explosion.explosive.blast.Blast;
import icbm.explosion.explosive.thread.ThreadLargeExplosion;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFluid;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidBlock;
import universalelectricity.api.vector.IVector3;
import universalelectricity.api.vector.Vector3;

public class BlastSonic
extends Blast {
    private float nengLiang;
    private ThreadLargeExplosion thread;
    private boolean hasShockWave = false;

    public BlastSonic(World world, Entity entity, double x, double y, double z, float size) {
        super(world, entity, x, y, z, size);
    }

    public BlastSonic(World world, Entity entity, double x, double y, double z, float size, float nengLiang) {
        this(world, entity, x, y, z, size);
        this.nengLiang = nengLiang;
    }

    public Blast setShockWave() {
        this.hasShockWave = true;
        return this;
    }

    @Override
    public void doPreExplode() {
        if (!this.world().field_72995_K) {
            if (this.hasShockWave) {
                int x = (int)(-this.getRadius() * 2.0f);
                while ((float)x < this.getRadius() * 2.0f) {
                    int y = (int)(-this.getRadius() * 2.0f);
                    while ((float)y < this.getRadius() * 2.0f) {
                        int z = (int)(-this.getRadius() * 2.0f);
                        while ((float)z < this.getRadius() * 2.0f) {
                            Vector3 targetPosition = Vector3.translate((Vector3)this.position, (IVector3)new Vector3((double)x, (double)y, (double)z));
                            int blockID = this.world().func_72798_a(targetPosition.intX(), targetPosition.intY(), targetPosition.intZ());
                            if (blockID > 0) {
                                Material material = this.world().func_72803_f(targetPosition.intX(), targetPosition.intY(), targetPosition.intZ());
                                if (blockID != Block.field_71986_z.field_71990_ca && !(Block.field_71973_m[blockID] instanceof BlockFluid) && (Block.field_71973_m[blockID].getExplosionResistance(this.field_77283_e, this.world(), targetPosition.intX(), targetPosition.intY(), targetPosition.intZ(), (double)this.position.intX(), (double)this.position.intY(), (double)this.position.intZ()) > this.nengLiang || material == Material.field_76264_q)) {
                                    targetPosition.setBlock(this.world(), 0);
                                }
                            }
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
            }
            this.thread = new ThreadLargeExplosion(this.position, (int)this.getRadius(), this.nengLiang, this.field_77283_e, new ThreadLargeExplosion.IThreadCallBack(){

                @Override
                public float getResistance(World world, Vector3 explosionPosition, Vector3 targetPosition, Entity source, Block block) {
                    float resistance = 0.0f;
                    resistance = block instanceof BlockFluid || block instanceof IFluidBlock ? 1.0f : block.getExplosionResistance(source, world, targetPosition.intX(), targetPosition.intY(), targetPosition.intZ(), (double)explosionPosition.intX(), (double)explosionPosition.intY(), (double)explosionPosition.intZ());
                    return resistance;
                }
            });
            this.thread.start();
        }
        if (this.hasShockWave) {
            this.world().func_72908_a(this.position.x, this.position.y, this.position.z, "icbm:hypersonic", 4.0f, (1.0f + (this.world().field_73012_v.nextFloat() - this.world().field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        } else {
            this.world().func_72908_a(this.position.x, this.position.y, this.position.z, "icbm:sonicwave", 4.0f, (1.0f + (this.world().field_73012_v.nextFloat() - this.world().field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doExplode() {
        List allEntities;
        int r = this.callCount;
        if (!this.world().field_72995_K && this.thread != null && this.thread.isComplete) {
            Iterator it = this.thread.results.iterator();
            while (it.hasNext()) {
                int blockID;
                Vector3 targetPosition = (Vector3)it.next();
                double distance = Vector3.distance((Vector3)targetPosition, (IVector3)this.position);
                if (distance > (double)r || distance < (double)(r - 3) || (blockID = this.world().func_72798_a(targetPosition.intX(), targetPosition.intY(), targetPosition.intZ())) == 0 || blockID == Block.field_71986_z.field_71990_ca || blockID == Block.field_72089_ap.field_71990_ca || Block.field_71973_m[blockID] instanceof IForceFieldBlock) continue;
                int metadata = this.world().func_72805_g(targetPosition.intX(), targetPosition.intY(), targetPosition.intZ());
                if (!(distance < (double)(r - 1)) && this.world().field_73012_v.nextInt(3) <= 0) continue;
                if (blockID == ICBMExplosion.blockExplosive.field_71990_ca) {
                    BlockExplosive.yinZha(this.world(), targetPosition.intX(), targetPosition.intY(), targetPosition.intZ(), ((TileExplosive)this.world().func_72796_p((int)targetPosition.intX(), (int)targetPosition.intY(), (int)targetPosition.intZ())).haoMa, 1);
                } else {
                    this.world().func_94571_i(targetPosition.intX(), targetPosition.intY(), targetPosition.intZ());
                }
                targetPosition.translate(0.5);
                if ((double)this.world().field_73012_v.nextFloat() < 0.3 * (double)(this.getRadius() - (float)r)) {
                    EntityFlyingBlock entity = new EntityFlyingBlock(this.world(), targetPosition, blockID, metadata);
                    this.world().func_72838_d((Entity)entity);
                    entity.yawChange = 50.0f * this.world().field_73012_v.nextFloat();
                    entity.pitchChange = 100.0f * this.world().field_73012_v.nextFloat();
                }
                it.remove();
            }
        }
        int radius = 2 * this.callCount;
        AxisAlignedBB bounds = AxisAlignedBB.func_72330_a((double)(this.position.x - (double)radius), (double)(this.position.y - (double)radius), (double)(this.position.z - (double)radius), (double)(this.position.x + (double)radius), (double)(this.position.y + (double)radius), (double)(this.position.z + (double)radius));
        List list = allEntities = this.world().func_72872_a(Entity.class, bounds);
        synchronized (list) {
            for (Entity entity : allEntities) {
                if (entity instanceof EntityMissile) {
                    ((EntityMissile)entity).setExplode();
                    break;
                }
                double xDifference = entity.field_70165_t - this.position.x;
                double zDifference = entity.field_70161_v - this.position.z;
                r = (int)this.getRadius();
                if (xDifference < 0.0) {
                    r = (int)(-this.getRadius());
                }
                entity.field_70159_w += ((double)r - xDifference) * 0.02 * (double)this.world().field_73012_v.nextFloat();
                entity.field_70181_x += (double)(3.0f * this.world().field_73012_v.nextFloat());
                r = (int)this.getRadius();
                if (zDifference < 0.0) {
                    r = (int)(-this.getRadius());
                }
                entity.field_70179_y += ((double)r - zDifference) * 0.02 * (double)this.world().field_73012_v.nextFloat();
            }
        }
        if ((float)this.callCount > this.getRadius()) {
            this.controller.endExplosion();
        }
    }

    @Override
    public int proceduralInterval() {
        return 4;
    }

    @Override
    public long getEnergy() {
        return 3000L;
    }
}

