/*
 * Decompiled with CFR 0.152.
 */
package icbm.explosion.explosive.thread;

import icbm.explosion.explosive.thread.ThreadExplosion;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFluid;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidBlock;
import universalelectricity.api.vector.IVector3;
import universalelectricity.api.vector.Vector3;
import universalelectricity.api.vector.VectorWorld;

public class ThreadLargeExplosion
extends ThreadExplosion {
    public IThreadCallBack callBack;

    public ThreadLargeExplosion(VectorWorld position, int range, float energy, Entity source, IThreadCallBack callBack) {
        super(position, range, energy, source);
        this.callBack = callBack;
    }

    public ThreadLargeExplosion(VectorWorld position, int range, float energy, Entity source) {
        this(position, range, energy, source, new IThreadCallBack(){

            @Override
            public float getResistance(World world, Vector3 pos, Vector3 targetPosition, Entity source, Block block) {
                float resistance = 0.0f;
                resistance = block instanceof BlockFluid || block instanceof IFluidBlock ? 0.25f : block.getExplosionResistance(source, world, targetPosition.intX(), targetPosition.intY(), targetPosition.intZ(), (double)pos.intX(), (double)pos.intY(), (double)pos.intZ());
                return resistance;
            }
        });
    }

    @Override
    public void run() {
        int steps = (int)Math.ceil(Math.PI / Math.atan(1.0 / (double)this.radius));
        for (int phi_n = 0; phi_n < 2 * steps; ++phi_n) {
            for (int theta_n = 0; theta_n < steps; ++theta_n) {
                double phi = Math.PI * 2 / (double)steps * (double)phi_n;
                double theta = Math.PI / (double)steps * (double)theta_n;
                Vector3 delta = new Vector3(Math.sin(theta) * Math.cos(phi), Math.cos(theta), Math.sin(theta) * Math.sin(phi));
                VectorWorld t = this.position.clone();
                float d = 0.3f;
                for (float power = this.energy - this.energy * this.position.world().field_73012_v.nextFloat() / 2.0f; power > 0.0f && !(t.distance((IVector3)this.position) > (double)this.radius); power -= d * 0.75f * 10.0f) {
                    Block block = Block.field_71973_m[this.position.world().func_72798_a(t.intX(), t.intY(), t.intZ())];
                    if (block != null && block.func_71934_m(this.position.world(), t.intX(), t.intY(), t.intZ()) >= 0.0f && (power -= this.callBack.getResistance(this.position.world(), (Vector3)this.position, (Vector3)t, this.source, block)) > 0.0f) {
                        this.results.add(t.clone());
                    }
                    t.translate((IVector3)delta);
                }
            }
        }
        super.run();
    }

    public static interface IThreadCallBack {
        public float getResistance(World var1, Vector3 var2, Vector3 var3, Entity var4, Block var5);
    }
}

