/*
 * Decompiled with CFR 0.152.
 */
package icbm.explosion.gui;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.PacketDispatcher;
import icbm.core.ICBMCore;
import icbm.core.gui.GuiICBM;
import icbm.explosion.entities.EntityMissile;
import icbm.explosion.machines.BlockICBMMachine;
import icbm.explosion.machines.TileRadarStation;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import resonant.lib.prefab.vector.Rectangle;
import resonant.lib.utility.LanguageUtility;
import universalelectricity.api.energy.UnitDisplay;
import universalelectricity.api.vector.Vector2;

public class GuiRadarStation
extends GuiICBM {
    public static final ResourceLocation TEXTURE = new ResourceLocation("icbm", "textures/gui/gui_radar.png");
    public static final ResourceLocation TEXTURE_RED_DOT = new ResourceLocation("icbm", "textures/gui/reddot.png");
    public static final ResourceLocation TEXTURE_YELLOW_DOT = new ResourceLocation("icbm", "textures/gui/yellowdot.png");
    public static final ResourceLocation TEXTURE_WHITE_DOT = new ResourceLocation("icbm", "textures/gui/whitedot.png");
    private TileRadarStation tileEntity;
    private int containerPosX;
    private int containerPosY;
    private GuiTextField textFieldAlarmRange;
    private GuiTextField textFieldSafetyZone;
    private GuiTextField textFieldFrequency;
    private List<Vector2> missileCoords = new ArrayList<Vector2>();
    private Vector2 mouseOverCoords = new Vector2();
    private Vector2 mousePosition = new Vector2();
    private Vector2 radarCenter;
    private float radarMapRadius;
    private String info = "";
    private String info2;

    public GuiRadarStation(TileRadarStation tileEntity) {
        this.tileEntity = tileEntity;
        this.mouseOverCoords = new Vector2((double)this.tileEntity.field_70329_l, (double)this.tileEntity.field_70327_n);
        this.field_74195_c = 166;
        this.field_74194_b = 256;
        this.radarCenter = new Vector2((double)(this.containerPosX + this.field_74194_b / 3 - 14), (double)(this.containerPosY + this.field_74195_c / 2 + 4));
        this.radarMapRadius = 7.836991f;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.textFieldSafetyZone = new GuiTextField(this.field_73886_k, 210, 67, 30, 12);
        this.textFieldSafetyZone.func_73804_f(3);
        this.textFieldSafetyZone.func_73782_a(this.tileEntity.safetyRange + "");
        this.textFieldAlarmRange = new GuiTextField(this.field_73886_k, 210, 82, 30, 12);
        this.textFieldAlarmRange.func_73804_f(3);
        this.textFieldAlarmRange.func_73782_a(this.tileEntity.alarmRange + "");
        this.textFieldFrequency = new GuiTextField(this.field_73886_k, 155, 112, 50, 12);
        this.textFieldFrequency.func_73804_f(6);
        this.textFieldFrequency.func_73782_a(this.tileEntity.getFrequency() + "");
        PacketDispatcher.sendPacketToServer((Packet)ICBMCore.PACKET_TILE.getPacket((TileEntity)this.tileEntity, new Object[]{-1, true}));
    }

    public void func_73874_b() {
        super.func_73874_b();
        PacketDispatcher.sendPacketToServer((Packet)ICBMCore.PACKET_TILE.getPacket((TileEntity)this.tileEntity, new Object[]{-1, false}));
    }

    protected void func_74189_g(int mouseX, int mouseY) {
        this.field_73886_k.func_78276_b("\u00a77" + LanguageUtility.getLocal((String)"icbm.machine.9.name"), this.field_74194_b / 2 - 30, 6, 0x404040);
        this.field_73886_k.func_78276_b(LanguageUtility.getLocal((String)"gui.radar.coords"), 155, 18, 0x404040);
        this.field_73886_k.func_78276_b(LanguageUtility.getLocal((String)"gui.misc.x") + " " + (int)Math.round(this.mouseOverCoords.x) + " " + LanguageUtility.getLocal((String)"gui.misc.z") + " " + (int)Math.round(this.mouseOverCoords.y), 155, 30, 0x404040);
        this.field_73886_k.func_78276_b("\u00a76" + this.info, 155, 42, 0x404040);
        this.field_73886_k.func_78276_b("\u00a74" + this.info2, 155, 54, 0x404040);
        this.field_73886_k.func_78276_b(LanguageUtility.getLocal((String)"gui.radar.zoneSafe"), 152, 70, 0x404040);
        this.textFieldSafetyZone.func_73795_f();
        this.field_73886_k.func_78276_b(LanguageUtility.getLocal((String)"gui.radar.zoneAlarm"), 150, 85, 0x404040);
        this.textFieldAlarmRange.func_73795_f();
        this.field_73886_k.func_78276_b(LanguageUtility.getLocal((String)"gui.misc.freq"), 155, 100, 0x404040);
        this.textFieldFrequency.func_73795_f();
        this.field_73886_k.func_78276_b(UnitDisplay.getDisplay((double)1.5, (UnitDisplay.Unit)UnitDisplay.Unit.WATT), 155, 128, 0x404040);
        this.field_73886_k.func_78276_b(UnitDisplay.getDisplay((double)this.tileEntity.getVoltageInput(null), (UnitDisplay.Unit)UnitDisplay.Unit.VOLTAGE), 155, 138, 0x404040);
        String color = "\u00a74";
        String status = LanguageUtility.getLocal((String)"gui.misc.idle");
        if (this.tileEntity.getEnergyHandler().checkExtract()) {
            color = "\u00a72";
            status = LanguageUtility.getLocal((String)"gui.radar.on");
        } else {
            status = LanguageUtility.getLocal((String)"gui.radar.nopower");
        }
        this.field_73886_k.func_78276_b(color + status, 155, 150, 0x404040);
    }

    public void func_73869_a(char par1, int par2) {
        super.func_73869_a(par1, par2);
        this.textFieldSafetyZone.func_73802_a(par1, par2);
        this.textFieldAlarmRange.func_73802_a(par1, par2);
        this.textFieldFrequency.func_73802_a(par1, par2);
        try {
            int newSafetyRadius;
            this.tileEntity.safetyRange = newSafetyRadius = Math.min(500, Math.max(0, Integer.parseInt(this.textFieldSafetyZone.func_73781_b())));
            PacketDispatcher.sendPacketToServer((Packet)ICBMCore.PACKET_TILE.getPacket((TileEntity)this.tileEntity, new Object[]{2, this.tileEntity.safetyRange}));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            int newAlarmRadius;
            this.tileEntity.alarmRange = newAlarmRadius = Math.min(500, Math.max(0, Integer.parseInt(this.textFieldAlarmRange.func_73781_b())));
            PacketDispatcher.sendPacketToServer((Packet)ICBMCore.PACKET_TILE.getPacket((TileEntity)this.tileEntity, new Object[]{3, this.tileEntity.alarmRange}));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            this.tileEntity.setFrequency(Integer.parseInt(this.textFieldFrequency.func_73781_b()));
            PacketDispatcher.sendPacketToServer((Packet)ICBMCore.PACKET_TILE.getPacket((TileEntity)this.tileEntity, new Object[]{4, this.tileEntity.getFrequency()}));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public void func_73864_a(int par1, int par2, int par3) {
        super.func_73864_a(par1, par2, par3);
        this.textFieldAlarmRange.func_73793_a(par1 - this.containerPosX, par2 - this.containerPosY, par3);
        this.textFieldSafetyZone.func_73793_a(par1 - this.containerPosX, par2 - this.containerPosY, par3);
        this.textFieldFrequency.func_73793_a(par1 - this.containerPosX, par2 - this.containerPosY, par3);
    }

    @Override
    protected void func_74185_a(float f, int mouseX, int mouseY) {
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(TEXTURE);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.containerPosX = (this.field_73880_f - this.field_74194_b) / 2;
        this.containerPosY = (this.field_73881_g - this.field_74195_c) / 2;
        this.func_73729_b(this.containerPosX, this.containerPosY, 0, 0, this.field_74194_b, this.field_74195_c);
        this.radarCenter = new Vector2((double)(this.containerPosX + this.field_74194_b / 3 - 10), (double)(this.containerPosY + this.field_74195_c / 2 + 4));
        this.radarMapRadius = 7.0422535f;
        this.info = "";
        this.info2 = "";
        if (this.tileEntity.getEnergyHandler().checkExtract()) {
            Vector2 maxPosition;
            Vector2 minPosition;
            Vector2 position;
            int range = 4;
            for (Entity entity : this.tileEntity.detectedEntities) {
                position = new Vector2(this.radarCenter.x + (entity.field_70165_t - (double)this.tileEntity.field_70329_l) / (double)this.radarMapRadius, this.radarCenter.y - (entity.field_70161_v - (double)this.tileEntity.field_70327_n) / (double)this.radarMapRadius);
                if (entity instanceof EntityMissile) {
                    if (this.tileEntity.isMissileGoingToHit((EntityMissile)entity)) {
                        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(TEXTURE_RED_DOT);
                    } else {
                        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(TEXTURE_YELLOW_DOT);
                    }
                } else {
                    FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(TEXTURE_YELLOW_DOT);
                }
                this.func_73729_b(position.intX(), position.intY(), 0, 0, 2, 2);
                minPosition = position.clone();
                minPosition.add((double)(-range));
                maxPosition = position.clone();
                maxPosition.add((double)range);
                if (!new Rectangle(minPosition, maxPosition).isIn(this.mousePosition)) continue;
                this.info = entity.func_70023_ak();
                if (entity instanceof EntityPlayer) {
                    this.info = "\u00a71" + this.info;
                }
                if (!(entity instanceof EntityMissile) || ((EntityMissile)entity).targetVector == null) continue;
                this.info2 = "(" + ((EntityMissile)entity).targetVector.intX() + ", " + ((EntityMissile)entity).targetVector.intZ() + ")";
            }
            range = 2;
            for (TileEntity jiQi : this.tileEntity.detectedTiles) {
                position = new Vector2(this.radarCenter.x + (double)((float)(jiQi.field_70329_l - this.tileEntity.field_70329_l) / this.radarMapRadius), this.radarCenter.y - (double)((float)(jiQi.field_70327_n - this.tileEntity.field_70327_n) / this.radarMapRadius));
                FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(TEXTURE_WHITE_DOT);
                this.func_73729_b(position.intX(), position.intY(), 0, 0, 2, 2);
                minPosition = position.clone();
                minPosition.add((double)(-range));
                maxPosition = position.clone();
                maxPosition.add((double)range);
                if (!new Rectangle(minPosition, maxPosition).isIn(this.mousePosition) || jiQi.func_70311_o() == null) continue;
                if (jiQi.func_70311_o() instanceof BlockICBMMachine) {
                    this.info = BlockICBMMachine.getJiQiMing(jiQi);
                    continue;
                }
                this.info = jiQi.func_70311_o().func_71931_t();
            }
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (Mouse.isInsideWindow() && Mouse.getEventButton() == -1) {
            this.mousePosition = new Vector2((double)(Mouse.getEventX() * this.field_73880_f / this.field_73882_e.field_71443_c), (double)(this.field_73881_g - Mouse.getEventY() * this.field_73881_g / this.field_73882_e.field_71440_d - 1));
            float difference = 500.0f / this.radarMapRadius;
            if (this.mousePosition.x > this.radarCenter.x - (double)difference && this.mousePosition.x < this.radarCenter.x + (double)difference && this.mousePosition.y > this.radarCenter.y - (double)difference && this.mousePosition.y < this.radarCenter.y + (double)difference) {
                int xDifference = (int)(this.mousePosition.x - this.radarCenter.x);
                int yDifference = (int)(this.mousePosition.y - this.radarCenter.y);
                int xBlockDistance = (int)((float)xDifference * this.radarMapRadius);
                int yBlockDistance = (int)((float)yDifference * this.radarMapRadius);
                this.mouseOverCoords = new Vector2((double)(this.tileEntity.field_70329_l + xBlockDistance), (double)(this.tileEntity.field_70327_n - yBlockDistance));
            }
        }
        if (!this.textFieldSafetyZone.func_73806_l()) {
            this.textFieldSafetyZone.func_73782_a(this.tileEntity.safetyRange + "");
        }
        if (!this.textFieldAlarmRange.func_73806_l()) {
            this.textFieldAlarmRange.func_73782_a(this.tileEntity.alarmRange + "");
        }
    }
}

