/*
 * Decompiled with CFR 0.152.
 */
package icbm.explosion.items;

import calclavia.api.mffs.fortron.FrequencyGrid;
import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.common.network.PacketDispatcher;
import icbm.Settings;
import icbm.core.ICBMCore;
import icbm.core.prefab.item.ItemICBMElectrical;
import icbm.explosion.ICBMExplosion;
import icbm.explosion.entities.EntityLightBeam;
import icbm.explosion.machines.launcher.TileLauncherPrefab;
import icbm.explosion.machines.launcher.TileLauncherScreen;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumMovingObjectType;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import resonant.api.blocks.IBlockFrequency;
import resonant.api.items.IItemFrequency;
import resonant.lib.network.IPacketReceiver;
import resonant.lib.utility.LanguageUtility;
import universalelectricity.api.item.ItemElectric;
import universalelectricity.api.vector.Vector3;

public class ItemLaserDesignator
extends ItemICBMElectrical
implements IItemFrequency,
IPacketReceiver {
    public static final int BAN_JING = Settings.DAO_DAN_ZUI_YUAN;
    public static final int YONG_DIAN_LIANG = 8000;

    public ItemLaserDesignator(int id) {
        super(id, "laserDesignator");
    }

    @Override
    public void func_77624_a(ItemStack itemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        super.func_77624_a(itemStack, par2EntityPlayer, par3List, par4);
        if (this.getFrequency(itemStack) > 0) {
            par3List.add(LanguageUtility.getLocal((String)"info.misc.freq") + " " + this.getFrequency(itemStack));
        } else {
            par3List.add(LanguageUtility.getLocal((String)"info.designator.noFreq"));
        }
    }

    public int getFrequency(ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            return 0;
        }
        return itemStack.field_77990_d.func_74762_e("frequency");
    }

    public void setFrequency(int frequency, ItemStack itemStack) {
        if (itemStack.field_77990_d == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.field_77990_d.func_74768_a("frequency", frequency);
    }

    public int getLauncherCountDown(ItemStack par1ItemStack) {
        if (par1ItemStack.field_77990_d == null) {
            return -1;
        }
        return par1ItemStack.field_77990_d.func_74762_e("countDown");
    }

    public void setLauncherCountDown(ItemStack par1ItemStack, int value) {
        if (par1ItemStack.field_77990_d == null) {
            par1ItemStack.func_77982_d(new NBTTagCompound());
        }
        par1ItemStack.field_77990_d.func_74768_a("countDown", value);
    }

    public int getLauncherCount(ItemStack par1ItemStack) {
        if (par1ItemStack.field_77990_d == null) {
            return 0;
        }
        return par1ItemStack.field_77990_d.func_74762_e("launcherCount");
    }

    public void setLauncherCount(ItemStack par1ItemStack, int value) {
        if (par1ItemStack.field_77990_d == null) {
            par1ItemStack.func_77982_d(new NBTTagCompound());
        }
        par1ItemStack.field_77990_d.func_74768_a("launcherCount", value);
    }

    public int getLauncherDelay(ItemStack par1ItemStack) {
        if (par1ItemStack.field_77990_d == null) {
            return 0;
        }
        return par1ItemStack.field_77990_d.func_74762_e("launcherDelay");
    }

    public void setLauncherDelay(ItemStack par1ItemStack, int value) {
        if (par1ItemStack.field_77990_d == null) {
            par1ItemStack.func_77982_d(new NBTTagCompound());
        }
        par1ItemStack.field_77990_d.func_74768_a("launcherDelay", value);
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity par3Entity, int par4, boolean par5) {
        super.func_77663_a(itemStack, world, par3Entity, par4, par5);
        if (!world.field_72995_K) {
            ArrayList<TileLauncherPrefab> connectedLaunchers = new ArrayList<TileLauncherPrefab>();
            if (this.getLauncherCountDown(itemStack) > 0 || this.getLauncherCount(itemStack) > 0) {
                Vector3 position = new Vector3(par3Entity.field_70165_t, par3Entity.field_70163_u, par3Entity.field_70161_v);
                for (IBlockFrequency blockFrequency : FrequencyGrid.instance().get(world, position, BAN_JING, this.getFrequency(itemStack))) {
                    TileLauncherPrefab missileLauncher;
                    if (!(blockFrequency instanceof TileLauncherPrefab) || !(missileLauncher = (TileLauncherPrefab)blockFrequency).canLaunch()) continue;
                    connectedLaunchers.add(missileLauncher);
                }
            }
            if (this.getLauncherCountDown(itemStack) > 0 && connectedLaunchers.size() > 0) {
                if (this.getLauncherCountDown(itemStack) % 20 == 0) {
                    ((EntityPlayer)par3Entity).func_71035_c(LanguageUtility.getLocal((String)"message.designator.callTime") + " " + (int)Math.floor(this.getLauncherCountDown(itemStack) / 20));
                }
                if (this.getLauncherCountDown(itemStack) == 1) {
                    this.setLauncherCount(itemStack, connectedLaunchers.size());
                    this.setLauncherDelay(itemStack, 0);
                    ((EntityPlayer)par3Entity).func_71035_c(LanguageUtility.getLocal((String)"message.designator.blast"));
                }
                this.setLauncherCountDown(itemStack, this.getLauncherCountDown(itemStack) - 1);
            }
            if (this.getLauncherCount(itemStack) > 0 && this.getLauncherCount(itemStack) <= connectedLaunchers.size() && connectedLaunchers.size() > 0) {
                if (this.getLauncherDelay(itemStack) % 40 == 0) {
                    ((TileLauncherPrefab)((Object)connectedLaunchers.get(this.getLauncherCount(itemStack) - 1))).launch();
                    this.setLauncherCount(itemStack, this.getLauncherCount(itemStack) - 1);
                }
                if (this.getLauncherCount(itemStack) == 0) {
                    this.setLauncherDelay(itemStack, 0);
                    connectedLaunchers.clear();
                }
                this.setLauncherDelay(itemStack, this.getLauncherDelay(itemStack) + 1);
            }
        }
    }

    public boolean func_77648_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, World par3World, int x, int y, int z, int par7, float par8, float par9, float par10) {
        TileEntity tileEntity;
        if (!par3World.field_72995_K && (tileEntity = par3World.func_72796_p(x, y, z)) != null && tileEntity instanceof TileLauncherPrefab) {
            TileLauncherPrefab missileLauncher = (TileLauncherPrefab)tileEntity;
            if (missileLauncher.getFrequency() > 0) {
                this.setFrequency(missileLauncher.getFrequency(), par1ItemStack);
                par2EntityPlayer.func_71035_c(LanguageUtility.getLocal((String)"message.designator.setFreq") + " " + this.getFrequency(par1ItemStack));
            } else {
                par2EntityPlayer.func_71035_c(LanguageUtility.getLocal((String)"message.designator.failFreq"));
            }
        }
        return false;
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World world, EntityPlayer player) {
        MovingObjectPosition objectMouseOver;
        if (world.field_72995_K && (objectMouseOver = player.func_70614_a((double)(BAN_JING * 2), 1.0f)) != null && objectMouseOver.field_72313_a == EnumMovingObjectType.TILE) {
            int blockId = world.func_72798_a(objectMouseOver.field_72311_b, objectMouseOver.field_72312_c, objectMouseOver.field_72309_d);
            int blockMetadata = world.func_72805_g(objectMouseOver.field_72311_b, objectMouseOver.field_72312_c, objectMouseOver.field_72309_d);
            if (this.getLauncherCountDown(par1ItemStack) > 0) {
                return par1ItemStack;
            }
            if (blockId == ICBMExplosion.blockMachine.field_71990_ca) {
                return par1ItemStack;
            }
            int airStrikeFreq = this.getFrequency(par1ItemStack);
            if (airStrikeFreq > 0) {
                if (this.getEnergy(par1ItemStack) >= 8000L) {
                    Vector3 position = new Vector3(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                    boolean doAirStrike = false;
                    int errorCount = 0;
                    for (IBlockFrequency blockFrequency : FrequencyGrid.instance().get(world, position, BAN_JING, airStrikeFreq)) {
                        if (!(blockFrequency instanceof TileLauncherPrefab)) continue;
                        TileLauncherPrefab missileLauncher = (TileLauncherPrefab)blockFrequency;
                        double yHit = objectMouseOver.field_72312_c;
                        if (missileLauncher instanceof TileLauncherScreen) {
                            yHit = missileLauncher.getTarget() != null ? missileLauncher.getTarget().y : 0.0;
                        }
                        missileLauncher.setTarget(new Vector3((double)objectMouseOver.field_72311_b, yHit, (double)objectMouseOver.field_72309_d));
                        PacketDispatcher.sendPacketToServer((Packet)ICBMCore.PACKET_TILE.getPacket((TileEntity)missileLauncher, new Object[]{2, missileLauncher.getTarget().intX(), missileLauncher.getTarget().intY(), missileLauncher.getTarget().intZ()}));
                        if (missileLauncher.canLaunch()) {
                            doAirStrike = true;
                            continue;
                        }
                        player.func_71035_c("#" + ++errorCount + " Missile Launcher Error: " + missileLauncher.getStatus());
                    }
                    if (doAirStrike && this.getLauncherCountDown(par1ItemStack) >= 0) {
                        PacketDispatcher.sendPacketToServer((Packet)ICBMCore.PACKET_ITEM.getPacket(player, new Object[]{objectMouseOver.field_72311_b, objectMouseOver.field_72312_c, objectMouseOver.field_72309_d}));
                        player.func_71035_c(LanguageUtility.getLocal((String)"message.designator.callBlast"));
                    }
                } else {
                    player.func_71035_c(LanguageUtility.getLocal((String)"message.designator.nopower"));
                }
            } else {
                player.func_71035_c(LanguageUtility.getLocal((String)"message.designator.noFreq"));
            }
        }
        return par1ItemStack;
    }

    public long getVoltage(ItemStack itemStack) {
        return 30L;
    }

    public long getEnergyCapacity(ItemStack itemStack) {
        return 80000L;
    }

    public void onReceivePacket(ByteArrayDataInput data, EntityPlayer player, Object ... extra) {
        ItemStack itemStack = (ItemStack)extra[0];
        Vector3 position = new Vector3((double)data.readInt(), (double)data.readInt(), (double)data.readInt());
        ((ItemLaserDesignator)ICBMExplosion.itemLaserDesignator).setLauncherCountDown(itemStack, 119);
        player.field_70170_p.func_72908_a((double)position.intX(), (double)player.field_70170_p.func_72976_f(position.intX(), position.intZ()), (double)position.intZ(), "icbm:airstrike", 5.0f, (1.0f + (player.field_70170_p.field_73012_v.nextFloat() - player.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        player.field_70170_p.func_72838_d((Entity)new EntityLightBeam(player.field_70170_p, position, 100, 0.0f, 1.0f, 0.0f));
        if (ICBMExplosion.itemRadarGun instanceof ItemElectric) {
            ((ItemElectric)ICBMExplosion.itemRadarGun).discharge(itemStack, 8000L, true);
        }
    }
}

