/*
 * Decompiled with CFR 0.152.
 */
package icbm.explosion.machines;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import icbm.core.prefab.BlockICBM;
import icbm.explosion.ICBMExplosion;
import icbm.explosion.machines.TileCruiseLauncher;
import icbm.explosion.machines.TileEMPTower;
import icbm.explosion.machines.TileMissileCoordinator;
import icbm.explosion.machines.TileRadarStation;
import icbm.explosion.machines.launcher.TileLauncherBase;
import icbm.explosion.machines.launcher.TileLauncherFrame;
import icbm.explosion.machines.launcher.TileLauncherScreen;
import icbm.explosion.render.tile.BlockRenderHandler;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import resonant.api.IRedstoneReceptor;
import resonant.api.IRotatable;
import resonant.api.ITier;
import resonant.core.ResonantEngine;
import resonant.lib.multiblock.IBlockActivate;
import resonant.lib.multiblock.IMultiBlock;
import resonant.lib.utility.LanguageUtility;
import universalelectricity.api.UniversalElectricity;

public class BlockICBMMachine
extends BlockICBM {
    public BlockICBMMachine(int id) {
        super(id, "machine", UniversalElectricity.machine);
    }

    public boolean func_71853_i() {
        return true;
    }

    public void func_71861_g(World par1World, int x, int y, int z) {
        this.isBeingPowered(par1World, x, y, z);
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase par5EntityLiving, ItemStack itemStack) {
        int angle = MathHelper.func_76128_c((double)((double)(par5EntityLiving.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        TileEntity tileEntity = world.func_72796_p(x, y, z);
        if (tileEntity instanceof IRotatable) {
            IRotatable rotatableEntity = (IRotatable)tileEntity;
            switch (angle) {
                case 0: {
                    rotatableEntity.setDirection(ForgeDirection.getOrientation((int)3));
                    break;
                }
                case 1: {
                    rotatableEntity.setDirection(ForgeDirection.getOrientation((int)4));
                    break;
                }
                case 2: {
                    rotatableEntity.setDirection(ForgeDirection.getOrientation((int)2));
                    break;
                }
                case 3: {
                    rotatableEntity.setDirection(ForgeDirection.getOrientation((int)5));
                }
            }
        }
        if (tileEntity instanceof IMultiBlock) {
            ResonantEngine.blockMulti.createMultiBlockStructure((IMultiBlock)tileEntity);
        }
    }

    public static boolean canBePlacedAt(World world, int x, int y, int z, int m, int side) {
        ForgeDirection d = ForgeDirection.getOrientation((int)side);
        if (m == 0) {
            for (int yp = 0; yp < 2; ++yp) {
                if (!world.func_72799_c(x + d.offsetX, y + yp, z + d.offsetZ)) {
                    return false;
                }
                if (world.func_72799_c(x - d.offsetX, y + yp, z - d.offsetZ)) continue;
                return false;
            }
            return world.func_72799_c(x, y, z);
        }
        if (m == 2) {
            return world.func_72803_f(x, y - 1, z).func_76220_a() && world.func_72799_c(x, y, z) && world.func_72799_c(x, y + 1, z) && world.func_72799_c(x, y + 2, z);
        }
        if (m == 4) {
            return world.func_72799_c(x, y, z) && world.func_72799_c(x, y + 1, z);
        }
        return world.func_72803_f(x, y - 1, z).func_76220_a();
    }

    public boolean func_71854_d(World world, int x, int y, int z) {
        int direction = 0;
        TileEntity tileEntity = world.func_72796_p(x, y, z);
        if (tileEntity instanceof IRotatable) {
            direction = ((IRotatable)tileEntity).getDirection().ordinal();
        }
        return BlockICBMMachine.canBePlacedAt(world, x, y, z, world.func_72805_g(x, y, z), direction);
    }

    public void func_71863_a(World par1World, int x, int y, int z, int par5) {
        this.isBeingPowered(par1World, x, y, z);
    }

    public boolean onMachineActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity;
        if (player.field_71071_by.func_70448_g() != null) {
            if (player.field_71071_by.func_70448_g().field_77993_c == ICBMExplosion.itemLaserDesignator.field_77779_bT) {
                return false;
            }
            if (player.field_71071_by.func_70448_g().field_77993_c == ICBMExplosion.itemRadarGun.field_77779_bT) {
                return false;
            }
        }
        if ((tileEntity = world.func_72796_p(x, y, z)) != null && tileEntity instanceof IBlockActivate) {
            return ((IBlockActivate)tileEntity).onActivated(player);
        }
        return false;
    }

    public boolean onUseWrench(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        return this.onMachineActivated(world, x, y, z, player, side, hitX, hitY, hitZ);
    }

    public void isBeingPowered(World world, int x, int y, int z) {
        int metadata = world.func_72805_g(x, y, z);
        TileEntity tileEntity = world.func_72796_p(x, y, z);
        if (tileEntity instanceof IRedstoneReceptor) {
            if (world.func_72864_z(x, y, z)) {
                ((IRedstoneReceptor)tileEntity).onPowerOn();
            } else {
                ((IRedstoneReceptor)tileEntity).onPowerOff();
            }
        }
    }

    public boolean func_71886_c() {
        return false;
    }

    public void func_71852_a(World world, int x, int y, int z, int par5, int par6) {
        int metadata = world.func_72805_g(x, y, z);
        Random random = new Random();
        TileEntity tileEntity = world.func_72796_p(x, y, z);
        if (tileEntity != null) {
            int itemMetadata = 0;
            itemMetadata = tileEntity instanceof ITier ? ((ITier)tileEntity).getTier() + metadata * 3 : 9 + metadata - 3;
            this.func_71929_a(world, x, y, z, new ItemStack(ICBMExplosion.blockMachine, 1, itemMetadata));
            if (tileEntity instanceof IMultiBlock) {
                ResonantEngine.blockMulti.destroyMultiBlockStructure((IMultiBlock)tileEntity);
            }
        }
        super.func_71852_a(world, x, y, z, par5, par6);
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (MachineData.get(metadata) != null) {
            try {
                return MachineData.get((int)metadata).tileEntity.newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public int func_71925_a(Random par1Random) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_71857_b() {
        return BlockRenderHandler.ID;
    }

    public boolean func_71926_d() {
        return false;
    }

    public void func_71879_a(int par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (int i = 0; i < MachineData.values().length + 6; ++i) {
            par3List.add(new ItemStack((Block)this, 1, i));
        }
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        TileEntity tileEntity = world.func_72796_p(x, y, z);
        return new ItemStack(ICBMExplosion.blockMachine, 1, BlockICBMMachine.getJiQiID(tileEntity));
    }

    @Override
    public int func_71899_b(int metadata) {
        return metadata;
    }

    public static int getJiQiID(TileEntity tileEntity) {
        int itemMetadata = 0;
        if (tileEntity != null) {
            int metadata = tileEntity.func_70322_n();
            itemMetadata = tileEntity instanceof ITier ? ((ITier)tileEntity).getTier() + metadata * 3 : 9 + metadata - 3;
        }
        return itemMetadata;
    }

    public static String getJiQiMing(TileEntity tileEntity) {
        return LanguageUtility.getLocal((String)("icbm.machine." + BlockICBMMachine.getJiQiID(tileEntity) + ".name"));
    }

    public static enum MachineData {
        LauncherBase(TileLauncherBase.class),
        LauncherScreen(TileLauncherScreen.class),
        LauncherFrame(TileLauncherFrame.class),
        RadarStation(TileRadarStation.class),
        EmpTower(TileEMPTower.class),
        CruiseLauncher(TileCruiseLauncher.class),
        MissileCoordinator(TileMissileCoordinator.class);

        public Class<? extends TileEntity> tileEntity;

        private MachineData(Class<? extends TileEntity> tileEntity) {
            this.tileEntity = tileEntity;
        }

        public static MachineData get(int id) {
            if (id < MachineData.values().length && id >= 0) {
                return MachineData.values()[id];
            }
            return null;
        }
    }
}

