/*
 * Decompiled with CFR 0.152.
 */
package icbm.explosion.machines;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import icbm.core.prefab.BlockICBM;
import icbm.explosion.ICBMExplosion;
import icbm.explosion.machines.TileMissileAssembler;
import icbm.explosion.render.tile.BlockRenderHandler;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import resonant.core.ResonantEngine;
import resonant.lib.multiblock.IBlockActivate;
import resonant.lib.multiblock.IMultiBlock;
import resonant.lib.multiblock.TileMultiBlockPart;
import universalelectricity.api.UniversalElectricity;
import universalelectricity.api.vector.IVector3;
import universalelectricity.api.vector.Vector3;

public class BlockMissileAssembler
extends BlockICBM {
    public BlockMissileAssembler(int id) {
        super(id, "missileAssembler", UniversalElectricity.machine);
        this.func_111022_d("icbm:machine");
    }

    public boolean func_71926_d() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_71886_c() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_71857_b() {
        return BlockRenderHandler.ID;
    }

    public TileEntity func_72274_a(World var1) {
        return new TileMissileAssembler();
    }

    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        super.func_71860_a(world, z, y, z, entityLiving, itemStack);
        TileEntity tileEntity = world.func_72796_p(x, y, z);
        if (tileEntity instanceof IMultiBlock) {
            ResonantEngine.blockMulti.createMultiBlockStructure((IMultiBlock)tileEntity);
        }
    }

    public boolean func_71854_d(World world, int x, int y, int z) {
        TileEntity entity = world.func_72796_p(x, y, z);
        if (entity instanceof TileMissileAssembler) {
            ForgeDirection s = ((TileMissileAssembler)entity).placedSide;
            Vector3 vec = new Vector3(entity).translate((IVector3)new Vector3((double)(-s.offsetX), (double)(-s.offsetY), (double)(-s.offsetZ)));
            return Block.field_71973_m[vec.getBlockID((IBlockAccess)world)] != null;
        }
        return false;
    }

    public static boolean canPlaceBlockAt(World world, int x, int y, int z, ForgeDirection placeSide, int rot) {
        Vector3 pos = new Vector3((double)x, (double)y, (double)z);
        Block block = Block.field_71973_m[pos.getBlockID((IBlockAccess)world)];
        if (block == null || block.isBlockReplaceable(world, x, y, z)) {
            Vector3[] vecs;
            for (Vector3 vec : vecs = TileMissileAssembler.getMultiBlockVectors(placeSide, (byte)rot)) {
                block = Block.field_71973_m[pos.clone().translate((IVector3)vec).getBlockID((IBlockAccess)world)];
                if (block == null || block.isBlockReplaceable(world, x, y, z)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean canRotateBlockTo(World world, int x, int y, int z, ForgeDirection placeSide, int rot) {
        Vector3 pos = new Vector3((double)x, (double)y, (double)z);
        Block block = Block.field_71973_m[pos.getBlockID((IBlockAccess)world)];
        if (block == null || block.isBlockReplaceable(world, x, y, z) || block.field_71990_ca == ICBMExplosion.blockMissileAssembler.field_71990_ca) {
            Vector3[] vecs;
            for (Vector3 vec : vecs = TileMissileAssembler.getMultiBlockVectors(placeSide, (byte)rot)) {
                block = Block.field_71973_m[pos.clone().translate((IVector3)vec).getBlockID((IBlockAccess)world)];
                boolean isNotSubBlock = true;
                if (pos.clone().translate((IVector3)vec).getTileEntity((IBlockAccess)world) instanceof TileMultiBlockPart) {
                    Vector3 main = ((TileMultiBlockPart)pos.clone().translate((IVector3)vec).getTileEntity((IBlockAccess)world)).getMainBlock();
                    boolean bl = isNotSubBlock = !main.equals((Object)new Vector3((double)x, (double)y, (double)z));
                }
                if (block == null || block.isBlockReplaceable(world, x, y, z) || !isNotSubBlock) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean onSneakUseWrench(World world, int x, int y, int z, EntityPlayer entityPlayer, int s, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        byte rotation = 0;
        ForgeDirection side = ForgeDirection.UP;
        TileEntity entity = world.func_72796_p(x, y, z);
        if (entity instanceof TileMissileAssembler) {
            rotation = ((TileMissileAssembler)entity).rotationSide;
            side = ((TileMissileAssembler)entity).placedSide;
            if (BlockMissileAssembler.canRotateBlockTo(world, x, y, z, side, rotation = rotation == 3 ? (byte)0 : (byte)(rotation + 1))) {
                NBTTagCompound tag = new NBTTagCompound();
                ((TileMissileAssembler)entity).rotating = true;
                Vector3[] positions = ((TileMissileAssembler)entity).getMultiBlockVectors();
                ((TileMissileAssembler)entity).setRotation(rotation);
                ((TileMissileAssembler)entity).func_70310_b(tag);
                for (Vector3 position : positions) {
                    new Vector3(entity).translate((IVector3)position).setBlock(entity.field_70331_k, 0);
                }
                world.func_94575_c(x, y, z, this.field_71990_ca);
                entity = world.func_72796_p(x, y, z);
                ((TileMissileAssembler)entity).func_70307_a(tag);
                ResonantEngine.blockMulti.createMultiBlockStructure((IMultiBlock)entity);
                ((TileMissileAssembler)entity).rotating = false;
                world.func_72845_h(x, y, z);
                return true;
            }
            if (BlockMissileAssembler.canRotateBlockTo(world, x, y, z, side, rotation = rotation == 3 ? (byte)0 : (byte)(rotation + 1))) {
                NBTTagCompound tag = new NBTTagCompound();
                ((TileMissileAssembler)entity).rotating = true;
                Vector3[] positions = ((TileMissileAssembler)entity).getMultiBlockVectors();
                ((TileMissileAssembler)entity).setRotation(rotation);
                ((TileMissileAssembler)entity).func_70310_b(tag);
                for (Vector3 position : positions) {
                    new Vector3(entity).translate((IVector3)position).setBlock(entity.field_70331_k, 0);
                }
                world.func_94575_c(x, y, z, this.field_71990_ca);
                entity = world.func_72796_p(x, y, z);
                ((TileMissileAssembler)entity).func_70307_a(tag);
                ResonantEngine.blockMulti.createMultiBlockStructure((IMultiBlock)entity);
                ((TileMissileAssembler)entity).rotating = false;
                world.func_72845_h(x, y, z);
                return true;
            }
        }
        return false;
    }

    public int func_71925_a(Random par1Random) {
        return 0;
    }

    public void func_71852_a(World world, int x, int y, int z, int par5, int par6) {
        TileEntity entity = world.func_72796_p(x, y, z);
        if (!world.field_72995_K && entity instanceof TileMissileAssembler) {
            if (!((TileMissileAssembler)entity).rotating) {
                this.func_71929_a(world, x, y, z, new ItemStack(ICBMExplosion.blockMissileAssembler, 1, 0));
            }
            ResonantEngine.blockMulti.destroyMultiBlockStructure((IMultiBlock)world.func_72796_p(x, y, z));
        }
        super.func_71852_a(world, x, y, z, par5, par6);
    }

    public boolean onMachineActivated(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity = world.func_72796_p(x, y, z);
        if (tileEntity != null && tileEntity instanceof IBlockActivate) {
            return ((IBlockActivate)tileEntity).onActivated(player);
        }
        return false;
    }
}

