/*
 * Decompiled with CFR 0.152.
 */
package icbm.explosion.machines;

import com.google.common.io.ByteArrayDataInput;
import dan200.computercraft.api.peripheral.IPeripheral;
import icbm.core.ICBMCore;
import icbm.explosion.ICBMExplosion;
import icbm.explosion.entities.EntityMissile;
import icbm.explosion.ex.Ex;
import icbm.explosion.explosive.ExplosiveRegistry;
import icbm.explosion.items.ItemMissile;
import icbm.explosion.machines.launcher.TileLauncherPrefab;
import java.io.IOException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import resonant.api.explosion.ExplosionEvent;
import resonant.api.explosion.ExplosiveType;
import resonant.api.explosion.IExplosive;
import resonant.api.explosion.ILauncherContainer;
import resonant.api.explosion.ILauncherController;
import resonant.api.explosion.IMissile;
import resonant.api.explosion.LauncherType;
import resonant.lib.multiblock.IBlockActivate;
import resonant.lib.network.IPacketReceiver;
import resonant.lib.utility.LanguageUtility;
import universalelectricity.api.energy.EnergyStorageHandler;
import universalelectricity.api.vector.IVector3;
import universalelectricity.api.vector.Vector3;

public class TileCruiseLauncher
extends TileLauncherPrefab
implements IBlockActivate,
IInventory,
ILauncherContainer,
IPacketReceiver {
    public IMissile daoDan = null;
    public float rotationYaw = 0.0f;
    public float rotationPitch = 0.0f;
    private ItemStack[] containingItems = new ItemStack[2];

    public TileCruiseLauncher() {
        this.targetPos = new Vector3();
        this.setEnergyHandler(new EnergyStorageHandler(100000000L));
    }

    public int func_70302_i_() {
        return this.containingItems.length;
    }

    public ItemStack func_70301_a(int par1) {
        return this.containingItems[par1];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.containingItems[par1] != null) {
            if (this.containingItems[par1].field_77994_a <= par2) {
                ItemStack var3 = this.containingItems[par1];
                this.containingItems[par1] = null;
                return var3;
            }
            ItemStack var3 = this.containingItems[par1].func_77979_a(par2);
            if (this.containingItems[par1].field_77994_a == 0) {
                this.containingItems[par1] = null;
            }
            return var3;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.containingItems[par1] != null) {
            ItemStack var2 = this.containingItems[par1];
            this.containingItems[par1] = null;
            return var2;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        this.containingItems[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String getStatus() {
        String color = "\u00a74";
        String status = LanguageUtility.getLocal((String)"gui.misc.idle");
        if (!this.getEnergyHandler().isFull()) {
            status = LanguageUtility.getLocal((String)"gui.launcherCruise.statusNoPower");
        } else if (this.daoDan == null) {
            status = LanguageUtility.getLocal((String)"gui.launcherCruise.statusEmpty");
        } else if (this.targetPos == null) {
            status = LanguageUtility.getLocal((String)"gui.launcherCruise.statusInvalid");
        } else {
            color = "\u00a72";
            status = LanguageUtility.getLocal((String)"gui.launcherCruise.statusReady");
        }
        return color + status;
    }

    public String func_70303_b() {
        return LanguageUtility.getLocal((String)"gui.launcherCruise.name");
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        this.discharge(this.containingItems[1]);
        if (this.getYawFromTarget() - this.rotationYaw != 0.0f) {
            this.rotationYaw = (float)((double)this.rotationYaw + (double)(this.getYawFromTarget() - this.rotationYaw) * 0.1);
        }
        if (this.getPitchFromTarget() - this.rotationPitch != 0.0f) {
            this.rotationPitch = (float)((double)this.rotationPitch + (double)(this.getPitchFromTarget() - this.rotationPitch) * 0.1);
        }
        if (!this.field_70331_k.field_72995_K) {
            this.setMissile();
            if (this.ticks % 100L == 0L && this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n)) {
                this.launch();
            }
        }
    }

    public void placeMissile(ItemStack itemStack) {
        this.containingItems[0] = itemStack;
    }

    public void setMissile() {
        if (!this.field_70331_k.field_72995_K) {
            int haoMa;
            if (this.containingItems[0] != null && this.containingItems[0].func_77973_b() instanceof ItemMissile && ExplosiveRegistry.get(haoMa = this.containingItems[0].func_77960_j()) instanceof Ex) {
                Ex missile = (Ex)ExplosiveRegistry.get(haoMa);
                ExplosionEvent.ExplosivePreDetonationEvent evt = new ExplosionEvent.ExplosivePreDetonationEvent(this.field_70331_k, (double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, ExplosiveType.AIR, (IExplosive)missile);
                MinecraftForge.EVENT_BUS.post((Event)evt);
                if (!evt.isCanceled()) {
                    if (this.daoDan == null && missile.isCruise() && missile.getTier() <= 3) {
                        Vector3 startingPosition = new Vector3((double)((float)this.field_70329_l + 0.5f), (double)((float)this.field_70330_m + 0.2f), (double)((float)this.field_70327_n + 0.5f));
                        this.daoDan = new EntityMissile(this.field_70331_k, startingPosition, new Vector3((TileEntity)this), haoMa);
                        this.field_70331_k.func_72838_d((Entity)this.daoDan);
                        return;
                    }
                    if (this.daoDan != null && this.daoDan.getExplosiveType().getID() == haoMa) {
                        return;
                    }
                }
            }
            if (this.daoDan != null) {
                ((Entity)this.daoDan).func_70106_y();
            }
            this.daoDan = null;
        }
    }

    public Packet func_70319_e() {
        return ICBMCore.PACKET_TILE.getPacket((TileEntity)this, new Object[]{0, this.getEnergyHandler().getEnergy(), this.getFrequency(), this.targetPos.intX(), this.targetPos.intY(), this.targetPos.intZ()});
    }

    @Override
    protected void onReceivePacket(int id, ByteArrayDataInput data, EntityPlayer player, Object ... extra) throws IOException {
        super.onReceivePacket(id, data, player, extra);
        try {
            switch (id) {
                case 0: {
                    this.getEnergyHandler().setEnergy(data.readLong());
                    this.setFrequency(data.readInt());
                    this.targetPos = new Vector3((double)data.readInt(), (double)data.readInt(), (double)data.readInt());
                    break;
                }
                case 1: {
                    this.setFrequency(data.readInt());
                    break;
                }
                case 2: {
                    this.targetPos = new Vector3((double)data.readInt(), (double)data.readInt(), (double)data.readInt());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private float getPitchFromTarget() {
        double distance = Math.sqrt((this.targetPos.x - (double)this.field_70329_l) * (this.targetPos.x - (double)this.field_70329_l) + (this.targetPos.z - (double)this.field_70327_n) * (this.targetPos.z - (double)this.field_70327_n));
        return (float)Math.toDegrees(Math.atan((this.targetPos.y - (double)((float)this.field_70330_m + 0.5f)) / distance));
    }

    private float getYawFromTarget() {
        double xDifference = this.targetPos.x - (double)((float)this.field_70329_l + 0.5f);
        double yDifference = this.targetPos.z - (double)((float)this.field_70327_n + 0.5f);
        return (float)Math.toDegrees(Math.atan2(yDifference, xDifference));
    }

    public boolean canLaunch() {
        Ex missile;
        return this.daoDan != null && this.containingItems[0] != null && (missile = (Ex)ExplosiveRegistry.get(this.containingItems[0].func_77960_j())) != null && missile.getID() == this.daoDan.getExplosiveType().getID() && missile.isCruise() && missile.getTier() <= 3 && this.getEnergyHandler().isFull() && !this.isTooClose(this.targetPos);
    }

    public void launch() {
        if (this.canLaunch()) {
            this.func_70298_a(0, 1);
            this.setEnergy(ForgeDirection.UNKNOWN, 0L);
            this.daoDan.launch(this.targetPos);
            this.daoDan = null;
        }
    }

    public boolean isTooClose(Vector3 target) {
        return Vector3.distance((Vector3)new Vector3((double)this.field_70329_l, 0.0, (double)this.field_70327_n), (IVector3)new Vector3(target.x, 0.0, target.z)) < 8.0;
    }

    @Override
    public void func_70307_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70307_a(par1NBTTagCompound);
        NBTTagList var2 = par1NBTTagCompound.func_74761_m("Items");
        this.containingItems = new ItemStack[this.func_70302_i_()];
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = (NBTTagCompound)var2.func_74743_b(var3);
            byte var5 = var4.func_74771_c("Slot");
            if (var5 < 0 || var5 >= this.containingItems.length) continue;
            this.containingItems[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70310_b(par1NBTTagCompound);
        NBTTagList var2 = new NBTTagList();
        for (int var3 = 0; var3 < this.containingItems.length; ++var3) {
            if (this.containingItems[var3] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)var3);
            this.containingItems[var3].func_77955_b(var4);
            var2.func_74742_a((NBTBase)var4);
        }
        par1NBTTagCompound.func_74782_a("Items", (NBTBase)var2);
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) != this ? false : par1EntityPlayer.func_70092_e((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) <= 64.0;
    }

    public boolean onActivated(EntityPlayer player) {
        if (player.field_71071_by.func_70448_g() != null) {
            if (player.field_71071_by.func_70448_g().func_77973_b() instanceof ItemMissile) {
                if (this.func_70301_a(0) == null) {
                    this.func_70299_a(0, player.field_71071_by.func_70448_g());
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                    }
                    return true;
                }
                ItemStack player_held = player.field_71071_by.func_70448_g();
                if (!player.field_71075_bZ.field_75098_d) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, this.func_70301_a(0));
                }
                this.func_70299_a(0, player_held);
                return true;
            }
        } else if (this.func_70301_a(0) != null) {
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, this.func_70301_a(0));
            this.func_70299_a(0, null);
            return true;
        }
        player.openGui((Object)ICBMExplosion.instance, 0, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        return true;
    }

    public LauncherType getLauncherType() {
        return LauncherType.CRUISE;
    }

    public boolean func_94042_c() {
        return true;
    }

    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        Ex missile;
        return itemStack != null && itemStack.func_77973_b() instanceof ItemMissile && this.func_70301_a(slotID) == null && ExplosiveRegistry.get(itemStack.func_77960_j()) instanceof Ex && (missile = (Ex)ExplosiveRegistry.get(itemStack.func_77960_j())).isCruise() && missile.getTier() <= 3;
    }

    public void setContainingMissile(IMissile missile) {
        this.daoDan = missile;
    }

    public ILauncherController getController() {
        return this;
    }

    public IMissile getMissile() {
        return this.daoDan;
    }

    public IMissile getContainingMissile() {
        return this.daoDan;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)(this.field_70329_l - 1), (double)this.field_70330_m, (double)(this.field_70327_n - 1), (double)(this.field_70329_l + 1), (double)(this.field_70330_m + 1), (double)(this.field_70327_n + 1));
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public int[] getMissileSlots() {
        return new int[]{0};
    }

    @Override
    public boolean equals(IPeripheral other) {
        return this.equals(other);
    }
}

