/*
 * Decompiled with CFR 0.152.
 */
package icbm.explosion.machines;

import com.google.common.io.ByteArrayDataInput;
import icbm.core.ICBMCore;
import icbm.core.prefab.TileICBM;
import icbm.explosion.ICBMExplosion;
import icbm.explosion.explosive.blast.BlastEMP;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import resonant.api.IRedstoneReceptor;
import resonant.api.map.RadarRegistry;
import resonant.lib.multiblock.IBlockActivate;
import resonant.lib.multiblock.IMultiBlock;
import universalelectricity.api.energy.EnergyStorageHandler;
import universalelectricity.api.vector.Vector3;

public class TileEMPTower
extends TileICBM
implements IMultiBlock,
IRedstoneReceptor,
IBlockActivate {
    public static final int MAX_RADIUS = 150;
    public float xuanZhuan = 0.0f;
    private float xuanZhuanLu;
    private float prevXuanZhuanLu = 0.0f;
    public byte empMode = 0;
    private int cooldownTicks = 0;
    public int empRadius = 60;

    public TileEMPTower() {
        RadarRegistry.register((TileEntity)this);
        this.setEnergyHandler(new EnergyStorageHandler(0L));
        this.updateCapacity();
    }

    public void func_70313_j() {
        RadarRegistry.unregister((TileEntity)this);
        super.func_70313_j();
    }

    public void initiate() {
        this.updateCapacity();
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (this.inCurrentCooldown()) {
            --this.cooldownTicks;
        }
        if (this.ticks % 20L == 0L && this.getEnergyHandler().getEnergy() > 0L) {
            this.field_70331_k.func_72908_a((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, "icbm:machinehum", 0.5f, 0.85f * (float)this.getEnergyHandler().getEnergy() / (float)this.getEnergyHandler().getEnergyCapacity());
        }
        this.xuanZhuanLu = (float)(Math.pow(this.getEnergyHandler().getEnergy() / this.getEnergyHandler().getEnergyCapacity(), 2.0) * 0.5);
        this.xuanZhuan += this.xuanZhuanLu;
        if (this.xuanZhuan > 360.0f) {
            this.xuanZhuan = 0.0f;
        }
        this.prevXuanZhuanLu = this.xuanZhuanLu;
    }

    @Override
    public void onReceivePacket(int id, ByteArrayDataInput data, EntityPlayer player, Object ... extra) throws IOException {
        switch (id) {
            case 0: {
                this.getEnergyHandler().setEnergy(data.readLong());
                this.empRadius = data.readInt();
                this.empMode = data.readByte();
                break;
            }
            case 1: {
                this.empRadius = data.readInt();
                this.updateCapacity();
                break;
            }
            case 2: {
                this.empMode = data.readByte();
            }
        }
        super.onReceivePacket(id, data, player, extra);
    }

    public boolean inCurrentCooldown() {
        return this.cooldownTicks <= 120 && this.cooldownTicks > 0;
    }

    private void updateCapacity() {
        this.getEnergyHandler().setCapacity((long)Math.max(300000000 * (this.empRadius / 150), 1000000000));
        this.getEnergyHandler().setMaxTransfer(this.getEnergyHandler().getEnergyCapacity() / 50L);
    }

    public Packet func_70319_e() {
        return ICBMCore.PACKET_TILE.getPacket((TileEntity)this, new Object[]{0, this.getEnergyHandler().getEnergy(), this.empRadius, this.empMode});
    }

    public void func_70307_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70307_a(par1NBTTagCompound);
        this.empRadius = par1NBTTagCompound.func_74762_e("banJing");
        this.empMode = par1NBTTagCompound.func_74771_c("muoShi");
    }

    public void func_70310_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70310_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("banJing", this.empRadius);
        par1NBTTagCompound.func_74774_a("muoShi", this.empMode);
    }

    public void onPowerOn() {
        if (this.getEnergyHandler().isFull() && this.inCurrentCooldown()) {
            switch (this.empMode) {
                default: {
                    new BlastEMP(this.field_70331_k, null, this.field_70329_l, this.field_70330_m, this.field_70327_n, this.empRadius).setEffectBlocks().setEffectEntities().explode();
                    break;
                }
                case 1: {
                    new BlastEMP(this.field_70331_k, null, this.field_70329_l, this.field_70330_m, this.field_70327_n, this.empRadius).setEffectEntities().explode();
                    break;
                }
                case 2: {
                    new BlastEMP(this.field_70331_k, null, this.field_70329_l, this.field_70330_m, this.field_70327_n, this.empRadius).setEffectBlocks().explode();
                }
            }
            this.cooldownTicks = 120;
        }
    }

    public void onPowerOff() {
    }

    public boolean onActivated(EntityPlayer entityPlayer) {
        entityPlayer.openGui((Object)ICBMExplosion.instance, 0, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        return true;
    }

    public Vector3[] getMultiBlockVectors() {
        return new Vector3[]{new Vector3(0.0, 1.0, 0.0)};
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }
}

