/*
 * Decompiled with CFR 0.152.
 */
package icbm.explosion.machines;

import com.google.common.io.ByteArrayDataInput;
import icbm.core.ICBMCore;
import icbm.core.prefab.TileICBM;
import icbm.explosion.ICBMExplosion;
import icbm.explosion.entities.EntityMissile;
import icbm.explosion.items.ItemMissile;
import icbm.explosion.machines.BlockMissileAssembler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.ForgeDirection;
import resonant.api.IRotatable;
import resonant.api.ITier;
import resonant.lib.multiblock.IBlockActivate;
import resonant.lib.multiblock.IMultiBlock;
import resonant.lib.network.IPacketReceiver;
import resonant.lib.utility.LanguageUtility;
import universalelectricity.api.energy.EnergyStorageHandler;
import universalelectricity.api.vector.Vector3;

public class TileMissileAssembler
extends TileICBM
implements IMultiBlock,
ITier,
IRotatable,
IPacketReceiver,
IInventory,
IBlockActivate {
    public int tier = -1;
    public int missileID = -1;
    public ForgeDirection placedSide = ForgeDirection.UP;
    public byte rotationSide = 0;
    public boolean rotating = false;
    EntityMissile missile;
    private ItemStack[] containingItems = new ItemStack[1];

    public TileMissileAssembler() {
        this.setEnergyHandler(new EnergyStorageHandler());
    }

    public void initiate() {
        this.func_70296_d();
    }

    public Vector3[] getMultiBlockVectors() {
        return TileMissileAssembler.getMultiBlockVectors(this.placedSide, this.rotationSide);
    }

    public static Vector3[] getMultiBlockVectors(ForgeDirection side, byte rot) {
        if (side == ForgeDirection.UP || side == ForgeDirection.DOWN) {
            if (rot == 0 || rot == 2) {
                return new Vector3[]{new Vector3(1.0, 0.0, 0.0), new Vector3(-1.0, 0.0, 0.0)};
            }
            return new Vector3[]{new Vector3(0.0, 0.0, 1.0), new Vector3(0.0, 0.0, -1.0)};
        }
        if (rot == 0 || rot == 2) {
            if (side == ForgeDirection.NORTH || side == ForgeDirection.SOUTH) {
                return new Vector3[]{new Vector3(-1.0, 0.0, 0.0), new Vector3(1.0, 0.0, 0.0)};
            }
            if (side == ForgeDirection.EAST || side == ForgeDirection.WEST) {
                return new Vector3[]{new Vector3(0.0, 0.0, -1.0), new Vector3(0.0, 0.0, 1.0)};
            }
        }
        return new Vector3[]{new Vector3(0.0, 1.0, 0.0), new Vector3(0.0, -1.0, 0.0)};
    }

    public int getTier() {
        if (this.tier == -1) {
            this.setTier(this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n));
        }
        return this.tier;
    }

    public void setTier(int tier) {
        this.tier = tier & 3;
    }

    public ForgeDirection getDirection() {
        if (this.rotationSide == 0) {
            return ForgeDirection.NORTH;
        }
        if (this.rotationSide == 2) {
            return ForgeDirection.SOUTH;
        }
        if (this.rotationSide == 1) {
            return ForgeDirection.EAST;
        }
        return ForgeDirection.WEST;
    }

    public void setDirection(ForgeDirection direction) {
        int rot = 0;
        rot = direction == ForgeDirection.NORTH ? 0 : (direction == ForgeDirection.SOUTH ? 2 : (direction == ForgeDirection.EAST ? 1 : 3));
        if (BlockMissileAssembler.canRotateBlockTo(this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, this.placedSide, rot)) {
            this.rotationSide = (byte)rot;
            this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }

    public void setPlacedSide(ForgeDirection side) {
        this.placedSide = side;
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public void setRotation(byte rot) {
        this.rotationSide = rot;
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.rotationSide = nbt.func_74771_c("rotationSide");
        this.placedSide = ForgeDirection.getOrientation((int)nbt.func_74771_c("placedSide"));
        NBTTagList var2 = nbt.func_74761_m("Items");
        this.containingItems = new ItemStack[this.func_70302_i_()];
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = (NBTTagCompound)var2.func_74743_b(var3);
            byte var5 = var4.func_74771_c("Slot");
            if (var5 < 0 || var5 >= this.containingItems.length) continue;
            this.containingItems[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
        }
    }

    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74774_a("rotationSide", this.rotationSide);
        nbt.func_74774_a("placedSide", (byte)this.placedSide.ordinal());
        NBTTagList var2 = new NBTTagList();
        for (int var3 = 0; var3 < this.containingItems.length; ++var3) {
            if (this.containingItems[var3] == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)var3);
            this.containingItems[var3].func_77955_b(var4);
            var2.func_74742_a((NBTBase)var4);
        }
        nbt.func_74782_a("Items", (NBTBase)var2);
    }

    public boolean onActivated(EntityPlayer entityPlayer) {
        if (entityPlayer.field_71071_by.func_70448_g() != null && this.func_70301_a(0) == null && entityPlayer.field_71071_by.func_70448_g().func_77973_b() instanceof ItemMissile) {
            this.func_70299_a(0, entityPlayer.field_71071_by.func_70448_g());
            entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, null);
            this.func_70296_d();
            return true;
        }
        entityPlayer.openGui((Object)ICBMExplosion.instance, 0, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        return true;
    }

    @Override
    public void onReceivePacket(ByteArrayDataInput data, EntityPlayer player, Object ... extra) {
        byte id;
        if (this.field_70331_k.field_72995_K && (id = data.readByte()) == 0) {
            this.rotationSide = data.readByte();
            this.placedSide = ForgeDirection.getOrientation((int)data.readByte());
            this.missileID = data.readInt();
            this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
    }

    public Packet func_70319_e() {
        return ICBMCore.PACKET_TILE.getPacket((TileEntity)this, new Object[]{(byte)0, this.rotationSide, (byte)this.placedSide.ordinal(), this.missileID});
    }

    public void func_70296_d() {
        super.func_70296_d();
        if (!this.field_70331_k.field_72995_K) {
            this.missileID = this.func_70301_a(0) != null && this.func_70301_a(0).func_77973_b() instanceof ItemMissile ? this.func_70301_a(0).func_77960_j() : -1;
        }
        this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public int func_70302_i_() {
        return this.containingItems.length;
    }

    public ItemStack func_70301_a(int par1) {
        return this.containingItems[par1];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.containingItems[par1] != null) {
            if (this.containingItems[par1].field_77994_a <= par2) {
                ItemStack var3 = this.containingItems[par1];
                this.containingItems[par1] = null;
                return var3;
            }
            ItemStack var3 = this.containingItems[par1].func_77979_a(par2);
            if (this.containingItems[par1].field_77994_a == 0) {
                this.containingItems[par1] = null;
            }
            return var3;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.containingItems[par1] != null) {
            ItemStack var2 = this.containingItems[par1];
            this.containingItems[par1] = null;
            return var2;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        this.containingItems[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_70303_b() {
        return LanguageUtility.getLocal((String)"gui.assembler.name");
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n) != this ? false : par1EntityPlayer.func_70092_e((double)this.field_70329_l + 0.5, (double)this.field_70330_m + 0.5, (double)this.field_70327_n + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public boolean func_94042_c() {
        return true;
    }

    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        return itemStack.func_77973_b() instanceof ItemMissile;
    }
}

