/*
 * Decompiled with CFR 0.152.
 */
package icbm.explosion.machines;

import calclavia.api.mffs.fortron.FrequencyGrid;
import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import icbm.core.ICBMCore;
import icbm.core.implement.IChunkLoadHandler;
import icbm.core.prefab.TileFrequency;
import icbm.explosion.ICBMExplosion;
import icbm.explosion.entities.EntityMissile;
import icbm.explosion.machines.launcher.TileLauncherPrefab;
import icbm.explosion.machines.launcher.TileLauncherScreen;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.ForgeDirection;
import resonant.api.IRedstoneProvider;
import resonant.api.IRotatable;
import resonant.api.blocks.IBlockFrequency;
import resonant.api.items.IItemFrequency;
import resonant.api.map.IRadarDetectable;
import resonant.api.map.RadarRegistry;
import resonant.lib.multiblock.IBlockActivate;
import resonant.lib.network.IPacketReceiver;
import resonant.lib.network.PacketHandler;
import resonant.lib.utility.LanguageUtility;
import resonant.lib.utility.WrenchUtility;
import universalelectricity.api.energy.EnergyStorageHandler;
import universalelectricity.api.vector.IVector3;
import universalelectricity.api.vector.Vector2;
import universalelectricity.api.vector.Vector3;

public class TileRadarStation
extends TileFrequency
implements IChunkLoadHandler,
IPacketReceiver,
IRedstoneProvider,
IPeripheral,
IBlockFrequency,
IBlockActivate,
IRotatable {
    public static final int MAX_DETECTION_RANGE = 500;
    public static final float WATTS = 1.5f;
    private final Set<EntityPlayer> playersUsing = new HashSet<EntityPlayer>();
    public float rotation = 0.0f;
    public int alarmRange = 100;
    public int safetyRange = 50;
    public List<Entity> detectedEntities = new ArrayList<Entity>();
    public List<TileEntity> detectedTiles = new ArrayList<TileEntity>();
    public boolean emitAll = true;
    private List<EntityMissile> incomingMissiles = new ArrayList<EntityMissile>();
    private byte fangXiang = (byte)3;
    private ForgeChunkManager.Ticket ticket;

    public TileRadarStation() {
        RadarRegistry.register((TileEntity)this);
        this.setEnergyHandler(new EnergyStorageHandler(500L, 400L));
    }

    public void initiate() {
        super.initiate();
        this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n));
        this.chunkLoaderInit(ForgeChunkManager.requestTicket((Object)ICBMExplosion.instance, (World)this.field_70331_k, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL));
    }

    @Override
    public void chunkLoaderInit(ForgeChunkManager.Ticket ticket) {
        if (!this.field_70331_k.field_72995_K && this.ticket == null && ticket != null) {
            this.ticket = ticket;
            new Vector3((TileEntity)this).writeToNBT(this.ticket.getModData());
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkCoordIntPair)new ChunkCoordIntPair(this.field_70329_l >> 4, this.field_70327_n >> 4));
        }
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K) {
            if (this.ticks % 40L == 0L) {
                PacketHandler.sendPacketToClients((Packet)this.func_70319_e(), (World)this.field_70331_k, (IVector3)new Vector3((TileEntity)this), (double)35.0);
            } else if (this.ticks % 3L == 0L) {
                for (EntityPlayer player : this.playersUsing) {
                    PacketDispatcher.sendPacketToPlayer((Packet)this.getDescriptionPacket2(), (Player)((Player)player));
                }
            }
        }
        if (this.getEnergyHandler().checkExtract()) {
            this.rotation += 0.08f;
            if (this.rotation > 360.0f) {
                this.rotation = 0.0f;
            }
            if (!this.field_70331_k.field_72995_K) {
                this.getEnergyHandler().extractEnergy();
            }
            int prevDetectedEntities = this.detectedEntities.size();
            this.doScan();
            if (prevDetectedEntities != this.detectedEntities.size()) {
                this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.func_70311_o().field_71990_ca);
            }
            if (this.ticks % 20L == 0L && this.incomingMissiles.size() > 0) {
                for (IBlockFrequency blockFrequency : FrequencyGrid.instance().get()) {
                    if (!(blockFrequency instanceof TileLauncherPrefab)) continue;
                    TileLauncherPrefab launcher = (TileLauncherPrefab)blockFrequency;
                    Vector3 vector3 = new Vector3((TileEntity)this);
                    Vector3 vector32 = new Vector3((TileEntity)launcher);
                    if (!(vector3.distance((IVector3)vector32) < (double)this.alarmRange) || launcher.getFrequency() != this.getFrequency()) continue;
                    if (launcher instanceof TileLauncherScreen) {
                        double height = launcher.getTarget() != null ? launcher.getTarget().y : 0.0;
                        launcher.setTarget(new Vector3(this.incomingMissiles.get((int)0).field_70165_t, height, this.incomingMissiles.get((int)0).field_70161_v));
                        continue;
                    }
                    launcher.setTarget(new Vector3((Entity)this.incomingMissiles.get(0)));
                }
            }
        } else {
            if (this.detectedEntities.size() > 0) {
                this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.func_70311_o().field_71990_ca);
            }
            this.incomingMissiles.clear();
            this.detectedEntities.clear();
            this.detectedTiles.clear();
        }
        if (this.ticks % 40L == 0L) {
            this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.func_70311_o().field_71990_ca);
        }
    }

    private void doScan() {
        int i;
        this.incomingMissiles.clear();
        this.detectedEntities.clear();
        this.detectedTiles.clear();
        List entities = RadarRegistry.getEntitiesWithinRadius((Vector2)new Vector3((TileEntity)this).toVector2(), (int)500);
        block0: for (Entity entity : entities) {
            if (entity instanceof EntityMissile) {
                if (((EntityMissile)entity).feiXingTick <= -1) continue;
                if (!this.detectedEntities.contains(entity)) {
                    this.detectedEntities.add(entity);
                }
                if (!this.isMissileGoingToHit((EntityMissile)entity)) continue;
                if (this.incomingMissiles.size() > 0) {
                    double dist = new Vector3((TileEntity)this).distance((IVector3)new Vector3(entity));
                    for (i = 0; i < this.incomingMissiles.size(); ++i) {
                        EntityMissile daoDan = this.incomingMissiles.get(i);
                        Vector3 vector3 = new Vector3((TileEntity)this);
                        Vector3 vector32 = new Vector3((Entity)daoDan);
                        if (dist < vector3.distance((IVector3)vector32)) {
                            this.incomingMissiles.add(i, (EntityMissile)entity);
                            continue block0;
                        }
                        if (i != this.incomingMissiles.size() - 1) continue;
                        this.incomingMissiles.add((EntityMissile)entity);
                        continue block0;
                    }
                    continue;
                }
                this.incomingMissiles.add((EntityMissile)entity);
                continue;
            }
            this.detectedEntities.add(entity);
        }
        List players = this.field_70331_k.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)(this.field_70329_l - 500), (double)(this.field_70330_m - 500), (double)(this.field_70327_n - 500), (double)(this.field_70329_l + 500), (double)(this.field_70330_m + 500), (double)(this.field_70327_n + 500)));
        for (EntityPlayer player : players) {
            if (player == null) continue;
            boolean youHuoLuan = false;
            for (i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack itemStack = player.field_71071_by.func_70301_a(i);
                if (itemStack == null || !(itemStack.func_77973_b() instanceof IItemFrequency)) continue;
                youHuoLuan = true;
                break;
            }
            if (youHuoLuan) continue;
            this.detectedEntities.add((Entity)player);
        }
        for (TileEntity jiQi : RadarRegistry.getTileEntitiesInArea((Vector2)new Vector2((double)(this.field_70329_l - 500), (double)(this.field_70327_n - 500)), (Vector2)new Vector2((double)(this.field_70329_l + 500), (double)(this.field_70327_n + 500)))) {
            if (jiQi instanceof TileRadarStation) {
                if (((TileRadarStation)jiQi).getEnergyHandler().getEnergy() <= 0L) continue;
                this.detectedTiles.add(jiQi);
                continue;
            }
            if (this.detectedTiles instanceof IRadarDetectable) {
                if (!((IRadarDetectable)this.detectedTiles).canDetect((TileEntity)this)) continue;
                this.detectedTiles.add(jiQi);
                continue;
            }
            this.detectedTiles.add(jiQi);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isMissileGoingToHit(EntityMissile missile) {
        if (missile == null) return false;
        if (missile.targetVector == null) {
            return false;
        }
        Vector3 vector3 = new Vector3((Entity)missile);
        Vector2 vector2 = new Vector2((double)this.field_70329_l, (double)this.field_70327_n);
        if (!(Vector2.distance((Vector2)vector3.toVector2(), (Vector2)vector2) < (double)this.alarmRange)) return false;
        Vector2 vector22 = new Vector2((double)this.field_70329_l, (double)this.field_70327_n);
        if (!(Vector2.distance((Vector2)missile.targetVector.toVector2(), (Vector2)vector22) < (double)this.safetyRange)) return false;
        return true;
    }

    private Packet getDescriptionPacket2() {
        return ICBMCore.PACKET_TILE.getPacket((TileEntity)this, new Object[]{1, this.alarmRange, this.safetyRange, this.getFrequency()});
    }

    public Packet func_70319_e() {
        return ICBMCore.PACKET_TILE.getPacket((TileEntity)this, new Object[]{4, this.fangXiang, this.getEnergyHandler().getEnergy()});
    }

    @Override
    public void onReceivePacket(ByteArrayDataInput data, EntityPlayer player, Object ... extra) {
        try {
            int ID = data.readInt();
            if (ID == -1) {
                if (data.readBoolean()) {
                    PacketHandler.sendPacketToClients((Packet)this.getDescriptionPacket2(), (World)this.field_70331_k, (IVector3)new Vector3((TileEntity)this), (double)15.0);
                    this.playersUsing.add(player);
                } else {
                    this.playersUsing.remove(player);
                }
            } else if (this.field_70331_k.field_72995_K) {
                if (ID == 1) {
                    this.alarmRange = data.readInt();
                    this.safetyRange = data.readInt();
                    this.setFrequency(data.readInt());
                } else if (ID == 4) {
                    this.fangXiang = data.readByte();
                    this.getEnergyHandler().setEnergy(data.readLong());
                }
            } else if (!this.field_70331_k.field_72995_K) {
                if (ID == 2) {
                    this.safetyRange = data.readInt();
                } else if (ID == 3) {
                    this.alarmRange = data.readInt();
                } else if (ID == 4) {
                    this.setFrequency(data.readInt());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isPoweringTo(ForgeDirection side) {
        if (this.incomingMissiles.size() > 0) {
            if (this.emitAll) {
                return true;
            }
            for (EntityMissile incomingMissile : this.incomingMissiles) {
                Vector2 position = new Vector3((Entity)incomingMissile).toVector2();
                ForgeDirection missileTravelDirection = ForgeDirection.UNKNOWN;
                double closest = -1.0;
                for (int i = 2; i < 6; ++i) {
                    double dist = Vector2.distance((Vector2)position, (Vector2)new Vector2((double)(this.field_70329_l + ForgeDirection.getOrientation((int)i).offsetX), (double)(this.field_70327_n + ForgeDirection.getOrientation((int)i).offsetZ)));
                    if (!(dist < closest) && !(closest < 0.0)) continue;
                    missileTravelDirection = ForgeDirection.getOrientation((int)i);
                    closest = dist;
                }
                if (missileTravelDirection.getOpposite() != side) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isIndirectlyPoweringTo(ForgeDirection side) {
        return this.isPoweringTo(side);
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.safetyRange = nbt.func_74762_e("safetyBanJing");
        this.alarmRange = nbt.func_74762_e("alarmBanJing");
        this.emitAll = nbt.func_74767_n("emitAll");
        this.fangXiang = nbt.func_74771_c("fangXiang");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74768_a("safetyBanJing", this.safetyRange);
        nbt.func_74768_a("alarmBanJing", this.alarmRange);
        nbt.func_74757_a("emitAll", this.emitAll);
        nbt.func_74774_a("fangXiang", this.fangXiang);
    }

    public boolean onActivated(EntityPlayer entityPlayer) {
        if (entityPlayer.field_71071_by.func_70448_g() != null && WrenchUtility.isUsableWrench((EntityPlayer)entityPlayer, (ItemStack)entityPlayer.field_71071_by.func_70448_g(), (int)this.field_70329_l, (int)this.field_70330_m, (int)this.field_70327_n)) {
            if (!this.field_70331_k.field_72995_K) {
                this.emitAll = !this.emitAll;
                entityPlayer.func_71035_c(LanguageUtility.getLocal((String)"message.radar.redstone") + " " + this.emitAll);
            }
            return true;
        }
        entityPlayer.openGui((Object)ICBMExplosion.instance, 0, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        return true;
    }

    public String getType() {
        return "ICBMRadar";
    }

    public String[] getMethodNames() {
        return new String[]{"getEntities", "getBlocks"};
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws Exception {
        if (!this.getEnergyHandler().checkExtract()) {
            throw new Exception("Radar has insufficient electricity!");
        }
        HashMap<String, Double> returnArray = new HashMap<String, Double>();
        int count = 0;
        switch (method) {
            case 0: {
                List entities = RadarRegistry.getEntitiesWithinRadius((Vector2)new Vector3((TileEntity)this).toVector2(), (int)this.alarmRange);
                for (Entity entity : entities) {
                    returnArray.put("x_" + count, entity.field_70165_t);
                    returnArray.put("y_" + count, entity.field_70163_u);
                    returnArray.put("z_" + count, entity.field_70161_v);
                    ++count;
                }
                return new Object[]{returnArray};
            }
            case 1: {
                for (TileEntity jiQi : RadarRegistry.getTileEntitiesInArea((Vector2)new Vector2((double)(this.field_70329_l - 500), (double)(this.field_70327_n - 500)), (Vector2)new Vector2((double)(this.field_70329_l + 500), (double)(this.field_70327_n + 500)))) {
                    returnArray.put("x_" + count, Double.valueOf(jiQi.field_70329_l));
                    returnArray.put("y_" + count, Double.valueOf(jiQi.field_70330_m));
                    returnArray.put("z_" + count, Double.valueOf(jiQi.field_70327_n));
                    ++count;
                }
                return new Object[]{returnArray};
            }
        }
        throw new Exception("Invalid ICBM Radar Function.");
    }

    public void attach(IComputerAccess computer) {
    }

    public void detach(IComputerAccess computer) {
    }

    public void func_70313_j() {
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.ticket);
        RadarRegistry.unregister((TileEntity)this);
        super.func_70313_j();
    }

    public ForgeDirection getDirection() {
        return ForgeDirection.getOrientation((int)this.fangXiang);
    }

    public void setDirection(ForgeDirection facingDirection) {
        this.fangXiang = (byte)facingDirection.ordinal();
    }

    public boolean equals(IPeripheral other) {
        return this.equals(other);
    }
}

