/*
 * Decompiled with CFR 0.152.
 */
package icbm.explosion.machines.launcher;

import com.google.common.io.ByteArrayDataInput;
import icbm.Settings;
import icbm.core.ICBMCore;
import icbm.explosion.entities.EntityMissile;
import icbm.explosion.ex.Ex;
import icbm.explosion.explosive.ExplosiveRegistry;
import icbm.explosion.items.ItemMissile;
import icbm.explosion.machines.launcher.TileLauncherFrame;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import resonant.api.IRotatable;
import resonant.api.ITier;
import resonant.api.explosion.ExplosionEvent;
import resonant.api.explosion.ExplosiveType;
import resonant.api.explosion.IExplosive;
import resonant.api.explosion.ILauncherContainer;
import resonant.api.explosion.ILauncherController;
import resonant.api.explosion.IMissile;
import resonant.lib.multiblock.IBlockActivate;
import resonant.lib.multiblock.IMultiBlock;
import resonant.lib.network.IPacketReceiver;
import resonant.lib.network.PacketHandler;
import resonant.lib.prefab.tile.TileExternalInventory;
import resonant.lib.utility.LanguageUtility;
import universalelectricity.api.vector.IVector3;
import universalelectricity.api.vector.Vector3;
import universalelectricity.api.vector.VectorHelper;

public class TileLauncherBase
extends TileExternalInventory
implements IPacketReceiver,
ILauncherContainer,
IRotatable,
ITier,
IMultiBlock,
IBlockActivate {
    public IMissile missile = null;
    public TileLauncherFrame supportFrame = null;
    private int tier = 0;
    private ForgeDirection facingDirection = ForgeDirection.NORTH;
    private boolean packetGengXin = true;

    public String func_70303_b() {
        return LanguageUtility.getLocal((String)"gui.launcherBase.name");
    }

    public void func_70316_g() {
        super.func_70316_g();
        if (this.supportFrame == null) {
            for (int i = 2; i < 6; i = (int)((byte)(i + 1))) {
                Vector3 position = new Vector3((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n);
                position.translate(ForgeDirection.getOrientation((int)i));
                TileEntity tileEntity = this.field_70331_k.func_72796_p(position.intX(), position.intY(), position.intZ());
                if (!(tileEntity instanceof TileLauncherFrame)) continue;
                this.supportFrame = (TileLauncherFrame)tileEntity;
                this.supportFrame.setDirection(VectorHelper.getOrientationFromSide((ForgeDirection)ForgeDirection.getOrientation((int)i), (ForgeDirection)ForgeDirection.NORTH));
            }
        } else if (this.supportFrame.func_70320_p()) {
            this.supportFrame = null;
        } else if (this.packetGengXin || this.ticks % 600L == 0L && this.supportFrame != null && !this.field_70331_k.field_72995_K) {
            PacketHandler.sendPacketToClients((Packet)this.supportFrame.func_70319_e());
        }
        if (!this.field_70331_k.field_72995_K) {
            this.setMissile();
            if (this.packetGengXin || this.ticks % 600L == 0L) {
                PacketHandler.sendPacketToClients((Packet)this.func_70319_e());
                this.packetGengXin = false;
            }
        }
    }

    public Packet func_70319_e() {
        return ICBMCore.PACKET_TILE.getPacket((TileEntity)this, new Object[]{(byte)this.facingDirection.ordinal(), this.tier});
    }

    public void onReceivePacket(ByteArrayDataInput data, EntityPlayer player, Object ... extra) {
        try {
            this.facingDirection = ForgeDirection.getOrientation((int)data.readByte());
            this.tier = data.readInt();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setMissile() {
        if (!this.field_70331_k.field_72995_K) {
            int explosiveID;
            if (this.func_70301_a(0) != null && this.func_70301_a(0).func_77973_b() instanceof ItemMissile && ExplosiveRegistry.get(explosiveID = this.func_70301_a(0).func_77960_j()) instanceof Ex) {
                Ex missile = (Ex)ExplosiveRegistry.get(explosiveID);
                ExplosionEvent.ExplosivePreDetonationEvent evt = new ExplosionEvent.ExplosivePreDetonationEvent(this.field_70331_k, (double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n, ExplosiveType.AIR, (IExplosive)missile);
                MinecraftForge.EVENT_BUS.post((Event)evt);
                if (!evt.isCanceled()) {
                    if (this.missile == null) {
                        Vector3 startingPosition = new Vector3((double)((float)this.field_70329_l + 0.5f), (double)((float)this.field_70330_m + 1.8f), (double)((float)this.field_70327_n + 0.5f));
                        this.missile = new EntityMissile(this.field_70331_k, startingPosition, new Vector3((TileEntity)this), explosiveID);
                        this.field_70331_k.func_72838_d((Entity)this.missile);
                        return;
                    }
                    if (this.missile.getExplosiveType().getID() == explosiveID) {
                        return;
                    }
                }
            }
            if (this.missile != null) {
                ((Entity)this.missile).func_70106_y();
            }
            this.missile = null;
        }
    }

    public void launchMissile(Vector3 target, int gaoDu) {
        float inaccuracy = this.supportFrame != null ? (float)this.supportFrame.getInaccuracy() : 30.0f;
        target.x += (double)(inaccuracy *= (float)Math.random() * 2.0f - 1.0f);
        target.z += (double)inaccuracy;
        this.func_70298_a(0, 1);
        this.missile.launch(target, gaoDu);
        this.missile = null;
    }

    public boolean isInRange(Vector3 target) {
        if (target != null) {
            return !this.shiTaiYuan(target) && !this.shiTaiJin(target);
        }
        return false;
    }

    public boolean shiTaiJin(Vector3 target) {
        return Vector3.distance((Vector3)new Vector3((double)this.field_70329_l, 0.0, (double)this.field_70327_n), (IVector3)new Vector3(target.x, 0.0, target.z)) < 10.0;
    }

    public boolean shiTaiYuan(Vector3 target) {
        if (this.tier == 0) {
            Vector3 vector3 = new Vector3((double)this.field_70329_l, 0.0, (double)this.field_70327_n);
            Vector3 vector32 = new Vector3(target.x, 0.0, target.z);
            if (Vector3.distance((Vector3)vector3, (IVector3)vector32) < (double)(Settings.DAO_DAN_ZUI_YUAN / 10)) {
                return false;
            }
        } else if (this.tier == 1) {
            Vector3 vector3 = new Vector3((double)this.field_70329_l, 0.0, (double)this.field_70327_n);
            Vector3 vector33 = new Vector3(target.x, 0.0, target.z);
            if (Vector3.distance((Vector3)vector3, (IVector3)vector33) < (double)(Settings.DAO_DAN_ZUI_YUAN / 5)) {
                return false;
            }
        } else if (this.tier == 2) {
            Vector3 vector3 = new Vector3((double)this.field_70329_l, 0.0, (double)this.field_70327_n);
            Vector3 vector34 = new Vector3(target.x, 0.0, target.z);
            if (Vector3.distance((Vector3)vector3, (IVector3)vector34) < (double)Settings.DAO_DAN_ZUI_YUAN) {
                return false;
            }
        }
        return true;
    }

    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.tier = nbt.func_74762_e("tier");
        this.facingDirection = ForgeDirection.getOrientation((int)nbt.func_74771_c("facingDirection"));
    }

    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        nbt.func_74768_a("tier", this.tier);
        nbt.func_74774_a("facingDirection", (byte)this.facingDirection.ordinal());
    }

    public int getTier() {
        return this.tier;
    }

    public void setTier(int tier) {
        this.tier = tier;
    }

    public boolean onActivated(EntityPlayer player) {
        if (player.field_71071_by.func_70448_g() != null) {
            if (player.field_71071_by.func_70448_g().func_77973_b() instanceof ItemMissile) {
                if (this.func_70301_a(0) == null) {
                    this.func_70299_a(0, player.field_71071_by.func_70448_g());
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, null);
                    }
                    return true;
                }
                ItemStack player_held = player.field_71071_by.func_70448_g();
                if (!player.field_71075_bZ.field_75098_d) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, this.func_70301_a(0));
                }
                this.func_70299_a(0, player_held);
                return true;
            }
        } else if (this.func_70301_a(0) != null) {
            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, this.func_70301_a(0));
            this.func_70299_a(0, null);
            return true;
        }
        return true;
    }

    public void func_70313_j() {
        if (this.missile != null) {
            ((Entity)this.missile).func_70106_y();
        }
        super.func_70313_j();
    }

    public Vector3[] getMultiBlockVectors() {
        if (this.facingDirection == ForgeDirection.SOUTH || this.facingDirection == ForgeDirection.NORTH) {
            return new Vector3[]{new Vector3(1.0, 0.0, 0.0), new Vector3(1.0, 1.0, 0.0), new Vector3(1.0, 2.0, 0.0), new Vector3(-1.0, 0.0, 0.0), new Vector3(-1.0, 1.0, 0.0), new Vector3(-1.0, 2.0, 0.0)};
        }
        return new Vector3[]{new Vector3(0.0, 0.0, 1.0), new Vector3(0.0, 1.0, 1.0), new Vector3(0.0, 2.0, 1.0), new Vector3(0.0, 0.0, -1.0), new Vector3(0.0, 1.0, -1.0), new Vector3(0.0, 2.0, -1.0)};
    }

    public ForgeDirection getDirection() {
        return this.facingDirection;
    }

    public void setDirection(ForgeDirection facingDirection) {
        this.facingDirection = facingDirection;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    public boolean canStore(ItemStack stack, int slot, ForgeDirection side) {
        return slot == 0 && stack.func_77973_b() instanceof ItemMissile;
    }

    public IMissile getContainingMissile() {
        return this.missile;
    }

    public void setContainingMissile(IMissile missile) {
        this.missile = missile;
    }

    public ILauncherController getController() {
        for (int i = 2; i < 6; i = (int)((byte)(i + 1))) {
            Vector3 position = new Vector3((TileEntity)this).translate(ForgeDirection.getOrientation((int)i));
            TileEntity tileEntity = position.getTileEntity((IBlockAccess)this.field_70331_k);
            if (!(tileEntity instanceof ILauncherController)) continue;
            return (ILauncherController)tileEntity;
        }
        return null;
    }

    public int[] getMissileSlots() {
        return new int[]{0};
    }
}

