/*
 * Decompiled with CFR 0.152.
 */
package icbm.explosion.machines.launcher;

import calclavia.api.mffs.fortron.FrequencyGrid;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import icbm.core.prefab.TileFrequency;
import net.minecraft.nbt.NBTTagCompound;
import resonant.api.blocks.IBlockFrequency;
import resonant.api.explosion.ILauncherController;
import resonant.api.explosion.LauncherType;
import universalelectricity.api.vector.Vector3;

public abstract class TileLauncherPrefab
extends TileFrequency
implements ILauncherController,
IPeripheral {
    protected Vector3 targetPos = null;

    public void initiate() {
        super.initiate();
        FrequencyGrid.instance().register((IBlockFrequency)this);
    }

    public void func_70313_j() {
        FrequencyGrid.instance().unregister((IBlockFrequency)this);
        super.func_70313_j();
    }

    public Vector3 getTarget() {
        if (this.targetPos == null) {
            this.targetPos = this.getLauncherType() == LauncherType.CRUISE ? new Vector3((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n) : new Vector3((double)this.field_70329_l, 0.0, (double)this.field_70327_n);
        }
        return this.targetPos;
    }

    public void setTarget(Vector3 target) {
        this.targetPos = target.floor();
    }

    public String getType() {
        return "ICBMLauncher";
    }

    public String[] getMethodNames() {
        return new String[]{"launch", "getTarget", "setTarget", "canLaunch", "setFrequency", "getFrequency", "getMissile"};
    }

    public Object[] callMethod(IComputerAccess computer, ILuaContext context, int method, Object[] arguments) throws Exception {
        switch (method) {
            case 0: {
                this.launch();
                return null;
            }
            case 1: {
                return new Object[]{this.getTarget().x, this.getTarget().y, this.getTarget().z};
            }
            case 2: {
                if (arguments[0] != null && arguments[1] != null && arguments[2] != null) {
                    try {
                        this.setTarget(new Vector3(((Double)arguments[0]).doubleValue(), ((Double)arguments[1]).doubleValue(), ((Double)arguments[2]).doubleValue()));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new Exception("Target Parameter is Invalid.");
                    }
                }
                return null;
            }
            case 3: {
                return new Object[]{this.canLaunch()};
            }
            case 4: {
                if (arguments[0] != null) {
                    try {
                        double arg = (Double)arguments[0];
                        arg = Math.max(Math.min(arg, 32767.0), -32768.0);
                        this.setFrequency((short)arg);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new Exception("Frequency Parameter is Invalid.");
                    }
                }
                return null;
            }
            case 5: {
                return new Object[]{this.getFrequency()};
            }
            case 6: {
                if (this.getMissile() != null) {
                    return new Object[]{this.getMissile().getExplosiveType().getMissileName()};
                }
                return null;
            }
        }
        throw new Exception("Invalid ICBM Launcher Function.");
    }

    public void attach(IComputerAccess computer) {
    }

    public void detach(IComputerAccess computer) {
    }

    @Override
    public void func_70307_a(NBTTagCompound nbt) {
        super.func_70307_a(nbt);
        this.targetPos = new Vector3(nbt.func_74775_l("target"));
    }

    @Override
    public void func_70310_b(NBTTagCompound nbt) {
        super.func_70310_b(nbt);
        if (this.targetPos != null) {
            nbt.func_74766_a("target", this.targetPos.writeToNBT(new NBTTagCompound()));
        }
    }

    public boolean equals(IPeripheral other) {
        return this.equals(other);
    }
}

