/*
 * Decompiled with CFR 0.152.
 */
package icbm.explosion.machines.launcher;

import com.google.common.io.ByteArrayDataInput;
import icbm.core.ICBMCore;
import icbm.explosion.ICBMExplosion;
import icbm.explosion.machines.launcher.TileLauncherBase;
import icbm.explosion.machines.launcher.TileLauncherPrefab;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import resonant.api.IRotatable;
import resonant.api.ITier;
import resonant.api.explosion.IMissile;
import resonant.api.explosion.LauncherType;
import resonant.lib.multiblock.IBlockActivate;
import resonant.lib.network.IPacketReceiver;
import resonant.lib.utility.LanguageUtility;
import universalelectricity.api.energy.EnergyStorageHandler;
import universalelectricity.api.vector.Vector3;

public class TileLauncherScreen
extends TileLauncherPrefab
implements IBlockActivate,
ITier,
IRotatable,
IPacketReceiver {
    private byte fangXiang = (byte)3;
    private int tier = 0;
    public TileLauncherBase laucherBase = null;
    public short gaoDu = (short)3;
    private final Set<EntityPlayer> playersUsing = new HashSet<EntityPlayer>();

    public TileLauncherScreen() {
        this.setEnergyHandler(new EnergyStorageHandler(Long.MAX_VALUE));
    }

    @Override
    public void initiate() {
        super.initiate();
        this.getEnergyHandler().setCapacity(this.getLaunchCost() * 2L);
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        if (this.laucherBase == null) {
            for (int i = 2; i < 6; i = (int)((byte)(i + 1))) {
                Vector3 position = new Vector3((double)this.field_70329_l, (double)this.field_70330_m, (double)this.field_70327_n);
                position.translate(ForgeDirection.getOrientation((int)i));
                TileEntity tileEntity = this.field_70331_k.func_72796_p(position.intX(), position.intY(), position.intZ());
                if (tileEntity == null || !(tileEntity instanceof TileLauncherBase)) continue;
                this.laucherBase = (TileLauncherBase)tileEntity;
                this.fangXiang = (byte)i;
            }
        } else if (this.laucherBase.func_70320_p()) {
            this.laucherBase = null;
        }
        if (this.ticks % 100L == 0L && this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n)) {
            this.launch();
        }
        if (!this.field_70331_k.field_72995_K) {
            if (this.ticks % 3L == 0L && this.targetPos == null) {
                this.targetPos = new Vector3((double)this.field_70329_l, 0.0, (double)this.field_70327_n);
            }
            if (this.ticks % 600L == 0L) {
                this.field_70331_k.func_72845_h(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            }
        }
    }

    public Packet func_70319_e() {
        return ICBMCore.PACKET_TILE.getPacket((TileEntity)this, new Object[]{0, this.fangXiang, this.tier, this.getFrequency(), this.gaoDu});
    }

    @Override
    public Packet getGUIPacket() {
        return ICBMCore.PACKET_TILE.getPacket((TileEntity)this, new Object[]{4, this.getEnergyHandler().getEnergy(), this.targetPos.intX(), this.targetPos.intY(), this.targetPos.intZ()});
    }

    public void placeMissile(ItemStack itemStack) {
        if (this.laucherBase != null && !this.laucherBase.func_70320_p()) {
            this.laucherBase.func_70299_a(0, itemStack);
        }
    }

    @Override
    public void onReceivePacket(int id, ByteArrayDataInput data, EntityPlayer player, Object ... extra) throws IOException {
        switch (id) {
            case 0: {
                this.fangXiang = data.readByte();
                this.tier = data.readInt();
                this.setFrequency(data.readInt());
                this.gaoDu = data.readShort();
                break;
            }
            case 1: {
                this.setFrequency(data.readInt());
                break;
            }
            case 2: {
                this.targetPos = new Vector3((double)data.readInt(), (double)data.readInt(), (double)data.readInt());
                if (this.getTier() >= 2) break;
                this.targetPos.y = 0.0;
                break;
            }
            case 3: {
                this.gaoDu = (short)Math.max(Math.min(data.readShort(), Short.MAX_VALUE), 3);
                break;
            }
            case 4: {
                this.getEnergyHandler().setEnergy(data.readLong());
                this.targetPos = new Vector3((double)data.readInt(), (double)data.readInt(), (double)data.readInt());
            }
        }
        super.onReceivePacket(id, data, player, extra);
    }

    public boolean canLaunch() {
        if (this.laucherBase != null && this.laucherBase.missile != null && this.getEnergyHandler().extractEnergy(this.getLaunchCost(), false) >= this.getLaunchCost()) {
            return this.laucherBase.isInRange(this.targetPos);
        }
        return false;
    }

    public void launch() {
        if (this.canLaunch()) {
            this.getEnergyHandler().extractEnergy(this.getLaunchCost(), true);
            this.laucherBase.launchMissile(this.targetPos.clone(), this.gaoDu);
        }
    }

    public String getStatus() {
        String color = "\u00a74";
        String status = LanguageUtility.getLocal((String)"gui.misc.idle");
        if (this.laucherBase == null) {
            status = LanguageUtility.getLocal((String)"gui.launcherScreen.statusMissing");
        } else if (!this.getEnergyHandler().isFull()) {
            status = LanguageUtility.getLocal((String)"gui.launcherScreen.statusNoPower");
        } else if (this.laucherBase.missile == null) {
            status = LanguageUtility.getLocal((String)"gui.launcherScreen.statusEmpty");
        } else if (this.targetPos == null) {
            status = LanguageUtility.getLocal((String)"gui.launcherScreen.statusInvalid");
        } else if (this.laucherBase.shiTaiJin(this.targetPos)) {
            status = LanguageUtility.getLocal((String)"gui.launcherScreen.statusClose");
        } else if (this.laucherBase.shiTaiYuan(this.targetPos)) {
            status = LanguageUtility.getLocal((String)"gui.launcherScreen.statusFar");
        } else {
            color = "\u00a72";
            status = LanguageUtility.getLocal((String)"gui.launcherScreen.statusReady");
        }
        return color + status;
    }

    @Override
    public void func_70307_a(NBTTagCompound par1NBTTagCompound) {
        super.func_70307_a(par1NBTTagCompound);
        this.tier = par1NBTTagCompound.func_74762_e("tier");
        this.fangXiang = par1NBTTagCompound.func_74771_c("facingDirection");
        this.gaoDu = par1NBTTagCompound.func_74765_d("gaoDu");
    }

    @Override
    public void func_70310_b(NBTTagCompound par1NBTTagCompound) {
        super.func_70310_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("tier", this.tier);
        par1NBTTagCompound.func_74774_a("facingDirection", this.fangXiang);
        par1NBTTagCompound.func_74777_a("gaoDu", this.gaoDu);
    }

    @Override
    public long getVoltageInput(ForgeDirection dir) {
        return super.getVoltageInput(dir) * (long)(this.getTier() + 1);
    }

    public int getTier() {
        return this.tier;
    }

    public void setTier(int tier) {
        this.tier = tier;
        this.getEnergyHandler().setCapacity(this.getEnergyCapacity(null));
    }

    public ForgeDirection getDirection() {
        return ForgeDirection.getOrientation((int)this.fangXiang);
    }

    public void setDirection(ForgeDirection facingDirection) {
        this.fangXiang = (byte)facingDirection.ordinal();
    }

    public long getLaunchCost() {
        switch (this.getTier()) {
            case 0: {
                return 50000L;
            }
            case 1: {
                return 80000L;
            }
        }
        return 100000L;
    }

    public boolean onActivated(EntityPlayer entityPlayer) {
        entityPlayer.openGui((Object)ICBMExplosion.instance, 0, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        return true;
    }

    public LauncherType getLauncherType() {
        return LauncherType.TRADITIONAL;
    }

    public IMissile getMissile() {
        if (this.laucherBase != null) {
            return this.laucherBase.getContainingMissile();
        }
        return null;
    }
}

