/*
 * Decompiled with CFR 0.152.
 */
package icbm.explosion.render.tile;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import icbm.core.ICBMCore;
import icbm.explosion.explosive.Explosive;
import icbm.explosion.explosive.ExplosiveRegistry;
import icbm.explosion.explosive.TileExplosive;
import icbm.explosion.model.tiles.MDiLei;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;
import resonant.lib.render.RenderUtility;

@SideOnly(value=Side.CLIENT)
public class RenderBombBlock
extends TileEntitySpecialRenderer
implements ISimpleBlockRenderingHandler {
    public static final ResourceLocation TEXTURE_FILE = new ResourceLocation("icbm", "textures/models/s-mine.png");
    public static final int ID = RenderingRegistry.getNextAvailableRenderId();

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
        if (modelID == ID) {
            if (metadata == Explosive.sMine.getID()) {
                GL11.glPushMatrix();
                GL11.glTranslatef((float)0.0f, (float)1.5f, (float)0.0f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(TEXTURE_FILE);
                MDiLei.INSTANCE.render(0.0625f);
                GL11.glPopMatrix();
            } else {
                try {
                    RenderUtility.renderNormalBlockAsItem((Block)block, (int)metadata, (RenderBlocks)renderer);
                }
                catch (Exception e) {
                    ICBMCore.LOGGER.severe("ICBM Explosive Rendering Crash with: " + block + " and metadata: " + metadata);
                    e.printStackTrace();
                }
            }
        }
    }

    public boolean renderWorldBlock(IBlockAccess iBlockAccess, int x, int y, int z, Block block, int modelID, RenderBlocks renderer) {
        Explosive explosive;
        TileEntity tileEntity;
        if (modelID == ID && (tileEntity = iBlockAccess.func_72796_p(x, y, z)) instanceof TileExplosive && ((explosive = ExplosiveRegistry.get(((TileExplosive)tileEntity).haoMa)).getBlockModel() == null || explosive.getBlockResource() == null)) {
            renderer.func_78570_q(block, x, y, z);
            return true;
        }
        return false;
    }

    public void func_76894_a(TileEntity tileEntity, double x, double y, double z, float f) {
        Explosive explosive;
        if (tileEntity instanceof TileExplosive && (explosive = ExplosiveRegistry.get(((TileExplosive)tileEntity).haoMa)) != null && explosive.getBlockModel() != null && explosive.getBlockResource() != null) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)(x + 0.5), (double)(y + 1.5), (double)(z + 0.5));
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(explosive.getBlockResource());
            explosive.getBlockModel().render(0.0625f);
            RenderUtility.setTerrainTexture();
            GL11.glPopMatrix();
        }
    }

    public boolean shouldRender3DInInventory() {
        return true;
    }

    public int getRenderId() {
        return ID;
    }
}

