/*
 * Decompiled with CFR 0.152.
 */
package icbm.sentry;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import icbm.core.prefab.EmptyRenderer;
import icbm.sentry.CommonProxy;
import icbm.sentry.ICBMSentry;
import icbm.sentry.platform.TileTurretPlatform;
import icbm.sentry.platform.gui.GuiTurretPlatform;
import icbm.sentry.platform.gui.user.GuiUserAccess;
import icbm.sentry.render.RenderAATurret;
import icbm.sentry.render.RenderCrossBowTurret;
import icbm.sentry.render.RenderGunTurret;
import icbm.sentry.render.RenderLaserTurret;
import icbm.sentry.render.RenderRailgun;
import icbm.sentry.turret.EntityMountableDummy;
import icbm.sentry.turret.Turret;
import icbm.sentry.turret.TurretRegistry;
import icbm.sentry.turret.auto.TurretAntiAir;
import icbm.sentry.turret.auto.TurretAutoBow;
import icbm.sentry.turret.auto.TurretGun;
import icbm.sentry.turret.auto.TurretLaser;
import icbm.sentry.turret.block.TileTurret;
import icbm.sentry.turret.mounted.MountedRailgun;
import icbm.sentry.workbench.ammo.GuiMunitionPrinter;
import icbm.sentry.workbench.ammo.TileMunitionPrinter;
import java.awt.Color;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import resonant.api.items.ISimpleItemRenderer;
import resonant.lib.render.fx.FxLaser;
import resonant.lib.render.item.GlobalItemRenderer;
import resonant.lib.utility.nbt.NBTUtility;
import universalelectricity.api.vector.IVector3;

public class ClientProxy
extends CommonProxy {
    @Override
    public void preInit() {
        super.preInit();
    }

    @Override
    public void init() {
        super.init();
        RenderingRegistry.registerEntityRenderingHandler(EntityMountableDummy.class, (Render)new EmptyRenderer());
        TurretRegistry.registerSentryRenderer(TurretAntiAir.class, new RenderAATurret());
        TurretRegistry.registerSentryRenderer(TurretGun.class, new RenderGunTurret());
        TurretRegistry.registerSentryRenderer(TurretLaser.class, new RenderLaserTurret());
        TurretRegistry.registerSentryRenderer(MountedRailgun.class, new RenderRailgun());
        TurretRegistry.registerSentryRenderer(TurretAutoBow.class, new RenderCrossBowTurret());
        GlobalItemRenderer.register((int)ICBMSentry.blockTurret.field_71990_ca, (ISimpleItemRenderer)new ISimpleItemRenderer(){

            public void renderInventoryItem(ItemStack itemStack) {
                Class<? extends Turret> sentry = TurretRegistry.getSentry(NBTUtility.getNBTTagCompound((ItemStack)itemStack).func_74779_i("unlocalizedName"));
                if (sentry != null) {
                    TurretRegistry.getRenderFor(sentry).renderInventoryItem(itemStack);
                }
            }
        });
    }

    @Override
    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof TileTurretPlatform && ID == 0) {
            return new GuiTurretPlatform(player, (TileTurretPlatform)tile);
        }
        if (tile instanceof TileTurret && ID == 1) {
            return new GuiUserAccess(player, tile);
        }
        if (tile instanceof TileMunitionPrinter && ID == 2) {
            return new GuiMunitionPrinter(player.field_71071_by, (TileMunitionPrinter)tile);
        }
        return null;
    }

    @Override
    public void renderBeam(World world, IVector3 position, IVector3 hit, Color color, int age) {
        this.renderBeam(world, position, hit, color.getRed(), color.getGreen(), color.getBlue(), age);
    }

    @Override
    public void renderBeam(World world, IVector3 position, IVector3 target, float red, float green, float blue, int age) {
        FMLClientHandler.instance().getClient().field_71452_i.func_78873_a((EntityFX)new FxLaser(world, position, target, red, green, blue, age));
    }
}

