/*
 * Decompiled with CFR 0.152.
 */
package icbm.sentry.platform;

import icbm.sentry.interfaces.IWeaponProvider;
import icbm.sentry.turret.block.TileTurret;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.ForgeDirection;
import resonant.lib.prefab.tile.TileElectricalInventory;
import resonant.lib.utility.MathUtility;
import universalelectricity.api.CompatibilityModule;
import universalelectricity.api.energy.EnergyStorageHandler;
import universalelectricity.api.energy.IEnergyContainer;
import universalelectricity.api.vector.Vector3;

public class TileTurretPlatform
extends TileElectricalInventory {
    private TileTurret[] turrets = new TileTurret[6];
    private static int[] ammoBaySlots = MathUtility.generateSqeuncedArray((int)0, (int)12);

    public TileTurretPlatform() {
        this.maxSlots = 20;
    }

    public void func_70316_g() {
        super.func_70316_g();
        if (!this.field_70331_k.field_72995_K) {
            for (int i = 0; i < this.func_70302_i_(); ++i) {
                if (this.func_70301_a(i) == null || !CompatibilityModule.isHandler((Object)this.func_70301_a(i).func_77973_b())) continue;
                long charge = CompatibilityModule.dischargeItem((ItemStack)this.func_70301_a(i), (long)Integer.MAX_VALUE, (boolean)false);
                CompatibilityModule.dischargeItem((ItemStack)this.func_70301_a(i), (long)this.onReceiveEnergy(ForgeDirection.UNKNOWN, charge, true), (boolean)true);
            }
        }
        this.turrets = new TileTurret[6];
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity checkTile = new Vector3((TileEntity)this).translate(dir).getTileEntity((IBlockAccess)this.field_70331_k);
            if (!(checkTile instanceof TileTurret)) continue;
            this.turrets[dir.ordinal()] = (TileTurret)checkTile;
        }
    }

    public TileTurret getTurret(ForgeDirection side) {
        return this.turrets[side.ordinal()];
    }

    public boolean canConnect(ForgeDirection direction, Object source) {
        return true;
    }

    public long onReceiveEnergy(ForgeDirection from, long receive, boolean doReceive) {
        long used = 0L;
        long remain = receive;
        for (int i = 0; i < 6; ++i) {
            TileTurret turret = this.turrets[i];
            if (turret == null || !(turret.getTurret() instanceof IEnergyContainer)) continue;
            long added = turret.getTurret().battery.receiveEnergy(remain, doReceive);
            used += added;
            remain -= added;
        }
        return used;
    }

    public EnergyStorageHandler getEnergyHandler() {
        for (TileTurret turretTile : this.turrets) {
            if (turretTile == null || turretTile.getTurret() == null || !(turretTile.getTurret() instanceof IEnergyContainer)) continue;
            return turretTile.getTurret().battery;
        }
        return super.getEnergyHandler();
    }

    public long onExtractEnergy(ForgeDirection from, long extract, boolean doExtract) {
        return 0L;
    }

    public int[] func_94128_d(int side) {
        return ammoBaySlots;
    }

    public boolean canStore(ItemStack stack, int slot, ForgeDirection side) {
        if (stack != null) {
            if (CompatibilityModule.isHandler((Object)stack.func_77973_b())) {
                return true;
            }
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                TileTurret tileTurret = this.getTurret(direction);
                if (tileTurret == null || !(tileTurret.getTurret() instanceof IWeaponProvider) || tileTurret.getTurret().getWeaponSystem() == null) continue;
                return tileTurret.getTurret().getWeaponSystem().isAmmo(stack);
            }
        }
        return false;
    }
}

