/*
 * Decompiled with CFR 0.152.
 */
package icbm.sentry.platform.gui.user;

import cpw.mods.fml.common.FMLCommonHandler;
import icbm.sentry.platform.gui.user.GuiAddUser;
import icbm.sentry.platform.gui.user.GuiEditUser;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import resonant.api.IScroll;
import resonant.lib.References;
import resonant.lib.access.AccessUser;
import resonant.lib.access.IProfileContainer;
import resonant.lib.gui.ContainerDummy;
import resonant.lib.gui.GuiContainerBase;

public class GuiUserAccess
extends GuiContainerBase
implements IScroll {
    private GuiButton[] user_list_buttons = new GuiButton[5];
    private GuiButton scroll_down_button;
    private GuiButton scroll_up_button;
    public static final int SCROLL_UP_BUTTON_ID = 0;
    public static final int SCROLL_DOWN_BUTTON_ID = 1;
    private AccessUser[] loadedUsers = new AccessUser[5];
    private int currentPage = 0;
    private int pageLimit = 0;
    public TileEntity tileEntity;
    public EntityPlayer player;

    public GuiUserAccess(EntityPlayer player, TileEntity tileEntity) {
        super((Container)new ContainerDummy(player, tileEntity));
        this.tileEntity = tileEntity;
        this.player = player;
        this.baseTexture = References.GUI_EMPTY_FILE;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int buttonWidth = 150;
        int buttonHeight = 20;
        int shiftDown = 20;
        int shiftRight = 13;
        this.scroll_up_button = new GuiButton(0, this.field_74198_m + shiftRight, this.field_74197_n + shiftDown, buttonWidth, buttonHeight, "PAGE UP");
        this.scroll_up_button.field_73742_g = false;
        this.field_73887_h.add(this.scroll_up_button);
        this.scroll_down_button = new GuiButton(1, this.field_74198_m + shiftRight, this.field_74197_n + 20 + shiftDown + this.user_list_buttons.length * 20, buttonWidth, buttonHeight, "PAGE DOWN");
        this.field_73887_h.add(this.scroll_down_button);
        for (int i = 0; i < this.user_list_buttons.length; ++i) {
            this.user_list_buttons[i] = new GuiButton(i + 1 + 1, this.field_74198_m + shiftRight, this.field_74197_n + 20 + shiftDown + i * 20, buttonWidth, buttonHeight, "+++++");
            this.user_list_buttons[i].field_73742_g = false;
            this.field_73887_h.add(this.user_list_buttons[i]);
        }
        this.scroll(0);
        this.loadPage(this.currentPage);
    }

    public void loadPage(int page) {
        if (this.tileEntity instanceof IProfileContainer) {
            List users = ((IProfileContainer)this.tileEntity).getAccessProfile().getUsers();
            int nextID = this.currentPage * this.user_list_buttons.length;
            boolean disabled = false;
            for (int i = 0; i < this.loadedUsers.length; ++i) {
                this.loadedUsers[i] = null;
                if (users != null && nextID + i < users.size() && users.get(nextID + i) != null) {
                    AccessUser user;
                    this.loadedUsers[i] = user = (AccessUser)users.get(nextID + i);
                    this.user_list_buttons[i].field_73744_e = (user.getGroup() != null ? "[" + user.getGroup().getName() + "]" : "") + user.getName();
                    this.user_list_buttons[i].field_73742_g = true;
                    continue;
                }
                if (disabled) {
                    this.user_list_buttons[i].field_73742_g = false;
                    this.user_list_buttons[i].field_73744_e = "-----";
                } else {
                    this.user_list_buttons[i].field_73742_g = true;
                    this.user_list_buttons[i].field_73744_e = "Add User";
                }
                disabled = true;
            }
        }
    }

    protected void func_73875_a(GuiButton button) {
        super.func_73875_a(button);
        if (button.field_73741_f == 0) {
            this.scroll(-1);
        } else if (button.field_73741_f == 1) {
            this.scroll(1);
        } else if (button.field_73741_f > 1 && button.field_73741_f < this.user_list_buttons.length + 1 + 1) {
            AccessUser user = this.loadedUsers[button.field_73741_f - 2];
            if (user != null) {
                FMLCommonHandler.instance().showGuiScreen((Object)new GuiEditUser(this, user));
            } else {
                FMLCommonHandler.instance().showGuiScreen((Object)new GuiAddUser(this));
            }
        }
    }

    protected void func_74189_g(int x, int y) {
        super.func_74189_g(x, y);
        this.loadPage(this.currentPage);
        this.scroll(0);
    }

    public void scroll(int amount) {
        this.setScroll(this.getScroll() + amount);
        this.scroll_down_button.field_73742_g = this.currentPage != this.pageLimit;
        this.scroll_up_button.field_73742_g = this.currentPage != 0;
    }

    public void setScroll(int length) {
        this.currentPage = length;
        if (this.currentPage > this.pageLimit) {
            this.currentPage = this.pageLimit;
        }
        if (this.currentPage < 0) {
            this.currentPage = 0;
        }
    }

    public int getScroll() {
        return this.currentPage;
    }
}

